/* face-finger.c -- How and what faces look like in GNU Finger. */

/* Copyright (C) 1988, 1990, 1992 Free Software Foundation, Inc.

   This file is part of GNU Finger.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <stdio.h>
#include <config.h>
#include <bitmap.h>

/* **************************************************************** */
/*								    */
/*			`Fac'ing up to things.			    */
/*								    */
/* **************************************************************** */

/* Write the bits of USER's face on STREAM, in the standard face format.
   If we can.  We first send the width, the height, and the length of
   each row in bytes.  These are printed in ASCII representation.  Then
   we send height lines of width bytes.  We don't care about byte swapping,
   because any finger that calls us knows the standard format of bitmaps. */
void
send_face (user, stream)
     char *user;
     FILE *stream;
{
  register int i;
  register byte *bits;
  int output = fileno (stream);
  BITMAP *site_read_face (), *face = site_read_face (user);

  if (!face)
    return;

  fprintf (stream, "%d,%d,%d\r\n", face->width, face->height, face->rowlen);
  fflush (stream);

  for (i = 0, bits = face->bits; i < face->height; i++, bits += face->rowlen)
    write (output, bits, face->rowlen);
}

/* Tell CONNECTION to send us the face for USER, and then display that
   face.  Returns non-zero if CONNECTION had a face for USER. */
int
face_finger (user, connection)
     char *user;
     int connection;
{
  BITMAP *face, *get_face_bits ();

  face = get_face_bits (user, connection);

  if (!face)
    return (0);

  site_show_face (user, face);
  free (face->bits);
  free (face);
  return (1);
}

/* Read a BITMAP * from CONNECTION.  USER is the name of the user to
   read the bits for. */
BITMAP *
get_face_bits (user, connection)
     char *user;
     int connection;
{
  FILE *stream;
  int fd;

  register int i;
  register byte *bits;

  int width, height, rowlen, size;

  BITMAP *output = (BITMAP *)NULL;

  fd = dup (connection);

  if ((stream = fdopen (fd, "r+")) == (FILE *)NULL)
    return ((BITMAP *)NULL);

  fprintf (stream, ":%s:\r\n", user);
  fflush (stream);
  fseek (stream, 0l, 1);

  /* Find out how much info is on the way. */

  if (fscanf (stream, "%d,%d,%d\r\n", &width, &height, &rowlen) != 3)
    {
      fclose (stream);
      return ((BITMAP *)NULL);
    }

  /* Okay, now get the bits. */

  size = rowlen * height;

  output = (BITMAP *)xmalloc (sizeof (BITMAP));
  output->width = width;
  output->height = height;
  output->rowlen = rowlen;
  output->bits = (byte *)xmalloc (size);

  for (i = 0, bits = output->bits; i < height; i++, bits += rowlen)
    fread (bits, 1, rowlen, stream);

  fclose (stream);
  return (output);
}
