/* client.h -- Data structures used by the useful GNU finger. */

#if !defined (_CLIENT_H_)
#define _CLIENT_H_

/* Copyright (C) 1988, 1990, 1992 Free Software Foundation, Inc.

   This file is part of GNU Finger.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* What a client looks like. */
typedef struct
{
  char hostname[512];
  char address[4];

  /* Is this client even up? */
  int client_up;

  /* Number of active users. */
  int users;

  /* If up, length of time idle. */
  long idle_time;

  /* Number of times successfully polled. */
  long times_polled;

  /* cfinger port number or service on client */
  char port[64];
} CLIENT;

#endif /* _CLIENT_H_ */
