/* VGAlib version 1.2 - (c) 1993 Tommy Frandsen 		   */
/*								   */
/* This library is free software; you can redistribute it and/or   */
/* modify it without any restrictions. This library is distributed */
/* in the hope that it will be useful, but without any warranty.   */

/* Multi-chipset support Copyright 1993 Harm Hanemaayer */

#include <stdio.h>
#include "vga.h"
#include "libvga.h"
#include "driver.h"


int vga_dumpregs()
{
    unsigned char regs[MAX_REGS];
    int i, n;

    __vga_getchipset();

    n = __vga_saveregs(regs);

    printf("static unsigned char regs[%d] = {\n  ", n);

    for (i = 0; i < 12; i++) 
        printf("0x%02X,", regs[CRT+i]);
    printf("\n  "); 
    for (i = 12; i < CRT_C; i++) 
        printf("0x%02X,", regs[CRT+i]);
    printf("\n  "); 
    for (i = 0; i < 12; i++) 
        printf("0x%02X,", regs[ATT+i]);
    printf("\n  "); 
    for (i = 12; i < ATT_C; i++) 
        printf("0x%02X,", regs[ATT+i]);
    printf("\n  "); 
    for (i = 0; i < GRA_C; i++) 
        printf("0x%02X,", regs[GRA+i]);
    printf("\n  "); 
    for (i = 0; i < SEQ_C; i++) 
        printf("0x%02X,", regs[SEQ+i]);
    printf("\n  "); 
    printf("0x%02X", regs[MIS]);


    n -= 60;
    if (n > 0) {
	fputs(",\n  ", stdout);
	i=0;
	while (i < n - 1)
	    {
            printf("0x%02X,", regs[EXT + i++]);
	    if ( ! ( i % 10) )
		fputs("\n  ", stdout);
	    }
	printf("0x%02X", regs[EXT + n - 1]);
    }

    printf("\n};\n"); 

    return 0;
}
