#include <mbase.h>

/*
 * PROTOTYPES -----------------------------------------------------------------
 *
 */

   void main XARGS( (void) );

#define freak() { fputs (mb_error, stderr); mb_exit(1); }


/*
 * CODE -----------------------------------------------------------------------
 *
 */

void
main ()
{
   relation *rel;


   if (access ("example3.rel", 0) != -1)
      {
      printf ("'example3.rel' already exists.\n");
      exit(0);
      }


   if ((rel = mb_new()) == RNULL)  freak();

   if (mb_addfield (rel, "lastname",  T_CHAR,   30L))  freak();
   if (mb_addfield (rel, "firstname", T_CHAR,   30L))  freak();
   if (mb_addfield (rel, "phonenum",  T_PHONE,   0L))  freak();
   if (mb_addfield (rel, "serialnum", T_SERIAL, 20L))  freak();
   if (mb_addfield (rel, "enterdate", T_DATE,    0L))  freak();

   if (mb_addindex (rel, "ix_name", FALSE, "0,1"))  freak();
   if (mb_addindex (rel, "ix_ser",  FALSE,   "3"))  freak();
   if (mb_addindex (rel, "ix_date", TRUE,    "4"))  freak();

   if (mb_create (rel, "example3", FALSE))  freak();


   printf ("relation created successfully.\n");

   mb_exit (0);  /* Frees memory allocated for 'rel' */
}

