------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                             S I N P U T . L                              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.1 $                              --
--                                                                          --
--        Copyright (c) 1992,1993,1994,1995 NYU, All Rights Reserved        --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Alloc;  use Alloc;
with Debug;  use Debug;
with Namet;  use Namet;
with Osint;  use Osint;
with Output; use Output;

package body Sinput.L is

   ----------------------
   -- Load_Source_File --
   ----------------------

   function Load_Source_File
     (N    : File_Name_Type)
      return Source_File_Index
   is
      Src  : Source_Buffer_Ptr;
      Lptr : Lines_Table_Ptr;
      X    : Source_File_Index;

   begin
      for J in 1 .. Source_File.Last loop
         if Source_File.Table (J).File_Name = N then
            Source_Cache_Index := J;
            Source_Cache := Source_File.Table (J).Source_Text;
            return J;
         end if;
      end loop;

      --  Here we must build a new entry in the file table

      Src := Read_Source_File (N);

      if Src = null then
         return No_Source_File;

      else
         Source_File.Increment_Last;
         X := Source_File.Last;

         if Debug_Flag_L then
            Write_Str ("*** Build source file table entry, Index = ");
            Write_Int (Int (X));
            Write_Str (", file name = ");
            Write_Name (N);
            Write_Eol;
         end if;

         Lptr := new Lines_Table_Type (1 .. Alloc_Lines_Initial);
         Lptr (1) := Src'First;

         Source_File.Table (X).File_Name         := N;
         Source_File.Table (X).Full_File_Name    := Full_Source_Name;
         Source_File.Table (X).Reference_Name    := Full_Source_Name;
         Source_File.Table (X).Line_Offset       := 0;
         Source_File.Table (X).Source_Text       := Src;
         Source_File.Table (X).Time_Stamp        := Current_Source_File_Stamp;
         Source_File.Table (X).Lines_Table       := Lptr;
         Source_File.Table (X).Num_Source_Lines  := 1;
         Source_File.Table (X).Keyword_Casing    := Unknown;
         Source_File.Table (X).Identifier_Casing := Unknown;

         Source_Cache := Src;
         Source_Cache_Index := X;
         return X;
      end if;
   end Load_Source_File;

end Sinput.L;
