------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                      S Y S T E M . W W D _ E N U M                       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- The GNAT library is free software; you can redistribute it and/or modify --
-- it under terms of the GNU Library General Public License as published by --
-- the Free Software  Foundation; either version 2, or (at your option) any --
-- later version.  The GNAT library is distributed in the hope that it will --
-- be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty --
-- of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU --
-- Library  General  Public  License for  more  details.  You  should  have --
-- received  a copy of the GNU  Library  General Public License  along with --
-- the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free --
-- Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        --
--                                                                          --
------------------------------------------------------------------------------

with Unchecked_Conversion;

with System.WCh_StW; use System.WCh_StW;

package body System.WWd_Enum is

   ----------------------------
   -- Wide_Width_Enumeration --
   ----------------------------

   function Wide_Width_Enumeration
     (Table  : Address;
      Lo, Hi : Natural;
      EM     : WC_Encoding_Method)
      return   Natural
   is
      type String_Access is access String;
      type Enum_Table is array (Natural) of String_Access;
      type Enum_Table_Ptr is access Enum_Table;
      function A_To_T is new Unchecked_Conversion (Address, Enum_Table_Ptr);

      T : constant Enum_Table_Ptr := A_To_T (Table);
      W : Natural;

   begin
      W := 0;

      for J in Lo .. Hi loop
         declare
            WS : constant Wide_String :=
              String_To_Wide_String (T (J).all, EM);

         begin
            W := Natural'Max (W, WS'Length);
         end;
      end loop;

      return W;
   end Wide_Width_Enumeration;

end System.WWd_Enum;
