------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                               O U T P U T                                --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.25 $                             --
--                                                                          --
--        Copyright (c) 1992,1993,1994,1995 NYU, All Rights Reserved        --
--                                                                          --
-- The GNAT library is free software; you can redistribute it and/or modify --
-- it under terms of the GNU Library General Public License as published by --
-- the Free Software  Foundation; either version 2, or (at your option) any --
-- later version.  The GNAT library is distributed in the hope that it will --
-- be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty --
-- of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU --
-- Library  General  Public  License for  more  details.  You  should  have --
-- received  a copy of the GNU  Library  General Public License  along with --
-- the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free --
-- Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        --
--                                                                          --
------------------------------------------------------------------------------

package body Output is

   Current_Column : Int := 1;
   --  Current column number

   Current_FD : File_Descriptor := Standout;
   --  File descriptor for current output

   Saved_FD : File_Descriptor;

   -------------
   --  Column --
   -------------

   function Column return Int is
   begin
      return Current_Column;
   end Column;

   -----------------------
   -- Restore_Output_FD --
   -----------------------

   procedure Restore_Output_FD is
   begin
      Current_FD := Saved_FD;
   end Restore_Output_FD;

   -------------------
   -- Set_Output_FD --
   -------------------

   procedure Set_Output_FD (FD : File_Descriptor) is
   begin
      Saved_FD   := Current_FD;
      Current_FD := FD;
   end Set_Output_FD;

   ------------------------
   -- Set_Standard_Error --
   ------------------------

   procedure Set_Standard_Error is
   begin
      Current_FD := Standerr;
   end Set_Standard_Error;

   -------------------------
   -- Set_Standard_Output --
   -------------------------

   procedure Set_Standard_Output is
   begin
      Current_FD := Standout;
   end Set_Standard_Output;

   ----------------
   -- Write_Char --
   ----------------

   procedure Write_Char (C : Character) is
   begin
      Write (Current_FD, C'Address, 1);
      Current_Column := Current_Column + 1;
   end Write_Char;

   ---------------
   -- Write_Eol --
   ---------------

   procedure Write_Eol is
   begin
      Write_Char (Ascii.LF);
      Current_Column := 1;
   end Write_Eol;

   ---------------
   -- Write_Int --
   ---------------

   procedure Write_Int (I : Int) is
   begin

      if I < 0 then
         Write_Char ('-');
         Write_Int (-I);

      else
         if I > 9 then
            Write_Int (I / 10);
         end if;

         Write_Char (Character'Val ((I mod 10) + 48));
      end if;
   end Write_Int;

   ---------------
   -- Write_Str --
   ---------------

   procedure Write_Str (S : String) is
   begin
      Write (Current_FD, S'Address, S'Length);
      Current_Column := Current_Column + S'Length;
   end Write_Str;

   --------------------------
   -- Debugging Procedures --
   --------------------------

   procedure w (C : Character) is
   begin
      Write_Char (''');
      Write_Char (C);
      Write_Char (''');
      Write_Eol;
   end w;

   procedure w (S : String) is
   begin
      Write_Str (S);
      Write_Eol;
   end w;

   procedure w (I : Int) is
   begin
      Write_Int (I);
      Write_Eol;
   end w;

   procedure w (B : Boolean) is
   begin
      if B then
         w ("True");
      else
         w ("False");
      end if;
   end w;

   procedure w (L : String; C : Character) is
   begin
      Write_Str (L);
      Write_Char (' ');
      w (C);
   end w;

   procedure w (L : String; S : String) is
   begin
      Write_Str (L);
      Write_Char (' ');
      w (S);
   end w;

   procedure w (L : String; I : Int) is
   begin
      Write_Str (L);
      Write_Char (' ');
      w (I);
   end w;

   procedure w (L : String; B : Boolean) is
   begin
      Write_Str (L);
      Write_Char (' ');
      w (B);
   end w;

end Output;
