/* 
 * s2ul.h for ztalk
 */

/*
 * Copyright 1992 by Jutta Degener and Carsten Bormann, Technische
 * Universitaet Berlin.  See the accompanying file "COPYRIGHT" for
 * details.  THERE IS ABSOLUTELY NO WARRANTY FOR THIS SOFTWARE.
 */

/* $Header: /home/kbs/jutta/src/gsm/gsm-1.0/src/RCS/toast_ulaw.c,v 1.1 1992/10/28 00:15:50 jutta Exp $ */

/* toast_ulaw -- functions to manipulate u-law encoded sound.
 */


#define	S2U(x)	(s2u[ ((unsigned short)(x)) >> 3 ])

static unsigned char s2u[] = {
0377,0376,0375,0374,0373,0372,0371,0370,0367,0366,0365,0364,0363,0362,0361,
0360,0357,0357,0356,0356,0355,0355,0354,0354,0353,0353,0352,0352,0351,0351,
0350,0350,0347,0347,0346,0346,0345,0345,0344,0344,0343,0343,0342,0342,0341,
0341,0340,0340,0337,0337,0337,0337,0336,0336,0336,0336,0335,0335,0335,0335,
0334,0334,0334,0334,0333,0333,0333,0333,0332,0332,0332,0332,0331,0331,0331,
0331,0330,0330,0330,0330,0327,0327,0327,0327,0326,0326,0326,0326,0325,0325,
0325,0325,0324,0324,0324,0324,0323,0323,0323,0323,0322,0322,0322,0322,0321,
0321,0321,0321,0320,0320,0320,0320,0317,0317,0317,0317,0317,0317,0317,0317,
0316,0316,0316,0316,0316,0316,0316,0316,0315,0315,0315,0315,0315,0315,0315,
0315,0314,0314,0314,0314,0314,0314,0314,0314,0313,0313,0313,0313,0313,0313,
0313,0313,0312,0312,0312,0312,0312,0312,0312,0312,0311,0311,0311,0311,0311,
0311,0311,0311,0310,0310,0310,0310,0310,0310,0310,0310,0307,0307,0307,0307,
0307,0307,0307,0307,0306,0306,0306,0306,0306,0306,0306,0306,0305,0305,0305,
0305,0305,0305,0305,0305,0304,0304,0304,0304,0304,0304,0304,0304,0303,0303,
0303,0303,0303,0303,0303,0303,0303,0302,0302,0302,0302,0302,0302,0302,0302,
0301,0301,0301,0301,0301,0301,0301,0301,0300,0300,0300,0300,0300,0300,0300,
0300,0277,0277,0277,0277,0277,0277,0277,0277,0277,0277,0277,0277,0277,0277,
0277,0277,0276,0276,0276,0276,0276,0276,0276,0276,0276,0276,0276,0276,0276,
0276,0276,0276,0275,0275,0275,0275,0275,0275,0275,0275,0275,0275,0275,0275,
0275,0275,0275,0275,0274,0274,0274,0274,0274,0274,0274,0274,0274,0274,0274,
0274,0274,0274,0274,0274,0273,0273,0273,0273,0273,0273,0273,0273,0273,0273,
0273,0273,0273,0273,0273,0273,0272,0272,0272,0272,0272,0272,0272,0272,0272,
0272,0272,0272,0272,0272,0272,0272,0271,0271,0271,0271,0271,0271,0271,0271,
0271,0271,0271,0271,0271,0271,0271,0271,0270,0270,0270,0270,0270,0270,0270,
0270,0270,0270,0270,0270,0270,0270,0270,0270,0267,0267,0267,0267,0267,0267,
0267,0267,0267,0267,0267,0267,0267,0267,0267,0267,0266,0266,0266,0266,0266,
0266,0266,0266,0266,0266,0266,0266,0266,0266,0266,0266,0265,0265,0265,0265,
0265,0265,0265,0265,0265,0265,0265,0265,0265,0265,0265,0265,0264,0264,0264,
0264,0264,0264,0264,0264,0264,0264,0264,0264,0264,0264,0264,0264,0263,0263,
0263,0263,0263,0263,0263,0263,0263,0263,0263,0263,0263,0263,0263,0263,0262,
0262,0262,0262,0262,0262,0262,0262,0262,0262,0262,0262,0262,0262,0262,0262,
0262,0261,0261,0261,0261,0261,0261,0261,0261,0261,0261,0261,0261,0261,0261,
0261,0261,0260,0260,0260,0260,0260,0260,0260,0260,0260,0260,0260,0260,0260,
0260,0260,0260,0257,0257,0257,0257,0257,0257,0257,0257,0257,0257,0257,0257,
0257,0257,0257,0257,0257,0257,0257,0257,0257,0257,0257,0257,0257,0257,0257,
0257,0257,0257,0257,0257,0256,0256,0256,0256,0256,0256,0256,0256,0256,0256,
0256,0256,0256,0256,0256,0256,0256,0256,0256,0256,0256,0256,0256,0256,0256,
0256,0256,0256,0256,0256,0256,0256,0255,0255,0255,0255,0255,0255,0255,0255,
0255,0255,0255,0255,0255,0255,0255,0255,0255,0255,0255,0255,0255,0255,0255,
0255,0255,0255,0255,0255,0255,0255,0255,0255,0254,0254,0254,0254,0254,0254,
0254,0254,0254,0254,0254,0254,0254,0254,0254,0254,0254,0254,0254,0254,0254,
0254,0254,0254,0254,0254,0254,0254,0254,0254,0254,0254,0253,0253,0253,0253,
0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,
0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,0253,0252,0252,
0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,
0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,0252,
0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,
0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,0251,
0251,0251,0251,0250,0250,0250,0250,0250,0250,0250,0250,0250,0250,0250,0250,
0250,0250,0250,0250,0250,0250,0250,0250,0250,0250,0250,0250,0250,0250,0250,
0250,0250,0250,0250,0250,0247,0247,0247,0247,0247,0247,0247,0247,0247,0247,
0247,0247,0247,0247,0247,0247,0247,0247,0247,0247,0247,0247,0247,0247,0247,
0247,0247,0247,0247,0247,0247,0247,0246,0246,0246,0246,0246,0246,0246,0246,
0246,0246,0246,0246,0246,0246,0246,0246,0246,0246,0246,0246,0246,0246,0246,
0246,0246,0246,0246,0246,0246,0246,0246,0246,0245,0245,0245,0245,0245,0245,
0245,0245,0245,0245,0245,0245,0245,0245,0245,0245,0245,0245,0245,0245,0245,
0245,0245,0245,0245,0245,0245,0245,0245,0245,0245,0245,0244,0244,0244,0244,
0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,
0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,0244,0243,0243,
0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,
0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,0243,
0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,
0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,0242,
0242,0242,0242,0241,0241,0241,0241,0241,0241,0241,0241,0241,0241,0241,0241,
0241,0241,0241,0241,0241,0241,0241,0241,0241,0241,0241,0241,0241,0241,0241,
0241,0241,0241,0241,0241,0240,0240,0240,0240,0240,0240,0240,0240,0240,0240,
0240,0240,0240,0240,0240,0240,0240,0240,0240,0240,0240,0240,0240,0240,0240,
0240,0240,0240,0240,0240,0240,0240,0237,0237,0237,0237,0237,0237,0237,0237,
0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,
0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,
0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,
0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0237,0236,0236,0236,0236,
0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,
0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,
0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,
0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,0236,
0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,
0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,
0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,
0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,0235,
0235,0235,0235,0235,0235,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,
0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,
0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,
0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,0234,
0234,0234,0234,0234,0234,0234,0234,0234,0234,0233,0233,0233,0233,0233,0233,
0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,
0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,
0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,
0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0233,0232,0232,
0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,
0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,
0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,
0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,0232,
0232,0232,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,
0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,
0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,
0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,0231,
0231,0231,0231,0231,0231,0231,0231,0230,0230,0230,0230,0230,0230,0230,0230,
0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,
0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,
0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,
0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0230,0227,0227,0227,0227,
0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,
0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,
0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,
0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,0227,
0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,
0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,
0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,
0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,0226,
0226,0226,0226,0226,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,
0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,
0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,
0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,0225,
0225,0225,0225,0225,0225,0225,0225,0225,0225,0224,0224,0224,0224,0224,0224,
0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,
0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,
0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,
0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0224,0223,0223,
0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,
0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,
0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,
0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,0223,
0223,0223,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,
0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,
0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,
0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,0222,
0222,0222,0222,0222,0222,0222,0221,0221,0221,0221,0221,0221,0221,0221,0221,
0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,
0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,
0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,
0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0221,0220,0220,0220,0220,
0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,
0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,
0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,
0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,0220,
0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,
0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,
0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,
0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,
0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,
0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,
0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,
0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,0217,
0217,0217,0217,0217,0217,0217,0217,0217,0217,0216,0216,0216,0216,0216,0216,
0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,
0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,
0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,
0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,
0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,
0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,
0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,
0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,0216,
0216,0216,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,
0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,
0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,
0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,
0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,
0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,
0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,
0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,
0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0215,0214,0214,0214,0214,
0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,
0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,
0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,
0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,
0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,
0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,
0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,
0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,0214,
0214,0214,0214,0214,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,
0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,
0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,
0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,
0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,
0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,
0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,
0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,
0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0213,0212,0212,
0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,
0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,
0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,
0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,
0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,
0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,
0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,
0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,0212,
0212,0212,0212,0212,0212,0212,0211,0211,0211,0211,0211,0211,0211,0211,0211,
0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,
0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,
0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,
0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,
0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,
0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,
0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,
0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,0211,
0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,
0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,
0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,
0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,
0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,
0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,
0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,
0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,0210,
0210,0210,0210,0210,0210,0210,0210,0210,0207,0207,0207,0207,0207,0207,0207,
0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,
0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,
0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,
0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,
0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,
0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,
0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,
0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,0207,
0207,0207,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,
0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,
0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,
0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,
0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,
0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,
0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,
0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,
0206,0206,0206,0206,0206,0206,0206,0206,0206,0206,0205,0205,0205,0205,0205,
0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,
0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,
0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,
0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,
0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,
0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,
0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,
0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,0205,
0205,0205,0205,0205,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,
0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,
0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,
0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,
0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,
0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,
0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,
0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,
0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0204,0203,0203,0203,
0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,
0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,
0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,
0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,
0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,
0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,
0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,
0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,0203,
0203,0203,0203,0203,0203,0203,0202,0202,0202,0202,0202,0202,0202,0202,0202,
0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,
0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,
0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,
0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,
0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,
0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,
0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,
0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0202,0201,
0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,
0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,
0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,
0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,
0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,
0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,
0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,
0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,0201,
0201,0201,0201,0201,0201,0201,0201,0201,0200,0200,0200,0200,0200,0200,0200,
0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,
0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,
0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,
0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,
0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,
0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,
0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,
0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,0200,
0200,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,0000,
0000,0000,0000,0000,0000,0000,0000,0000,0000,0001,0001,0001,0001,0001,0001,
0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,
0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,
0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,
0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,
0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,
0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,
0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,
0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,0001,
0001,0001,0001,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,
0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,
0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,
0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,
0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,
0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,
0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,
0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,
0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0002,0003,0003,0003,0003,
0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,
0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,
0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,
0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,
0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,
0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,
0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,
0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,0003,
0003,0003,0003,0003,0003,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,
0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,
0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,
0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,
0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,
0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,
0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,
0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,
0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0004,0005,0005,
0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,
0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,
0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,
0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,
0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,
0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,
0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,
0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,0005,
0005,0005,0005,0005,0005,0005,0005,0006,0006,0006,0006,0006,0006,0006,0006,
0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,
0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,
0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,
0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,
0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,
0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,
0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,
0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,0006,
0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,
0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,
0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,
0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,
0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,
0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,
0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,
0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,0007,
0007,0007,0007,0007,0007,0007,0007,0007,0007,0010,0010,0010,0010,0010,0010,
0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,
0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,
0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,
0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,
0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,
0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,
0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,
0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,0010,
0010,0010,0010,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,
0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,
0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,
0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,
0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,
0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,
0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,
0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,
0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0011,0012,0012,0012,0012,
0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,
0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,
0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,
0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,
0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,
0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,
0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,
0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,0012,
0012,0012,0012,0012,0012,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,
0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,
0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,
0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,
0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,
0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,
0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,
0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,
0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0013,0014,0014,
0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,
0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,
0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,
0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,
0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,
0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,
0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,
0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,0014,
0014,0014,0014,0014,0014,0014,0014,0015,0015,0015,0015,0015,0015,0015,0015,
0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,
0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,
0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,
0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,
0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,
0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,
0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,
0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,0015,
0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,
0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,
0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,
0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,
0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,
0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,
0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,
0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,0016,
0016,0016,0016,0016,0016,0016,0016,0016,0016,0017,0017,0017,0017,0017,0017,
0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,
0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,
0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,
0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,
0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,
0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,
0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,
0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,0017,
0017,0017,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,
0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,
0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,
0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,0020,
0020,0020,0020,0020,0020,0020,0021,0021,0021,0021,0021,0021,0021,0021,0021,
0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,
0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,
0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,
0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0021,0022,0022,0022,0022,
0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,
0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,
0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,
0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,0022,
0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,
0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,
0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,
0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,0023,
0023,0023,0023,0023,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,
0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,
0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,
0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,0024,
0024,0024,0024,0024,0024,0024,0024,0024,0024,0025,0025,0025,0025,0025,0025,
0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,
0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,
0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,
0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0025,0026,0026,
0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,
0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,
0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,
0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,0026,
0026,0026,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,
0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,
0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,
0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,0027,
0027,0027,0027,0027,0027,0027,0030,0030,0030,0030,0030,0030,0030,0030,0030,
0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,
0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,
0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,
0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0030,0031,0031,0031,0031,
0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,
0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,
0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,
0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,0031,
0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,
0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,
0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,
0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,0032,
0032,0032,0032,0032,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,
0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,
0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,
0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,0033,
0033,0033,0033,0033,0033,0033,0033,0033,0034,0034,0034,0034,0034,0034,0034,
0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,
0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,
0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,
0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0034,0035,0035,
0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,
0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,
0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,
0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,0035,
0035,0035,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,
0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,
0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,
0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,0036,
0036,0036,0036,0036,0036,0036,0037,0037,0037,0037,0037,0037,0037,0037,0037,
0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,
0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,
0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,
0037,0037,0037,0037,0037,0037,0037,0037,0037,0037,0040,0040,0040,0040,0040,
0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,
0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,0040,0041,0041,
0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,
0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,0041,
0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,
0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,0042,
0042,0042,0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,
0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,0043,
0043,0043,0043,0043,0044,0044,0044,0044,0044,0044,0044,0044,0044,0044,0044,
0044,0044,0044,0044,0044,0044,0044,0044,0044,0044,0044,0044,0044,0044,0044,
0044,0044,0044,0044,0044,0044,0045,0045,0045,0045,0045,0045,0045,0045,0045,
0045,0045,0045,0045,0045,0045,0045,0045,0045,0045,0045,0045,0045,0045,0045,
0045,0045,0045,0045,0045,0045,0045,0045,0046,0046,0046,0046,0046,0046,0046,
0046,0046,0046,0046,0046,0046,0046,0046,0046,0046,0046,0046,0046,0046,0046,
0046,0046,0046,0046,0046,0046,0046,0046,0046,0046,0047,0047,0047,0047,0047,
0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,
0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,0047,0050,0050,
0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,
0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,0050,
0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,
0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,0051,
0051,0051,0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,
0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,0052,
0052,0052,0052,0052,0053,0053,0053,0053,0053,0053,0053,0053,0053,0053,0053,
0053,0053,0053,0053,0053,0053,0053,0053,0053,0053,0053,0053,0053,0053,0053,
0053,0053,0053,0053,0053,0053,0054,0054,0054,0054,0054,0054,0054,0054,0054,
0054,0054,0054,0054,0054,0054,0054,0054,0054,0054,0054,0054,0054,0054,0054,
0054,0054,0054,0054,0054,0054,0054,0054,0055,0055,0055,0055,0055,0055,0055,
0055,0055,0055,0055,0055,0055,0055,0055,0055,0055,0055,0055,0055,0055,0055,
0055,0055,0055,0055,0055,0055,0055,0055,0055,0055,0056,0056,0056,0056,0056,
0056,0056,0056,0056,0056,0056,0056,0056,0056,0056,0056,0056,0056,0056,0056,
0056,0056,0056,0056,0056,0056,0056,0056,0056,0056,0056,0056,0057,0057,0057,
0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,
0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,0057,
0060,0060,0060,0060,0060,0060,0060,0060,0060,0060,0060,0060,0060,0060,0060,
0060,0061,0061,0061,0061,0061,0061,0061,0061,0061,0061,0061,0061,0061,0061,
0061,0061,0062,0062,0062,0062,0062,0062,0062,0062,0062,0062,0062,0062,0062,
0062,0062,0062,0063,0063,0063,0063,0063,0063,0063,0063,0063,0063,0063,0063,
0063,0063,0063,0063,0064,0064,0064,0064,0064,0064,0064,0064,0064,0064,0064,
0064,0064,0064,0064,0064,0065,0065,0065,0065,0065,0065,0065,0065,0065,0065,
0065,0065,0065,0065,0065,0065,0066,0066,0066,0066,0066,0066,0066,0066,0066,
0066,0066,0066,0066,0066,0066,0066,0067,0067,0067,0067,0067,0067,0067,0067,
0067,0067,0067,0067,0067,0067,0067,0067,0070,0070,0070,0070,0070,0070,0070,
0070,0070,0070,0070,0070,0070,0070,0070,0070,0071,0071,0071,0071,0071,0071,
0071,0071,0071,0071,0071,0071,0071,0071,0071,0071,0072,0072,0072,0072,0072,
0072,0072,0072,0072,0072,0072,0072,0072,0072,0072,0072,0073,0073,0073,0073,
0073,0073,0073,0073,0073,0073,0073,0073,0073,0073,0073,0073,0074,0074,0074,
0074,0074,0074,0074,0074,0074,0074,0074,0074,0074,0074,0074,0074,0075,0075,
0075,0075,0075,0075,0075,0075,0075,0075,0075,0075,0075,0075,0075,0075,0075,
0076,0076,0076,0076,0076,0076,0076,0076,0076,0076,0076,0076,0076,0076,0076,
0076,0077,0077,0077,0077,0077,0077,0077,0077,0077,0077,0077,0077,0077,0077,
0077,0077,0100,0100,0100,0100,0100,0100,0100,0100,0101,0101,0101,0101,0101,
0101,0101,0101,0102,0102,0102,0102,0102,0102,0102,0102,0103,0103,0103,0103,
0103,0103,0103,0103,0104,0104,0104,0104,0104,0104,0104,0104,0105,0105,0105,
0105,0105,0105,0105,0105,0106,0106,0106,0106,0106,0106,0106,0106,0107,0107,
0107,0107,0107,0107,0107,0107,0110,0110,0110,0110,0110,0110,0110,0110,0111,
0111,0111,0111,0111,0111,0111,0111,0112,0112,0112,0112,0112,0112,0112,0112,
0113,0113,0113,0113,0113,0113,0113,0113,0114,0114,0114,0114,0114,0114,0114,
0114,0115,0115,0115,0115,0115,0115,0115,0115,0116,0116,0116,0116,0116,0116,
0116,0116,0117,0117,0117,0117,0117,0117,0117,0117,0120,0120,0120,0120,0121,
0121,0121,0121,0122,0122,0122,0122,0123,0123,0123,0123,0124,0124,0124,0124,
0125,0125,0125,0125,0126,0126,0126,0126,0127,0127,0127,0127,0130,0130,0130,
0130,0131,0131,0131,0131,0132,0132,0132,0132,0133,0133,0133,0133,0134,0134,
0134,0134,0135,0135,0135,0135,0136,0136,0136,0136,0137,0137,0137,0137,0140,
0140,0141,0141,0142,0142,0143,0143,0144,0144,0145,0145,0146,0146,0147,0147,
0150,0150,0150,0151,0151,0152,0152,0153,0153,0154,0154,0155,0155,0156,0156,
0157,0157,0160,0161,0162,0163,0164,0165,0166,0167,0170,0171,0172,0173,0174,
0175,0176
};
