------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                            S Y S T E M . F I M                           --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--             Copyright (c) 1992,1993, NYU, All Rights Reserved            --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms  of the GNU  General  Public  License  as  published  by the  Free --
-- Software  Foundation;  either version 2,  or (at your option)  any later --
-- version.  GNAT is distributed  in the hope  that it will be useful,  but --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANT- --
-- ABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public --
-- License  for  more details.  You should have received  a copy of the GNU --
-- General Public License along with GNAT;  see file COPYING. If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains the generic package which is instantiated with
--  predefined integer types to generate the runtime functions called by the
--  expanded code generated by Expand_Fixed_To_Integer_Multiplication. The four
--  cases correspond to four different computation of the result, for the
--  mutiplication of two fixed point type values with a conversion to an
--  integer type value. The choice of which function to call is made during the
--  expansion and depends on the values of the parameters A, B and M. This
--  is an implementation of Paul Hilfinger's algorithms.

package System.Fim is
pragma Pure (Fim);

   generic
      type Int_Type is range <>;

   package Fim_Util is

      function Case1
        (A, B, X, Y : Int_Type;
         M          : Natural)
         return       Int_Type;
      --  called when M > 0 and (2 ** M) * A >= B.

      function Case2
        (A, B, X, Y : Int_Type;
         M          : Natural)
         return       Int_Type;
      --  called when M = 0 and  A < B.

      function Case3
        (A, B, X, Y : Int_Type;
         M          : Natural)
         return       Int_Type;
      --  called when M < 0 and  A < B.

      function Case4
        (A, B, X, Y : Int_Type;
         M          : Natural)
         return       Int_Type;
      --  called when M < 0 and  B =< A < 2 * B.

   end Fim_Util;

end System.Fim;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.1
--  date: Fri Jul 15 13:30:05 1994;  author: crozes
--  Initial revision
--  ----------------------------
--  revision 1.2
--  date: Tue Aug  2 12:23:24 1994;  author: dewar
--  Add pragma Pure
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
