/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

package com.amazonaws.util.awsclientgenerator.generators;

import com.amazonaws.util.awsclientgenerator.domainmodels.c2j.C2jServiceModel;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.nio.charset.StandardCharsets;


public class DirectFromC2jGenerator {

    private final MainClientGenerator mainClientGenerator;

    public DirectFromC2jGenerator(final MainClientGenerator mainClientGenerator) {
       this.mainClientGenerator = mainClientGenerator;
    }

    public File generateSourceFromJson(String rawJson, String languageBinding, String serviceName, String namespace, String licenseText, boolean generateStandalonePackage, boolean enableVirtualOperations) throws Exception {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();

        C2jServiceModel c2jServiceModel = gson.fromJson(rawJson, C2jServiceModel.class);
        c2jServiceModel.setServiceName(serviceName);
        return mainClientGenerator.generateSourceFromC2jModel(c2jServiceModel, serviceName, languageBinding, namespace, licenseText, generateStandalonePackage, enableVirtualOperations);
    }
}
