﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/ssm/model/DescribeDocumentPermissionResult.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>

#include <utility>

using namespace Aws::SSM::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DescribeDocumentPermissionResult::DescribeDocumentPermissionResult()
{
}

DescribeDocumentPermissionResult::DescribeDocumentPermissionResult(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  *this = result;
}

DescribeDocumentPermissionResult& DescribeDocumentPermissionResult::operator =(const Aws::AmazonWebServiceResult<JsonValue>& result)
{
  JsonView jsonValue = result.GetPayload().View();
  if(jsonValue.ValueExists("AccountIds"))
  {
    Array<JsonView> accountIdsJsonList = jsonValue.GetArray("AccountIds");
    for(unsigned accountIdsIndex = 0; accountIdsIndex < accountIdsJsonList.GetLength(); ++accountIdsIndex)
    {
      m_accountIds.push_back(accountIdsJsonList[accountIdsIndex].AsString());
    }
  }

  if(jsonValue.ValueExists("AccountSharingInfoList"))
  {
    Array<JsonView> accountSharingInfoListJsonList = jsonValue.GetArray("AccountSharingInfoList");
    for(unsigned accountSharingInfoListIndex = 0; accountSharingInfoListIndex < accountSharingInfoListJsonList.GetLength(); ++accountSharingInfoListIndex)
    {
      m_accountSharingInfoList.push_back(accountSharingInfoListJsonList[accountSharingInfoListIndex].AsObject());
    }
  }



  return *this;
}
