﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/macie2/Macie2_EXPORTS.h>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Macie2
{
namespace Model
{

  /**
   * <p>Provides information about the number of S3 buckets that are shared with
   * other AWS accounts.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/macie2-2020-01-01/BucketCountBySharedAccessType">AWS
   * API Reference</a></p>
   */
  class AWS_MACIE2_API BucketCountBySharedAccessType
  {
  public:
    BucketCountBySharedAccessType();
    BucketCountBySharedAccessType(Aws::Utils::Json::JsonView jsonValue);
    BucketCountBySharedAccessType& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The total number of buckets that are shared with an AWS account that isn't
     * part of the same Amazon Macie organization.</p>
     */
    inline long long GetExternal() const{ return m_external; }

    /**
     * <p>The total number of buckets that are shared with an AWS account that isn't
     * part of the same Amazon Macie organization.</p>
     */
    inline bool ExternalHasBeenSet() const { return m_externalHasBeenSet; }

    /**
     * <p>The total number of buckets that are shared with an AWS account that isn't
     * part of the same Amazon Macie organization.</p>
     */
    inline void SetExternal(long long value) { m_externalHasBeenSet = true; m_external = value; }

    /**
     * <p>The total number of buckets that are shared with an AWS account that isn't
     * part of the same Amazon Macie organization.</p>
     */
    inline BucketCountBySharedAccessType& WithExternal(long long value) { SetExternal(value); return *this;}


    /**
     * <p>The total number of buckets that are shared with an AWS account that's part
     * of the same Amazon Macie organization.</p>
     */
    inline long long GetInternal() const{ return m_internal; }

    /**
     * <p>The total number of buckets that are shared with an AWS account that's part
     * of the same Amazon Macie organization.</p>
     */
    inline bool InternalHasBeenSet() const { return m_internalHasBeenSet; }

    /**
     * <p>The total number of buckets that are shared with an AWS account that's part
     * of the same Amazon Macie organization.</p>
     */
    inline void SetInternal(long long value) { m_internalHasBeenSet = true; m_internal = value; }

    /**
     * <p>The total number of buckets that are shared with an AWS account that's part
     * of the same Amazon Macie organization.</p>
     */
    inline BucketCountBySharedAccessType& WithInternal(long long value) { SetInternal(value); return *this;}


    /**
     * <p>The total number of buckets that aren't shared with any other AWS
     * accounts.</p>
     */
    inline long long GetNotShared() const{ return m_notShared; }

    /**
     * <p>The total number of buckets that aren't shared with any other AWS
     * accounts.</p>
     */
    inline bool NotSharedHasBeenSet() const { return m_notSharedHasBeenSet; }

    /**
     * <p>The total number of buckets that aren't shared with any other AWS
     * accounts.</p>
     */
    inline void SetNotShared(long long value) { m_notSharedHasBeenSet = true; m_notShared = value; }

    /**
     * <p>The total number of buckets that aren't shared with any other AWS
     * accounts.</p>
     */
    inline BucketCountBySharedAccessType& WithNotShared(long long value) { SetNotShared(value); return *this;}

  private:

    long long m_external;
    bool m_externalHasBeenSet;

    long long m_internal;
    bool m_internalHasBeenSet;

    long long m_notShared;
    bool m_notSharedHasBeenSet;
  };

} // namespace Model
} // namespace Macie2
} // namespace Aws
