﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/DataSourceStatus.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace GuardDuty
{
namespace Model
{

  /**
   * <p>Contains information on the status of CloudTrail as a data source for the
   * detector.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CloudTrailConfigurationResult">AWS
   * API Reference</a></p>
   */
  class AWS_GUARDDUTY_API CloudTrailConfigurationResult
  {
  public:
    CloudTrailConfigurationResult();
    CloudTrailConfigurationResult(Aws::Utils::Json::JsonView jsonValue);
    CloudTrailConfigurationResult& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>Describes whether CloudTrail is enabled as a data source for the
     * detector.</p>
     */
    inline const DataSourceStatus& GetStatus() const{ return m_status; }

    /**
     * <p>Describes whether CloudTrail is enabled as a data source for the
     * detector.</p>
     */
    inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }

    /**
     * <p>Describes whether CloudTrail is enabled as a data source for the
     * detector.</p>
     */
    inline void SetStatus(const DataSourceStatus& value) { m_statusHasBeenSet = true; m_status = value; }

    /**
     * <p>Describes whether CloudTrail is enabled as a data source for the
     * detector.</p>
     */
    inline void SetStatus(DataSourceStatus&& value) { m_statusHasBeenSet = true; m_status = std::move(value); }

    /**
     * <p>Describes whether CloudTrail is enabled as a data source for the
     * detector.</p>
     */
    inline CloudTrailConfigurationResult& WithStatus(const DataSourceStatus& value) { SetStatus(value); return *this;}

    /**
     * <p>Describes whether CloudTrail is enabled as a data source for the
     * detector.</p>
     */
    inline CloudTrailConfigurationResult& WithStatus(DataSourceStatus&& value) { SetStatus(std::move(value)); return *this;}

  private:

    DataSourceStatus m_status;
    bool m_statusHasBeenSet;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
