﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/gamelift/GameLift_EXPORTS.h>
#include <aws/gamelift/GameLiftRequest.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/gamelift/model/SortOrder.h>
#include <utility>

namespace Aws
{
namespace GameLift
{
namespace Model
{

  /**
   */
  class AWS_GAMELIFT_API ListGameServersRequest : public GameLiftRequest
  {
  public:
    ListGameServersRequest();

    // Service request name is the Operation name which will send this request out,
    // each operation should has unique request name, so that we can get operation's name from this request.
    // Note: this is not true for response, multiple operations may have the same response name,
    // so we can not get operation's name from response.
    inline virtual const char* GetServiceRequestName() const override { return "ListGameServers"; }

    Aws::String SerializePayload() const override;

    Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;


    /**
     * <p>An identifier for the game server group to retrieve a list of game servers
     * from. Use either the <a>GameServerGroup</a> name or ARN value.</p>
     */
    inline const Aws::String& GetGameServerGroupName() const{ return m_gameServerGroupName; }

    /**
     * <p>An identifier for the game server group to retrieve a list of game servers
     * from. Use either the <a>GameServerGroup</a> name or ARN value.</p>
     */
    inline bool GameServerGroupNameHasBeenSet() const { return m_gameServerGroupNameHasBeenSet; }

    /**
     * <p>An identifier for the game server group to retrieve a list of game servers
     * from. Use either the <a>GameServerGroup</a> name or ARN value.</p>
     */
    inline void SetGameServerGroupName(const Aws::String& value) { m_gameServerGroupNameHasBeenSet = true; m_gameServerGroupName = value; }

    /**
     * <p>An identifier for the game server group to retrieve a list of game servers
     * from. Use either the <a>GameServerGroup</a> name or ARN value.</p>
     */
    inline void SetGameServerGroupName(Aws::String&& value) { m_gameServerGroupNameHasBeenSet = true; m_gameServerGroupName = std::move(value); }

    /**
     * <p>An identifier for the game server group to retrieve a list of game servers
     * from. Use either the <a>GameServerGroup</a> name or ARN value.</p>
     */
    inline void SetGameServerGroupName(const char* value) { m_gameServerGroupNameHasBeenSet = true; m_gameServerGroupName.assign(value); }

    /**
     * <p>An identifier for the game server group to retrieve a list of game servers
     * from. Use either the <a>GameServerGroup</a> name or ARN value.</p>
     */
    inline ListGameServersRequest& WithGameServerGroupName(const Aws::String& value) { SetGameServerGroupName(value); return *this;}

    /**
     * <p>An identifier for the game server group to retrieve a list of game servers
     * from. Use either the <a>GameServerGroup</a> name or ARN value.</p>
     */
    inline ListGameServersRequest& WithGameServerGroupName(Aws::String&& value) { SetGameServerGroupName(std::move(value)); return *this;}

    /**
     * <p>An identifier for the game server group to retrieve a list of game servers
     * from. Use either the <a>GameServerGroup</a> name or ARN value.</p>
     */
    inline ListGameServersRequest& WithGameServerGroupName(const char* value) { SetGameServerGroupName(value); return *this;}


    /**
     * <p>Indicates how to sort the returned data based on game server registration
     * timestamp. Use ASCENDING to retrieve oldest game servers first, or use
     * DESCENDING to retrieve newest game servers first. If this parameter is left
     * empty, game servers are returned in no particular order.</p>
     */
    inline const SortOrder& GetSortOrder() const{ return m_sortOrder; }

    /**
     * <p>Indicates how to sort the returned data based on game server registration
     * timestamp. Use ASCENDING to retrieve oldest game servers first, or use
     * DESCENDING to retrieve newest game servers first. If this parameter is left
     * empty, game servers are returned in no particular order.</p>
     */
    inline bool SortOrderHasBeenSet() const { return m_sortOrderHasBeenSet; }

    /**
     * <p>Indicates how to sort the returned data based on game server registration
     * timestamp. Use ASCENDING to retrieve oldest game servers first, or use
     * DESCENDING to retrieve newest game servers first. If this parameter is left
     * empty, game servers are returned in no particular order.</p>
     */
    inline void SetSortOrder(const SortOrder& value) { m_sortOrderHasBeenSet = true; m_sortOrder = value; }

    /**
     * <p>Indicates how to sort the returned data based on game server registration
     * timestamp. Use ASCENDING to retrieve oldest game servers first, or use
     * DESCENDING to retrieve newest game servers first. If this parameter is left
     * empty, game servers are returned in no particular order.</p>
     */
    inline void SetSortOrder(SortOrder&& value) { m_sortOrderHasBeenSet = true; m_sortOrder = std::move(value); }

    /**
     * <p>Indicates how to sort the returned data based on game server registration
     * timestamp. Use ASCENDING to retrieve oldest game servers first, or use
     * DESCENDING to retrieve newest game servers first. If this parameter is left
     * empty, game servers are returned in no particular order.</p>
     */
    inline ListGameServersRequest& WithSortOrder(const SortOrder& value) { SetSortOrder(value); return *this;}

    /**
     * <p>Indicates how to sort the returned data based on game server registration
     * timestamp. Use ASCENDING to retrieve oldest game servers first, or use
     * DESCENDING to retrieve newest game servers first. If this parameter is left
     * empty, game servers are returned in no particular order.</p>
     */
    inline ListGameServersRequest& WithSortOrder(SortOrder&& value) { SetSortOrder(std::move(value)); return *this;}


    /**
     * <p>The maximum number of results to return. Use this parameter with
     * <code>NextToken</code> to get results as a set of sequential segments.</p>
     */
    inline int GetLimit() const{ return m_limit; }

    /**
     * <p>The maximum number of results to return. Use this parameter with
     * <code>NextToken</code> to get results as a set of sequential segments.</p>
     */
    inline bool LimitHasBeenSet() const { return m_limitHasBeenSet; }

    /**
     * <p>The maximum number of results to return. Use this parameter with
     * <code>NextToken</code> to get results as a set of sequential segments.</p>
     */
    inline void SetLimit(int value) { m_limitHasBeenSet = true; m_limit = value; }

    /**
     * <p>The maximum number of results to return. Use this parameter with
     * <code>NextToken</code> to get results as a set of sequential segments.</p>
     */
    inline ListGameServersRequest& WithLimit(int value) { SetLimit(value); return *this;}


    /**
     * <p>A token that indicates the start of the next sequential segment of results.
     * Use the token returned with the previous call to this operation. To start at the
     * beginning of the result set, do not specify a value.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }

    /**
     * <p>A token that indicates the start of the next sequential segment of results.
     * Use the token returned with the previous call to this operation. To start at the
     * beginning of the result set, do not specify a value.</p>
     */
    inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }

    /**
     * <p>A token that indicates the start of the next sequential segment of results.
     * Use the token returned with the previous call to this operation. To start at the
     * beginning of the result set, do not specify a value.</p>
     */
    inline void SetNextToken(const Aws::String& value) { m_nextTokenHasBeenSet = true; m_nextToken = value; }

    /**
     * <p>A token that indicates the start of the next sequential segment of results.
     * Use the token returned with the previous call to this operation. To start at the
     * beginning of the result set, do not specify a value.</p>
     */
    inline void SetNextToken(Aws::String&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::move(value); }

    /**
     * <p>A token that indicates the start of the next sequential segment of results.
     * Use the token returned with the previous call to this operation. To start at the
     * beginning of the result set, do not specify a value.</p>
     */
    inline void SetNextToken(const char* value) { m_nextTokenHasBeenSet = true; m_nextToken.assign(value); }

    /**
     * <p>A token that indicates the start of the next sequential segment of results.
     * Use the token returned with the previous call to this operation. To start at the
     * beginning of the result set, do not specify a value.</p>
     */
    inline ListGameServersRequest& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}

    /**
     * <p>A token that indicates the start of the next sequential segment of results.
     * Use the token returned with the previous call to this operation. To start at the
     * beginning of the result set, do not specify a value.</p>
     */
    inline ListGameServersRequest& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}

    /**
     * <p>A token that indicates the start of the next sequential segment of results.
     * Use the token returned with the previous call to this operation. To start at the
     * beginning of the result set, do not specify a value.</p>
     */
    inline ListGameServersRequest& WithNextToken(const char* value) { SetNextToken(value); return *this;}

  private:

    Aws::String m_gameServerGroupName;
    bool m_gameServerGroupNameHasBeenSet;

    SortOrder m_sortOrder;
    bool m_sortOrderHasBeenSet;

    int m_limit;
    bool m_limitHasBeenSet;

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet;
  };

} // namespace Model
} // namespace GameLift
} // namespace Aws
