﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#include <aws/ssm/model/NonCompliantSummary.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace SSM
{
namespace Model
{

NonCompliantSummary::NonCompliantSummary() : 
    m_nonCompliantCount(0),
    m_nonCompliantCountHasBeenSet(false),
    m_severitySummaryHasBeenSet(false)
{
}

NonCompliantSummary::NonCompliantSummary(JsonView jsonValue) : 
    m_nonCompliantCount(0),
    m_nonCompliantCountHasBeenSet(false),
    m_severitySummaryHasBeenSet(false)
{
  *this = jsonValue;
}

NonCompliantSummary& NonCompliantSummary::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("NonCompliantCount"))
  {
    m_nonCompliantCount = jsonValue.GetInteger("NonCompliantCount");

    m_nonCompliantCountHasBeenSet = true;
  }

  if(jsonValue.ValueExists("SeveritySummary"))
  {
    m_severitySummary = jsonValue.GetObject("SeveritySummary");

    m_severitySummaryHasBeenSet = true;
  }

  return *this;
}

JsonValue NonCompliantSummary::Jsonize() const
{
  JsonValue payload;

  if(m_nonCompliantCountHasBeenSet)
  {
   payload.WithInteger("NonCompliantCount", m_nonCompliantCount);

  }

  if(m_severitySummaryHasBeenSet)
  {
   payload.WithObject("SeveritySummary", m_severitySummary.Jsonize());

  }

  return payload;
}

} // namespace Model
} // namespace SSM
} // namespace Aws
