﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#include <aws/servicediscovery/model/NamespaceProperties.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace ServiceDiscovery
{
namespace Model
{

NamespaceProperties::NamespaceProperties() : 
    m_dnsPropertiesHasBeenSet(false),
    m_httpPropertiesHasBeenSet(false)
{
}

NamespaceProperties::NamespaceProperties(JsonView jsonValue) : 
    m_dnsPropertiesHasBeenSet(false),
    m_httpPropertiesHasBeenSet(false)
{
  *this = jsonValue;
}

NamespaceProperties& NamespaceProperties::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("DnsProperties"))
  {
    m_dnsProperties = jsonValue.GetObject("DnsProperties");

    m_dnsPropertiesHasBeenSet = true;
  }

  if(jsonValue.ValueExists("HttpProperties"))
  {
    m_httpProperties = jsonValue.GetObject("HttpProperties");

    m_httpPropertiesHasBeenSet = true;
  }

  return *this;
}

JsonValue NamespaceProperties::Jsonize() const
{
  JsonValue payload;

  if(m_dnsPropertiesHasBeenSet)
  {
   payload.WithObject("DnsProperties", m_dnsProperties.Jsonize());

  }

  if(m_httpPropertiesHasBeenSet)
  {
   payload.WithObject("HttpProperties", m_httpProperties.Jsonize());

  }

  return payload;
}

} // namespace Model
} // namespace ServiceDiscovery
} // namespace Aws
