﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#include <aws/ecs/model/RepositoryCredentials.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace ECS
{
namespace Model
{

RepositoryCredentials::RepositoryCredentials() : 
    m_credentialsParameterHasBeenSet(false)
{
}

RepositoryCredentials::RepositoryCredentials(JsonView jsonValue) : 
    m_credentialsParameterHasBeenSet(false)
{
  *this = jsonValue;
}

RepositoryCredentials& RepositoryCredentials::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("credentialsParameter"))
  {
    m_credentialsParameter = jsonValue.GetString("credentialsParameter");

    m_credentialsParameterHasBeenSet = true;
  }

  return *this;
}

JsonValue RepositoryCredentials::Jsonize() const
{
  JsonValue payload;

  if(m_credentialsParameterHasBeenSet)
  {
   payload.WithString("credentialsParameter", m_credentialsParameter);

  }

  return payload;
}

} // namespace Model
} // namespace ECS
} // namespace Aws
