# Copyright 1999-2009 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/sys-cluster/ganglia/ganglia-3.1.2.ebuild,v 1.6 2009/06/20 18:27:54 jsbronder Exp $

WEBAPP_OPTIONAL="yes"
inherit multilib webapp depend.php python

DESCRIPTION="A scalable distributed monitoring system for clusters and grids"
HOMEPAGE="http://ganglia.sourceforge.net/"
SRC_URI="mirror://sourceforge/ganglia/${P}.tar.gz"
LICENSE="BSD"

WEBAPP_MANUAL_SLOT="yes"
SLOT="0"
KEYWORDS="amd64 ppc x86"
IUSE="minimal vhosts python"

DEPEND="
	dev-libs/confuse
	dev-libs/expat
	>=dev-libs/apr-1.0
	python? ( >=dev-lang/python-2.3 )
	!dev-db/firebird"

RDEPEND="
	${DEPEND}
	!minimal? ( net-analyzer/rrdtool
		${WEBAPP_DEPEND}
		=virtual/httpd-php-5* )"

pkg_setup() {
	if ! use minimal ; then
		require_gd
		require_php_with_use xml ctype pcre
		webapp_pkg_setup
	fi
}

src_unpack() {
	unpack ${A}
	cd "${S}"
	# TODO:  Submitted upstream, may not be necessary in the future.
	epatch "${FILESDIR}"/${PN}-3.1.1-ctype-c99.patch
	# This patch just gives a group to the disk statistics.
	# I.E. it's just cosmetics
	epatch "${FILESDIR}"/${PN}-3.1.1-multidisk-group.patch
}

src_compile() {
	econf \
		--enable-gexec \
		$(use_enable python) \
		$(use_with !minimal gmetad) || die "econf failed"

	emake || die "emake failed"
}

src_install() {
	emake DESTDIR="${D}" install || die "emake install failed"

	newinitd "${FILESDIR}"/gmond.rc gmond
	doman mans/{gmetric.1,gmond.1,gstat.1}
	doman gmond/gmond.conf.5
	dodoc AUTHORS ChangeLog INSTALL NEWS README
	dodir /etc/ganglia/conf.d
	gmond/gmond -t > "${D}"/etc/ganglia/gmond.conf

	# Sadly, there is no install target for any of this.
	if use python; then
		# We install the multidisk module, but not the configuration
		# as this needs to be generated later.  See pkg_config
		local gmond_py="disk/multidisk network/tcpconn"
		local gmond_py_conf="tcpconn"
		newdoc gmond/modules/python/README README.python_modules
		insinto /etc/ganglia/conf.d
		doins gmond/modules/conf.d/modpython.conf
		for i in ${gmond_py_conf}; do
			doins gmond/python_modules/conf.d/${i}.pyconf
		done
		dodir /usr/$(get_libdir)/ganglia/python_modules
		insinto /usr/$(get_libdir)/ganglia/python_modules
		for i in ${gmond_py}; do
			doins gmond/python_modules/${i}.py
		done
	fi

	if ! use minimal; then
		webapp_src_preinst
		insinto "${MY_HTDOCSDIR}"
		doins -r web/*
		webapp_configfile "${MY_HTDOCSDIR}"/conf.php
		webapp_src_install

		# webapp_src_install stomps on permissions, so do that
		# stuff first.
		insinto /etc/ganglia
		doins gmetad/gmetad.conf
		doman mans/gmetad.1

		newinitd "${FILESDIR}"/gmetad.rc gmetad
		keepdir /var/lib/ganglia/rrds
		fowners nobody:nobody /var/lib/ganglia/rrds
	fi
}

pkg_preinst() {
	if has_version '<sys-cluster/ganglia-3.1.0'; then
		elog "Previous ganglia installation detected."
		elog "Copying gmetad configuration to /etc/ganglia"
		elog "You may have to remove /etc/gmond.conf yourself."
		mkdir -p "${D}"/etc/ganglia
		[ -f "${ROOT}"etc/gmetad.conf ] \
			&& cp "${ROOT}"etc/gmetad.conf "${D}"/etc/ganglia
	fi
}

pkg_postinst() {
	elog "A default configuration file for gmond has been generated"
	elog "for you as a template by running:"
	elog "    /usr/sbin/gmond -t > /etc/ganglia/gmond.conf"
	elog "customize it from there or provide your own but be aware"
	elog "the format has changed since 3.0 and so you won't be able"
	elog "to use your current configuration (if you generated any)"
	elog "in /etc/gmond.conf directly"
	elog
	elog "If you require disk {usage,total} statistics, please run"
	elog "    emerge --config ${PN}"
	elog "then check ${ROOT}etc/ganglia/conf.d/diskusage.pyconf"
	elog "for correctness."

	use minimal || webapp_pkg_postinst

	use python && \
		python_mod_optimize /usr/$(get_libdir)/ganglia/python_modules/
}

pkg_prerm() {
	use minimal || webapp_pkg_prerm
}

pkg_postrm() {
	use python && \
		python_mod_cleanup /usr/$(get_libdir)/ganglia/python_modules/
	[ -d "${ROOT}"/usr/$(get_libdir)/ganglia ] && \
		rmdir "${ROOT}"/usr/$(get_libdir)/ganglia 2>/dev/null
}

pkg_config() {
	local disk_used_metrics disk_total_metrics i
	local disk_pyconf="${ROOT}"etc/ganglia/conf.d/diskusage.pyconf

	if ! use python; then
		einfo "No configuration necessary :)"
		exit 0
	fi

	if [ ! -w ${disk_pyconf} ]; then
		eerror "Cannot write to ${disk_pyconf}"
		exit 1
	fi

	ebegin "Generating disk used/total metric configuration to ${disk_pyconf}"
	disk_used_metrics=$(${ROOT}/usr/sbin/gmond -m | awk '/-disk_used/{print $1}')
	disk_total_metrics=$(${ROOT}/usr/sbin/gmond -m | awk '/-disk_total/{print $1}')
	cat > ${disk_pyconf} <<-EOF
		#/* Disk usage collection groups for
		#    multidisk python module */
		#
		# Autogenerated by pkg_config in the Gentoo ganglia ebuild.

		modules {
		  module {
		    name = "multidisk"
		    language = "python"
		  }
		}

		collection_group {
		  collect_every = 10
		  time_threshold = 50
	EOF
	for i in ${disk_used_metrics}; do
		printf \
			"\n  metric {\n    name = \"%s\"\n    value_threshold = 1.0\n  }" \
			${i} >> ${disk_pyconf}
	done
	printf "\n}\n\n" >> ${disk_pyconf}

	# Get the disk total metrics.
	cat >> ${disk_pyconf} <<-EOF
		collection_group {
		  collect_once = yes
		  time_threshold = 20
	EOF
	for i in ${disk_total_metrics}; do
		printf \
			"\n  metric {\n    name = \"%s\"\n  }" \
			${i} >> ${disk_pyconf}
	done
	printf "\n}\n" >> ${disk_pyconf}
}
