# Copyright 1999-2011 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/app-text/pandoc/pandoc-1.8.1.1-r1.ebuild,v 1.1 2011/05/03 19:35:58 slyfox Exp $

# ebuild generated by hackport 0.2.11

EAPI="3"

CABAL_FEATURES="bin lib profile haddock hscolour"
inherit haskell-cabal

DESCRIPTION="Conversion between markup formats"
HOMEPAGE="http://johnmacfarlane.net/pandoc"
SRC_URI="http://hackage.haskell.org/packages/archive/${PN}/${PV}/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE="highlight pdf"
RESTRICT="test" # needs quickcheck-2.4 in tree

RDEPEND=">=dev-haskell/citeproc-hs-0.3.1
		=dev-haskell/dlist-0.5*
		=dev-haskell/http-4000.1*
		=dev-haskell/json-0.4*
		<dev-haskell/mtl-2.1
		=dev-haskell/network-2.3*
		=dev-haskell/pandoc-types-1.8*
		>=dev-haskell/parsec-2.1
		=dev-haskell/tagsoup-0.12*
		=dev-haskell/texmath-0.5*
		=dev-haskell/utf8-string-0.3*
		=dev-haskell/xhtml-3000.2*
		>=dev-haskell/xml-1.3.5
		>=dev-haskell/zip-archive-0.1.1.7
		>=dev-lang/ghc-6.10.1
		highlight? ( =dev-haskell/highlighting-kate-0.2.9* )
		pdf? ( virtual/latex-base )
	"

DEPEND="${RDEPEND}
		>=dev-haskell/cabal-1.6"

pandoc_init() {
	pandoc="${PN}"
	pdfscript="markdown2pdf"
}

installMan() {
	local prog=$1
	doman "${S}/man/man1/${prog}.1"
}

src_configure() {
	cabal_src_configure \
		$(cabal_flag highlight highlighting)
}

src_install() {
	pandoc_init
	cabal_src_install

	installMan "${pandoc}"
	use pdf && installMan "${pdfscript}"

	# COPYING is installed by the Cabal eclass
	dodoc README COPYRIGHT changelog
}
