require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_HFS_SYSDEP_H)) {
    eval 'sub _HFS_SYSDEP_H () {1;}' unless defined(&_HFS_SYSDEP_H);
    require 'linux/types.ph';
    require 'linux/fs.ph';
    require 'endian.ph';
    require 'byteswap.ph';
    require 'asm/unaligned.ph';
    undef(&offsetof) if defined(&offsetof);
    eval 'sub offsetof {
        my($TYPE, $MEMB) = @_;
	    eval q(( (($TYPE *)0)->$MEMB));
    }' unless defined(&offsetof);
    eval 'sub hfs_get_hs {
        my($addr) = @_;
	    eval q( &ntohs(*(( &hfs_u16 *)($addr))));
    }' unless defined(&hfs_get_hs);
    eval 'sub hfs_get_ns {
        my($addr) = @_;
	    eval q((*(( &hfs_u16 *)($addr))));
    }' unless defined(&hfs_get_ns);
    eval 'sub hfs_get_hl {
        my($addr) = @_;
	    eval q( &ntohl( &get_unaligned(( &hfs_u32 *)($addr))));
    }' unless defined(&hfs_get_hl);
    eval 'sub hfs_get_nl {
        my($addr) = @_;
	    eval q( &get_unaligned(( &hfs_u32 *)($addr)));
    }' unless defined(&hfs_get_nl);
    eval 'sub hfs_get_ahl {
        my($addr) = @_;
	    eval q( &ntohl(*(( &hfs_u32 *)($addr))));
    }' unless defined(&hfs_get_ahl);
    eval 'sub hfs_get_anl {
        my($addr) = @_;
	    eval q((*(( &hfs_u32 *)($addr))));
    }' unless defined(&hfs_get_anl);
    eval 'sub hfs_put_hs {
        my($val, $addr) = @_;
	    eval q((( &void)(*(( &hfs_u16 *)($addr)) =  &ntohs($val))));
    }' unless defined(&hfs_put_hs);
    eval 'sub hfs_put_ns {
        my($val, $addr) = @_;
	    eval q((( &void)(*(( &hfs_u16 *)($addr)) = ($val))));
    }' unless defined(&hfs_put_ns);
    eval 'sub hfs_put_hl {
        my($val, $addr) = @_;
	    eval q( &put_unaligned( &htonl($val), ( &hfs_u32 *)($addr)));
    }' unless defined(&hfs_put_hl);
    eval 'sub hfs_put_nl {
        my($val, $addr) = @_;
	    eval q( &put_unaligned(($val), ( &hfs_u32 *)($addr)));
    }' unless defined(&hfs_put_nl);
    eval 'sub hfs_put_ahl {
        my($val, $addr) = @_;
	    eval q((( &void)(*(( &hfs_u32 *)($addr)) =  &ntohl($val))));
    }' unless defined(&hfs_put_ahl);
    eval 'sub hfs_put_anl {
        my($val, $addr) = @_;
	    eval q((( &void)(*(( &hfs_u32 *)($addr)) = ($val))));
    }' unless defined(&hfs_put_anl);
}
1;
