require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ASM_I386_PROCESSOR_H)) {
    eval 'sub __ASM_I386_PROCESSOR_H () {1;}' unless defined(&__ASM_I386_PROCESSOR_H);
    require 'asm/vm86.ph';
    require 'asm/math_emu.ph';
    require 'asm/segment.ph';
    require 'asm/page.ph';
    require 'asm/types.ph';
    require 'asm/sigcontext.ph';
    require 'asm/cpufeature.ph';
    require 'linux/config.ph';
    require 'linux/threads.ph';
    eval 'sub current_text_addr () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&current_text_addr);
    eval 'sub X86_VENDOR_INTEL () {0;}' unless defined(&X86_VENDOR_INTEL);
    eval 'sub X86_VENDOR_CYRIX () {1;}' unless defined(&X86_VENDOR_CYRIX);
    eval 'sub X86_VENDOR_AMD () {2;}' unless defined(&X86_VENDOR_AMD);
    eval 'sub X86_VENDOR_UMC () {3;}' unless defined(&X86_VENDOR_UMC);
    eval 'sub X86_VENDOR_NEXGEN () {4;}' unless defined(&X86_VENDOR_NEXGEN);
    eval 'sub X86_VENDOR_CENTAUR () {5;}' unless defined(&X86_VENDOR_CENTAUR);
    eval 'sub X86_VENDOR_RISE () {6;}' unless defined(&X86_VENDOR_RISE);
    eval 'sub X86_VENDOR_TRANSMETA () {7;}' unless defined(&X86_VENDOR_TRANSMETA);
    eval 'sub X86_VENDOR_UNKNOWN () {0xff;}' unless defined(&X86_VENDOR_UNKNOWN);
    if(defined(&CONFIG_SMP)) {
	eval 'sub current_cpu_data () { $cpu_data[ &smp_processor_id()];}' unless defined(&current_cpu_data);
    } else {
	eval 'sub cpu_data () { &boot_cpu_data;}' unless defined(&cpu_data);
	eval 'sub current_cpu_data () { &boot_cpu_data;}' unless defined(&current_cpu_data);
    }
    eval 'sub cpu_has_pge () {( &test_bit( &X86_FEATURE_PGE,  ($boot_cpu_data->{x86_capability})));}' unless defined(&cpu_has_pge);
    eval 'sub cpu_has_pse () {( &test_bit( &X86_FEATURE_PSE,  ($boot_cpu_data->{x86_capability})));}' unless defined(&cpu_has_pse);
    eval 'sub cpu_has_pae () {( &test_bit( &X86_FEATURE_PAE,  ($boot_cpu_data->{x86_capability})));}' unless defined(&cpu_has_pae);
    eval 'sub cpu_has_tsc () {( &test_bit( &X86_FEATURE_TSC,  ($boot_cpu_data->{x86_capability})));}' unless defined(&cpu_has_tsc);
    eval 'sub cpu_has_de () {( &test_bit( &X86_FEATURE_DE,  ($boot_cpu_data->{x86_capability})));}' unless defined(&cpu_has_de);
    eval 'sub cpu_has_vme () {( &test_bit( &X86_FEATURE_VME,  ($boot_cpu_data->{x86_capability})));}' unless defined(&cpu_has_vme);
    eval 'sub cpu_has_fxsr () {( &test_bit( &X86_FEATURE_FXSR,  ($boot_cpu_data->{x86_capability})));}' unless defined(&cpu_has_fxsr);
    eval 'sub cpu_has_xmm () {( &test_bit( &X86_FEATURE_XMM,  ($boot_cpu_data->{x86_capability})));}' unless defined(&cpu_has_xmm);
    eval 'sub cpu_has_fpu () {( &test_bit( &X86_FEATURE_FPU,  ($boot_cpu_data->{x86_capability})));}' unless defined(&cpu_has_fpu);
    eval 'sub cpu_has_apic () {( &test_bit( &X86_FEATURE_APIC,  ($boot_cpu_data->{x86_capability})));}' unless defined(&cpu_has_apic);
    eval 'sub X86_EFLAGS_CF () {0x1;}' unless defined(&X86_EFLAGS_CF);
    eval 'sub X86_EFLAGS_PF () {0x4;}' unless defined(&X86_EFLAGS_PF);
    eval 'sub X86_EFLAGS_AF () {0x10;}' unless defined(&X86_EFLAGS_AF);
    eval 'sub X86_EFLAGS_ZF () {0x40;}' unless defined(&X86_EFLAGS_ZF);
    eval 'sub X86_EFLAGS_SF () {0x80;}' unless defined(&X86_EFLAGS_SF);
    eval 'sub X86_EFLAGS_TF () {0x100;}' unless defined(&X86_EFLAGS_TF);
    eval 'sub X86_EFLAGS_IF () {0x200;}' unless defined(&X86_EFLAGS_IF);
    eval 'sub X86_EFLAGS_DF () {0x400;}' unless defined(&X86_EFLAGS_DF);
    eval 'sub X86_EFLAGS_OF () {0x800;}' unless defined(&X86_EFLAGS_OF);
    eval 'sub X86_EFLAGS_IOPL () {0x3000;}' unless defined(&X86_EFLAGS_IOPL);
    eval 'sub X86_EFLAGS_NT () {0x4000;}' unless defined(&X86_EFLAGS_NT);
    eval 'sub X86_EFLAGS_RF () {0x10000;}' unless defined(&X86_EFLAGS_RF);
    eval 'sub X86_EFLAGS_VM () {0x20000;}' unless defined(&X86_EFLAGS_VM);
    eval 'sub X86_EFLAGS_AC () {0x40000;}' unless defined(&X86_EFLAGS_AC);
    eval 'sub X86_EFLAGS_VIF () {0x80000;}' unless defined(&X86_EFLAGS_VIF);
    eval 'sub X86_EFLAGS_VIP () {0x100000;}' unless defined(&X86_EFLAGS_VIP);
    eval 'sub X86_EFLAGS_ID () {0x200000;}' unless defined(&X86_EFLAGS_ID);
    eval 'sub cpuid_ebx {
        my($op) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&cpuid_ebx);
    eval 'sub cpuid_ecx {
        my($op) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&cpuid_ecx);
    eval 'sub cpuid_edx {
        my($op) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&cpuid_edx);
    eval 'sub X86_CR4_VME () {0x1;}' unless defined(&X86_CR4_VME);
    eval 'sub X86_CR4_PVI () {0x2;}' unless defined(&X86_CR4_PVI);
    eval 'sub X86_CR4_TSD () {0x4;}' unless defined(&X86_CR4_TSD);
    eval 'sub X86_CR4_DE () {0x8;}' unless defined(&X86_CR4_DE);
    eval 'sub X86_CR4_PSE () {0x10;}' unless defined(&X86_CR4_PSE);
    eval 'sub X86_CR4_PAE () {0x20;}' unless defined(&X86_CR4_PAE);
    eval 'sub X86_CR4_MCE () {0x40;}' unless defined(&X86_CR4_MCE);
    eval 'sub X86_CR4_PGE () {0x80;}' unless defined(&X86_CR4_PGE);
    eval 'sub X86_CR4_PCE () {0x100;}' unless defined(&X86_CR4_PCE);
    eval 'sub X86_CR4_OSFXSR () {0x200;}' unless defined(&X86_CR4_OSFXSR);
    eval 'sub X86_CR4_OSXMMEXCPT () {0x400;}' unless defined(&X86_CR4_OSXMMEXCPT);
    eval 'sub set_in_cr4 {
        my($mask) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&set_in_cr4);
    eval 'sub clear_in_cr4 {
        my($mask) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&clear_in_cr4);
    eval 'sub CX86_CCR0 () {0xc0;}' unless defined(&CX86_CCR0);
    eval 'sub CX86_CCR1 () {0xc1;}' unless defined(&CX86_CCR1);
    eval 'sub CX86_CCR2 () {0xc2;}' unless defined(&CX86_CCR2);
    eval 'sub CX86_CCR3 () {0xc3;}' unless defined(&CX86_CCR3);
    eval 'sub CX86_CCR4 () {0xe8;}' unless defined(&CX86_CCR4);
    eval 'sub CX86_CCR5 () {0xe9;}' unless defined(&CX86_CCR5);
    eval 'sub CX86_CCR6 () {0xea;}' unless defined(&CX86_CCR6);
    eval 'sub CX86_CCR7 () {0xeb;}' unless defined(&CX86_CCR7);
    eval 'sub CX86_DIR0 () {0xfe;}' unless defined(&CX86_DIR0);
    eval 'sub CX86_DIR1 () {0xff;}' unless defined(&CX86_DIR1);
    eval 'sub CX86_ARR_BASE () {0xc4;}' unless defined(&CX86_ARR_BASE);
    eval 'sub CX86_RCR_BASE () {0xdc;}' unless defined(&CX86_RCR_BASE);
    eval 'sub getCx86 {
        my($reg) = @_;
	    eval q(({  &outb(($reg), 0x22);  &inb(0x23); }));
    }' unless defined(&getCx86);
    eval 'sub setCx86 {
        my($reg, $data) = @_;
	    eval q( &do {  &outb(($reg), 0x22);  &outb(($data), 0x23); }  &while (0));
    }' unless defined(&setCx86);
    eval 'sub TASK_SIZE () {( &PAGE_OFFSET);}' unless defined(&TASK_SIZE);
    eval 'sub TASK_UNMAPPED_BASE () {( &TASK_SIZE / 3);}' unless defined(&TASK_UNMAPPED_BASE);
    eval 'sub IO_BITMAP_SIZE () {32;}' unless defined(&IO_BITMAP_SIZE);
    eval 'sub IO_BITMAP_OFFSET () { &offsetof(\'struct tss_struct\', &io_bitmap);}' unless defined(&IO_BITMAP_OFFSET);
    eval 'sub INVALID_IO_BITMAP_OFFSET () {0x8000;}' unless defined(&INVALID_IO_BITMAP_OFFSET);
    eval 'sub INIT_THREAD () {{ 0, 0, 0, 0, 0, { [0... 7] = 0}, 0, 0, 0, { { 0, }, }, 0,0,0,0,0,0, 0,{~0,} };}' unless defined(&INIT_THREAD);
    eval 'sub INIT_MMAP () {{  &init_mm, 0, 0,  &NULL,  &PAGE_SHARED,  &VM_READ |  &VM_WRITE |  &VM_EXEC, 1,  &NULL,  &NULL };}' unless defined(&INIT_MMAP);
    eval 'sub INIT_TSS () {{ 0,0, $sizeof{ &init_stack} +   &init_stack,  &__KERNEL_DS, 0, 0,0,0,0,0,0, 0, 0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0,0,0, 0,0,0,0,0,0,  &__LDT(0),0, 0,  &INVALID_IO_BITMAP_OFFSET, {~0, } };}' unless defined(&INIT_TSS);
    eval 'sub start_thread {
        my($regs, $new_eip, $new_esp) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&start_thread);
    eval 'sub KSTK_EIP {
        my($tsk) = @_;
	    eval q((((4096+($tsk)))[1019]));
    }' unless defined(&KSTK_EIP);
    eval 'sub KSTK_ESP {
        my($tsk) = @_;
	    eval q((((4096+($tsk)))[1022]));
    }' unless defined(&KSTK_ESP);
    eval 'sub THREAD_SIZE () {(2* &PAGE_SIZE);}' unless defined(&THREAD_SIZE);
    eval 'sub MICROCODE_IOCFREE () { &_IO(ord(\'6\'),0);}' unless defined(&MICROCODE_IOCFREE);
}
1;
