//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#ifndef PXR_IMAGING_HD_SUBDIVISION_TAGS_SCHEMA_H
#define PXR_IMAGING_HD_SUBDIVISION_TAGS_SCHEMA_H

/// \file

#include "pxr/imaging/hd/api.h"

#include "pxr/imaging/hd/schema.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

// --(BEGIN CUSTOM CODE: Declares)--
// --(END CUSTOM CODE: Declares)--

#define HD_SUBDIVISION_TAGS_SCHEMA_TOKENS \
    (subdivisionTags) \
    (faceVaryingLinearInterpolation) \
    (interpolateBoundary) \
    (triangleSubdivisionRule) \
    (cornerIndices) \
    (cornerSharpnesses) \
    (creaseIndices) \
    (creaseLengths) \
    (creaseSharpnesses) \

TF_DECLARE_PUBLIC_TOKENS(HdSubdivisionTagsSchemaTokens, HD_API,
    HD_SUBDIVISION_TAGS_SCHEMA_TOKENS);

//-----------------------------------------------------------------------------


class HdSubdivisionTagsSchema : public HdSchema
{
public:
    /// \name Schema retrieval
    /// @{

    HdSubdivisionTagsSchema(HdContainerDataSourceHandle container)
      : HdSchema(container) {}

    /// Retrieves a container data source with the schema's default name token
    /// "subdivisionTags" from the parent container and constructs a
    /// HdSubdivisionTagsSchema instance.
    /// Because the requested container data source may not exist, the result
    /// should be checked with IsDefined() or a bool comparison before use.
    HD_API
    static HdSubdivisionTagsSchema GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer);

    /// @}

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

    /// \name Member accessor
    /// @{

    HD_API
    HdTokenDataSourceHandle GetFaceVaryingLinearInterpolation() const;

    HD_API
    HdTokenDataSourceHandle GetInterpolateBoundary() const;

    HD_API
    HdTokenDataSourceHandle GetTriangleSubdivisionRule() const;

    HD_API
    HdIntArrayDataSourceHandle GetCornerIndices() const;

    HD_API
    HdFloatArrayDataSourceHandle GetCornerSharpnesses() const;

    HD_API
    HdIntArrayDataSourceHandle GetCreaseIndices() const;

    HD_API
    HdIntArrayDataSourceHandle GetCreaseLengths() const;

    HD_API
    HdFloatArrayDataSourceHandle GetCreaseSharpnesses() const; 

    /// @}

    /// \name Schema location
    /// @{

    /// Returns a token where the container representing this schema is found in
    /// a container by default.
    HD_API
    static const TfToken &GetSchemaToken();

    /// Returns an HdDataSourceLocator (relative to the prim-level data source)
    /// where the container representing this schema is found by default.
    HD_API
    static const HdDataSourceLocator &GetDefaultLocator();

    /// @} 

    /// \name Schema construction
    /// @{

    /// \deprecated Use Builder instead.
    ///
    /// Builds a container data source which includes the provided child data
    /// sources. Parameters with nullptr values are excluded. This is a
    /// low-level interface. For cases in which it's desired to define
    /// the container with a sparse set of child fields, the Builder class
    /// is often more convenient and readable.
    HD_API
    static HdContainerDataSourceHandle
    BuildRetained(
        const HdTokenDataSourceHandle &faceVaryingLinearInterpolation,
        const HdTokenDataSourceHandle &interpolateBoundary,
        const HdTokenDataSourceHandle &triangleSubdivisionRule,
        const HdIntArrayDataSourceHandle &cornerIndices,
        const HdFloatArrayDataSourceHandle &cornerSharpnesses,
        const HdIntArrayDataSourceHandle &creaseIndices,
        const HdIntArrayDataSourceHandle &creaseLengths,
        const HdFloatArrayDataSourceHandle &creaseSharpnesses
    );

    /// \class HdSubdivisionTagsSchema::Builder
    /// 
    /// Utility class for setting sparse sets of child data source fields to be
    /// filled as arguments into BuildRetained. Because all setter methods
    /// return a reference to the instance, this can be used in the "builder
    /// pattern" form.
    class Builder
    {
    public:
        HD_API
        Builder &SetFaceVaryingLinearInterpolation(
            const HdTokenDataSourceHandle &faceVaryingLinearInterpolation);
        HD_API
        Builder &SetInterpolateBoundary(
            const HdTokenDataSourceHandle &interpolateBoundary);
        HD_API
        Builder &SetTriangleSubdivisionRule(
            const HdTokenDataSourceHandle &triangleSubdivisionRule);
        HD_API
        Builder &SetCornerIndices(
            const HdIntArrayDataSourceHandle &cornerIndices);
        HD_API
        Builder &SetCornerSharpnesses(
            const HdFloatArrayDataSourceHandle &cornerSharpnesses);
        HD_API
        Builder &SetCreaseIndices(
            const HdIntArrayDataSourceHandle &creaseIndices);
        HD_API
        Builder &SetCreaseLengths(
            const HdIntArrayDataSourceHandle &creaseLengths);
        HD_API
        Builder &SetCreaseSharpnesses(
            const HdFloatArrayDataSourceHandle &creaseSharpnesses);

        /// Returns a container data source containing the members set thus far.
        HD_API
        HdContainerDataSourceHandle Build();

    private:
        HdTokenDataSourceHandle _faceVaryingLinearInterpolation;
        HdTokenDataSourceHandle _interpolateBoundary;
        HdTokenDataSourceHandle _triangleSubdivisionRule;
        HdIntArrayDataSourceHandle _cornerIndices;
        HdFloatArrayDataSourceHandle _cornerSharpnesses;
        HdIntArrayDataSourceHandle _creaseIndices;
        HdIntArrayDataSourceHandle _creaseLengths;
        HdFloatArrayDataSourceHandle _creaseSharpnesses;

    };

    /// @}
};

PXR_NAMESPACE_CLOSE_SCOPE

#endif