\name{ThresholdSegmentationLevelSetImageFilter}
\alias{ThresholdSegmentationLevelSetImageFilter}
\title{ThresholdSegmentationLevelSetImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Segments structures in images based on intensity values.
ThresholdSegmentationLevelSetImageFilter}
\details{
IMPORTANT
The SegmentationLevelSetImageFilter class and the ThresholdSegmentationLevelSetFunction class contain additional information necessary to the full
understanding of how to use this filter.
OVERVIEW
This class is a level set method segmentation filter. It constructs a
speed function which is close to zero at the upper and lower bounds of
an intensity window, effectively locking the propagating front onto
those edges. Elsewhere, the front will propagate quickly.
INPUTS
This filter requires two inputs. The first input is a seed image. This
seed image must contain an isosurface that you want to use as the seed
for your segmentation. It can be a binary, graylevel, or floating
point image. The only requirement is that it contain a closed
isosurface that you will identify as the seed by setting the
IsosurfaceValue parameter of the filter. For a binary image you will
want to set your isosurface value halfway between your on and off
values (i.e. for 0's and 1's, use an isosurface value of 0.5).
The second input is the feature image. This is the image from which
the speed function will be calculated. For most applications, this is
the image that you want to segment. The desired isosurface in your
seed image should lie within the region of your feature image that you
are trying to segment. Note that this filter does no preprocessing of
the feature image before thresholding.
See SegmentationLevelSetImageFilter for more information on Inputs.
OUTPUTS
The filter outputs a single, scalar, real-valued image. Positive
values in the output image are inside the segmented region and
negative values in the image are outside of the inside region. The
zero crossings of the image correspond to the position of the level
set front.
See SparseFieldLevelSetImageFilter and SegmentationLevelSetImageFilter for more information.
PARAMETERS
In addition to parameters described in SegmentationLevelSetImageFilter , this filter adds the UpperThreshold and LowerThreshold. See ThresholdSegmentationLevelSetFunction for a description of how these values affect the segmentation.
See:
SegmentationLevelSetImageFilter
ThresholdSegmentationLevelSetFunction ,
SparseFieldLevelSetImageFilter
ThresholdSegmentationLevelSet for the procedural interface
itk::ThresholdSegmentationLevelSetImageFilter for the Doxygen on the original ITK class.
ThresholdSegmentationLevelSetImageFilter}
%C++ includes: sitkThresholdSegmentationLevelSetImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &initialImage, const Image &featureImage):}{}
\item{Image Execute(Image &&initialImage, const Image &featureImage):}{
Execute the filter on the input image
}
\item{double GetCurvatureScaling() const:}{}
\item{uint32_t GetElapsedIterations() const:}{
Number of iterations run.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetLowerThreshold() const:}{}
\item{double GetMaximumRMSError() const:}{}
\item{std::string GetName() const:}{
Name of this class
}
\item{uint32_t GetNumberOfIterations() const:}{}
\item{double GetPropagationScaling() const:}{}
\item{bool GetReverseExpansionDirection() const:}{}
\item{double GetRMSChange() const:}{
The Root Mean Square of the levelset upon termination.
This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.
}
\item{double GetUpperThreshold() const:}{}
\item{Self ReverseExpansionDirectionOff():}{}
\item{Self ReverseExpansionDirectionOn():}{
Set the value of ReverseExpansionDirection to true or false
respectfully.
}
\item{Self SetCurvatureScaling(double CurvatureScaling):}{}
\item{Self SetLowerThreshold(double LowerThreshold):}{}
\item{Self SetMaximumRMSError(double MaximumRMSError):}{}
\item{Self SetNumberOfIterations(uint32_t NumberOfIterations):}{}
\item{Self SetPropagationScaling(double PropagationScaling):}{}
\item{Self SetReverseExpansionDirection(bool ReverseExpansionDirection):}{}
\item{Self SetUpperThreshold(double UpperThreshold):}{
Get/Set the threshold values that will be used to calculate the speed
function.
}
\item{ ThresholdSegmentationLevelSetImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~ThresholdSegmentationLevelSetImageFilter():}{
Destructor
}
}
}
