'''OpenGL extension NV.robustness_video_memory_purge

This module customises the behaviour of the 
OpenGL.raw.GL.NV.robustness_video_memory_purge to provide a more 
Python-friendly API

Overview (from the spec)
	
	Allow applications to be notified when video memory has been purged.
	
	The NVIDIA OpenGL driver architecture on Linux has a limitation:
	resources located in video memory are not persistent across certain
	events. VT switches, suspend/resume events, and mode switching
	events may erase the contents of video memory. Any resource that
	is located exclusively in video memory, such as framebuffer objects
	(FBOs), will be lost. As the OpenGL specification makes no mention
	of events where the video memory is allowed to be cleared, the
	driver attempts to hide this fact from the application, but cannot
	do it for all resources.
	
	This extension provides a way for applications to discover when video
	memory content has been lost, so that the application can re-populate
	the video memory content as necessary.
	
	This extension will have a limited lifespan, as planned architectural
	evolutions in the NVIDIA Linux driver stack will allow
	video memory to be persistent. Any driver that exposes this
	extension is a driver that considers video memory to be
	volatile. Once the driver stack has been improved, the extension
	will no longer be exposed.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/robustness_video_memory_purge.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.robustness_video_memory_purge import *
from OpenGL.raw.GL.NV.robustness_video_memory_purge import _EXTENSION_NAME

def glInitRobustnessVideoMemoryPurgeNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION