/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLPredicate;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class OWLEntityCollector
implements OWLObjectVisitorEx<Collection<OWLEntity>>,
SWRLObjectVisitorEx<Collection<OWLEntity>> {
    @Nonnull
    private final Collection<OWLEntity> objects;

    public OWLEntityCollector(@Nonnull Set<OWLEntity> toReturn) {
        this.objects = OWLAPIPreconditions.checkNotNull(toReturn, "toReturn cannot be null");
    }

    protected void processAxiomAnnotations(@Nonnull OWLAxiom ax) {
        for (OWLAnnotation anno : ax.getAnnotations()) {
            anno.accept(this);
        }
    }

    @Override
    public Collection<OWLEntity> visit(OWLSubClassOfAxiom axiom) {
        axiom.getSubClass().accept(this);
        axiom.getSuperClass().accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLReflexiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDisjointClassesAxiom axiom) {
        for (OWLClassExpression desc : axiom.getClassExpressions()) {
            desc.accept(this);
        }
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDataPropertyDomainAxiom axiom) {
        axiom.getDomain().accept(this);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLObjectPropertyDomainAxiom axiom) {
        axiom.getDomain().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLLiteral)axiom.getObject()).accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDifferentIndividualsAxiom axiom) {
        for (OWLIndividual ind : axiom.getIndividuals()) {
            ind.accept(this);
        }
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDisjointDataPropertiesAxiom axiom) {
        for (OWLDataPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDisjointObjectPropertiesAxiom axiom) {
        for (OWLObjectPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLObjectPropertyRangeAxiom axiom) {
        ((OWLClassExpression)axiom.getRange()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLObjectPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLFunctionalObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLSubObjectPropertyOfAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDisjointUnionAxiom axiom) {
        axiom.getOWLClass().accept(this);
        for (OWLClassExpression desc : axiom.getClassExpressions()) {
            desc.accept(this);
        }
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDeclarationAxiom axiom) {
        axiom.getEntity().accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLSymmetricObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDataPropertyRangeAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLDataRange)axiom.getRange()).accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLFunctionalDataPropertyAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLEquivalentDataPropertiesAxiom axiom) {
        for (OWLDataPropertyExpression prop : axiom.getProperties()) {
            prop.accept(this);
        }
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLClassAssertionAxiom axiom) {
        axiom.getClassExpression().accept(this);
        axiom.getIndividual().accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLEquivalentClassesAxiom axiom) {
        for (OWLClassExpression desc : axiom.getClassExpressions()) {
            desc.accept(this);
        }
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDataPropertyAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        ((OWLLiteral)axiom.getObject()).accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLTransitiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLSubDataPropertyOfAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLSameIndividualAxiom axiom) {
        for (OWLIndividual ind : axiom.getIndividuals()) {
            ind.accept(this);
        }
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLSubPropertyChainOfAxiom axiom) {
        for (OWLObjectPropertyExpression prop : axiom.getPropertyChain()) {
            prop.accept(this);
        }
        axiom.getSuperProperty().accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLInverseObjectPropertiesAxiom axiom) {
        axiom.getFirstProperty().accept(this);
        axiom.getSecondProperty().accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLHasKeyAxiom axiom) {
        axiom.getClassExpression().accept(this);
        for (OWLPropertyExpression prop : axiom.getPropertyExpressions()) {
            prop.accept(this);
        }
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLClass ce) {
        this.objects.add(ce);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLObjectIntersectionOf ce) {
        for (OWLClassExpression operand : ce.getOperands()) {
            operand.accept(this);
        }
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLObjectUnionOf ce) {
        for (OWLClassExpression operand : ce.getOperands()) {
            operand.accept(this);
        }
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLObjectComplementOf ce) {
        ce.getOperand().accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLObjectSomeValuesFrom ce) {
        ce.getProperty().accept(this);
        ((OWLClassExpression)ce.getFiller()).accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLObjectAllValuesFrom ce) {
        ce.getProperty().accept(this);
        ((OWLClassExpression)ce.getFiller()).accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLObjectHasValue ce) {
        ce.getProperty().accept(this);
        ((OWLIndividual)ce.getFiller()).accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLObjectMinCardinality ce) {
        ce.getProperty().accept(this);
        ((OWLClassExpression)ce.getFiller()).accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLObjectExactCardinality ce) {
        ce.getProperty().accept(this);
        ((OWLClassExpression)ce.getFiller()).accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLObjectMaxCardinality ce) {
        ce.getProperty().accept(this);
        ((OWLClassExpression)ce.getFiller()).accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLObjectHasSelf ce) {
        ce.getProperty().accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLObjectOneOf ce) {
        for (OWLIndividual ind : ce.getIndividuals()) {
            ind.accept(this);
        }
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDataSomeValuesFrom ce) {
        ce.getProperty().accept(this);
        ((OWLDataRange)ce.getFiller()).accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDataAllValuesFrom ce) {
        ce.getProperty().accept(this);
        ((OWLDataRange)ce.getFiller()).accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDataHasValue ce) {
        ce.getProperty().accept(this);
        ((OWLLiteral)ce.getFiller()).accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDataMinCardinality ce) {
        ce.getProperty().accept(this);
        ((OWLDataRange)ce.getFiller()).accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDataExactCardinality ce) {
        ce.getProperty().accept(this);
        ((OWLDataRange)ce.getFiller()).accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDataMaxCardinality ce) {
        ce.getProperty().accept(this);
        ((OWLDataRange)ce.getFiller()).accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDataComplementOf node) {
        node.getDataRange().accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDataOneOf node) {
        for (OWLLiteral val : node.getValues()) {
            val.accept(this);
        }
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDataIntersectionOf node) {
        for (OWLDataRange dr : node.getOperands()) {
            dr.accept(this);
        }
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDataUnionOf node) {
        for (OWLDataRange dr : node.getOperands()) {
            dr.accept(this);
        }
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDatatypeRestriction node) {
        node.getDatatype().accept(this);
        for (OWLFacetRestriction facetRestriction : node.getFacetRestrictions()) {
            facetRestriction.accept(this);
        }
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLFacetRestriction node) {
        node.getFacetValue().accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLLiteral node) {
        node.getDatatype().accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLObjectInverseOf property) {
        property.getInverse().accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLObjectProperty property) {
        this.objects.add(property);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDataProperty property) {
        this.objects.add(property);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLNamedIndividual individual) {
        this.objects.add(individual);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDatatype node) {
        this.objects.add(node);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLAnnotation node) {
        node.getProperty().accept(this);
        node.getValue().accept(this);
        for (OWLAnnotation anno : node.getAnnotations()) {
            anno.accept(this);
        }
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLAnnotationAssertionAxiom axiom) {
        axiom.getSubject().accept(this);
        axiom.getProperty().accept(this);
        axiom.getValue().accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLAnonymousIndividual individual) {
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(IRI iri) {
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLOntology ontology) {
        this.objects.addAll(ontology.getSignature());
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLAnnotationProperty property) {
        this.objects.add(property);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLAnnotationPropertyDomainAxiom axiom) {
        axiom.getProperty().accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLAnnotationPropertyRangeAxiom axiom) {
        axiom.getProperty().accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        axiom.getSubProperty().accept(this);
        axiom.getSuperProperty().accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(OWLDatatypeDefinitionAxiom axiom) {
        axiom.getDatatype().accept(this);
        axiom.getDataRange().accept(this);
        this.processAxiomAnnotations(axiom);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(SWRLRule rule) {
        for (SWRLAtom atom : rule.getBody()) {
            atom.accept(this);
        }
        for (SWRLAtom atom : rule.getHead()) {
            atom.accept(this);
        }
        this.processAxiomAnnotations(rule);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(SWRLClassAtom node) {
        ((SWRLIArgument)node.getArgument()).accept(this);
        node.getPredicate().accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(SWRLDataRangeAtom node) {
        ((SWRLDArgument)node.getArgument()).accept(this);
        node.getPredicate().accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(SWRLObjectPropertyAtom node) {
        node.getPredicate().accept(this);
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(SWRLDataPropertyAtom node) {
        node.getPredicate().accept(this);
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        ((SWRLDArgument)node.getSecondArgument()).accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(SWRLBuiltInAtom node) {
        for (SWRLArgument obj : node.getAllArguments()) {
            obj.accept(this);
        }
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(SWRLVariable node) {
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(SWRLIndividualArgument node) {
        node.getIndividual().accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(SWRLLiteralArgument node) {
        node.getLiteral().accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(SWRLDifferentIndividualsAtom node) {
        SWRLPredicate predicate = node.getPredicate();
        if (predicate instanceof OWLObject) {
            ((OWLObject)((Object)predicate)).accept(this);
        }
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLEntity> visit(SWRLSameIndividualAtom node) {
        SWRLPredicate predicate = node.getPredicate();
        if (predicate instanceof OWLObject) {
            ((OWLObject)((Object)predicate)).accept(this);
        }
        ((SWRLIArgument)node.getFirstArgument()).accept(this);
        ((SWRLIArgument)node.getSecondArgument()).accept(this);
        return this.objects;
    }
}

