import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { getSerdePlugin } from "@smithy/middleware-serde";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { CreateDistributionRequestFilterSensitiveLog, CreateDistributionResultFilterSensitiveLog, } from "../models/models_0";
import { de_CreateDistributionCommand, se_CreateDistributionCommand } from "../protocols/Aws_restXml";
export { $Command };
export class CreateDistributionCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [
        getSerdePlugin(config, this.serialize, this.deserialize),
        getEndpointPlugin(config, Command.getEndpointParameterInstructions()),
    ];
})
    .s("Cloudfront2020_05_31", "CreateDistribution", {})
    .n("CloudFrontClient", "CreateDistributionCommand")
    .f(CreateDistributionRequestFilterSensitiveLog, CreateDistributionResultFilterSensitiveLog)
    .ser(se_CreateDistributionCommand)
    .de(de_CreateDistributionCommand)
    .build() {
}
