/**
 * ./src/components/users.tsx
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import React, { useState } from 'react';
import { Text, Box } from 'ink';
import Title from './title.js';
import Steps from './steps.js';
import yaml from 'js-yaml';
import fs from 'fs';
// pjson
import { createRequire } from 'module';
const require = createRequire(import.meta.url);
const pjson = require('../../../package.json');
// create your forceUpdate hook
function useForceUpdate() {
    const [value, setValue] = useState(0); // integer state
    return () => setValue((value) => value + 1); // update the state to force render
}
/**
 *
 * @param param0
 * @returns
 */
export default function Users({ username, fullname, password, rootPassword, hostname, autologin, sameUserPassword }) {
    let productName = 'unknown';
    let version = 'x.x.x';
    let configRoot = '/etc/penguins-eggs.d/krill/';
    if (fs.existsSync('/etc/calamares/settings.conf')) {
        configRoot = '/etc/calamares/';
    }
    const settings = yaml.load(fs.readFileSync(configRoot + 'settings.conf', 'utf-8'));
    const branding = settings.branding;
    const calamares = yaml.load(fs.readFileSync(configRoot + 'branding/' + branding + '/branding.desc', 'utf-8'));
    productName = calamares.strings.productName;
    version = calamares.strings.version;
    /**
    * totale width=75
    * step width=15
    * finestra with=59
    */
    let charAutologin = "[x] ";
    if (autologin) {
        charAutologin = "[ ]";
    }
    charAutologin = ""; // Hidden
    if (sameUserPassword) {
        rootPassword = password;
    }
    const forceUpdate = useForceUpdate();
    return (React.createElement(React.Fragment, null,
        React.createElement(Title, null),
        React.createElement(Box, { width: 75, height: 11, borderStyle: "round", flexDirection: "column" },
            React.createElement(Box, { flexDirection: "column" },
                React.createElement(Box, { flexDirection: "row" },
                    React.createElement(Steps, { step: 5 }),
                    React.createElement(Box, { flexDirection: "column" },
                        React.createElement(Box, null,
                            React.createElement(Text, null, "username     : "),
                            React.createElement(Text, { color: "cyan" }, username)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "full username: "),
                            React.createElement(Text, { color: "cyan" }, fullname)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "user password: "),
                            React.createElement(Text, { color: "cyan" }, password)),
                        React.createElement(Box, null),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "root password: "),
                            React.createElement(Text, { color: "cyan" }, rootPassword)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "hostname     : "),
                            React.createElement(Text, { color: "cyan" }, hostname)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, " "),
                            React.createElement(Text, { color: "cyan" }, charAutologin))))))));
}
