/**
 * Sequence - Simple Refactoring
 * ./src/krill/sequence.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { IRemix, IDistro, INet } from '../../interfaces/index.js';
import Settings from '../../classes/settings.js';
import CliAutologin from '../../classes/cli-autologin.js';
import { IInstaller, IDevices } from '../../interfaces/index.js';
import { ILocation, IKeyboard, IPartitions, IUsers } from '../interfaces/i_krill.js';
import partition from './sequence.d/partition.js';
import biosStandard from './sequence.d/partition.d/bios_standard.js';
import biosLuks from './sequence.d/partition.d/bios_luks.js';
import uefiStandard from './sequence.d/partition.d/uefi_standard.js';
import uefiLuks from './sequence.d/partition.d/uefi_luks.js';
import { mountFs, umountFs } from './sequence.d/mount_fs.js';
import { mountVfs, umountVfs } from './sequence.d/mount_vfs.js';
import unpackfs from './sequence.d/unpackfs.js';
import machineId from './sequence.d/machine_id.js';
import fstab from './sequence.d/fstab.js';
import locale from './sequence.d/locale.js';
import mKeyboard from './sequence.d/m_keyboard.js';
import localeCfg from './sequence.d/locale_cfg.js';
import addUser from './sequence.d/add_user.js';
import changePassword from './sequence.d/change_password.js';
import networkCfg from './sequence.d/network_cfg.js';
import bootloaderConfig from './sequence.d/bootloader_config.js';
import grubcfg from './sequence.d/grubcfg.js';
import bootloader from './sequence.d/bootloader.js';
import packages from './sequence.d/packages.js';
import removeInstallerLink from './sequence.d/remove_installer_link.js';
import initramfsCfg from './sequence.d/initramfs_cfg.js';
import initramfs from './sequence.d/initramfs.js';
import delLiveUser from './sequence.d/del_live_user.js';
import umount from './sequence.d/umount.js';
import mkfs from './sequence.d/mkfs.js';
import hostname from './sequence.d/hostname.js';
/**
 * Main Sequence class - Simple Refactoring
 */
export default class Sequence {
    partition: typeof partition;
    partitionBiosStandard: typeof biosStandard;
    partitionUefiStandard: typeof uefiStandard;
    partitionBiosLuks: typeof biosLuks;
    partitionUefiLuks: typeof uefiLuks;
    mountFs: typeof mountFs;
    mountVfs: typeof mountVfs;
    unpackfs: typeof unpackfs;
    machineId: typeof machineId;
    fstab: typeof fstab;
    locale: typeof locale;
    keyboard: typeof mKeyboard;
    localeCfg: typeof localeCfg;
    addUser: typeof addUser;
    changePassword: typeof changePassword;
    networkCfg: typeof networkCfg;
    bootloaderConfig: typeof bootloaderConfig;
    grubcfg: typeof grubcfg;
    bootloader: typeof bootloader;
    packages: typeof packages;
    removeInstallerLink: typeof removeInstallerLink;
    initramfsCfg: typeof initramfsCfg;
    initramfs: typeof initramfs;
    delLiveUser: typeof delLiveUser;
    umountFs: typeof umountFs;
    umountVfs: typeof umountVfs;
    umount: typeof umount;
    mkfs: typeof mkfs;
    hostname: typeof hostname;
    installer: IInstaller;
    installTarget: string;
    verbose: boolean;
    echo: {};
    efi: boolean;
    devices: IDevices;
    users: IUsers;
    network: INet;
    partitions: IPartitions;
    swapSize: number;
    language: string;
    region: string;
    zone: string;
    keyboardModel: string;
    keyboardLayout: string;
    keyboardVariant: string;
    toNull: string;
    spinner: boolean;
    settings: Settings;
    remix: IRemix;
    distro: IDistro;
    luksName: string;
    luksFile: string;
    luksDevice: string;
    luksMountpoint: string;
    is_clone: boolean;
    is_crypted_clone: boolean;
    unattended: boolean;
    nointeractive: boolean;
    chroot: boolean;
    halt: boolean;
    cliAutologin: CliAutologin;
    /**
     * Constructor (unchanged)
     */
    constructor(location: ILocation, keyboard: IKeyboard, partitions: IPartitions, users: IUsers, network: INet);
    /**
     * Helper method to execute a step with standard error handling
     */
    private executeStep;
    /**
     * Main start method - Much cleaner sequence
     */
    start(domain?: string, unattended?: boolean, nointeractive?: boolean, chroot?: boolean, halt?: boolean, verbose?: boolean): Promise<void>;
    /**
     * Setup installation parameters and environment
     */
    private setupInstallation;
    /**
     * Main installation sequence - Linear and clear
     */
    private runInstallationSequence;
    /**
     * Complete installation with reboot/halt
     */
    private completeInstallation;
    execCalamaresModule(name: string): Promise<void>;
    emergencyShell(message: string): Promise<void>;
    showProblem(message: string, currErr: any): Promise<void>;
}
