/**
 * ./src/classes/families/voidlinux.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
/**
 * Utils: general porpourse utils
 * @remarks all the utilities
 */
export default class Voidlinux {
    static packs4calamares: string[];
    /**
     *
     */
    static calamaresInstall(verbose?: boolean): Promise<void>;
    /**
     * calamaresPolicies
     */
    static calamaresPolicies(verbose?: boolean): Promise<void>;
    /**
     *
     */
    static calamaresRemove(verbose?: boolean): Promise<boolean>;
    /**
     * check if it's installed wayland
     * @returns true if wayland
     */
    static isInstalledWayland(): boolean;
    /**
     * check if it's installed xorg
     * @returns true if xorg is installed
     */
    static isInstalledXorg(): boolean;
    /**
     * restuisce VERO se il pacchetto è installato
     * @param packageName
     */
    static packageAvailable(packageName: string): Promise<boolean>;
    /**
     * Install the package packageName
     * @param packageName {string} Pacchetto da installare
     * @returns {boolean} True if success
     */
    static packageInstall(packageName: string): Promise<boolean>;
    /**
     * restuisce VERO se il pacchetto è installato
     * @param packageName
     */
    static packageIsInstalled(packageName: string): boolean;
}
