/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.search.collector;

import java.util.Locale;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.opensearch.index.mapper.KeywordFieldMapper;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.neuralsearch.search.HitsThresholdChecker;
import org.opensearch.neuralsearch.search.collector.HybridCollapsingTopDocsCollector;
import org.opensearch.neuralsearch.search.collector.HybridCollectorFactoryDTO;
import org.opensearch.neuralsearch.search.collector.HybridTopScoreDocCollector;
import org.opensearch.neuralsearch.search.collector.PagingFieldCollector;
import org.opensearch.neuralsearch.search.collector.SimpleFieldCollector;
import org.opensearch.search.collapse.CollapseContext;
import org.opensearch.search.internal.SearchContext;
import org.opensearch.search.sort.SortAndFormats;

public class HybridCollectorFactory {
    public static Collector createCollector(HybridCollectorFactoryDTO hybridCollectorFactoryDTO) {
        CollapseContext collapseContext = hybridCollectorFactoryDTO.getCollapseContext();
        SortAndFormats sortAndFormats = hybridCollectorFactoryDTO.getSortAndFormats();
        SearchContext searchContext = hybridCollectorFactoryDTO.getSearchContext();
        HitsThresholdChecker hitsThresholdChecker = hybridCollectorFactoryDTO.getHitsThresholdChecker();
        int numHits = hybridCollectorFactoryDTO.getNumHits();
        FieldDoc after = hybridCollectorFactoryDTO.getAfter();
        if (collapseContext != null) {
            MappedFieldType fieldType = collapseContext.getFieldType();
            if (fieldType instanceof KeywordFieldMapper.KeywordFieldType) {
                return HybridCollapsingTopDocsCollector.createKeyword(collapseContext.getFieldName(), fieldType, sortAndFormats == null ? new Sort(new SortField[]{new SortField(null, SortField.Type.SCORE)}) : sortAndFormats.sort, numHits, hitsThresholdChecker);
            }
            if (fieldType instanceof NumberFieldMapper.NumberFieldType) {
                return HybridCollapsingTopDocsCollector.createNumeric(collapseContext.getFieldName(), fieldType, sortAndFormats == null ? new Sort(new SortField[]{new SortField(null, SortField.Type.SCORE)}) : sortAndFormats.sort, numHits, hitsThresholdChecker);
            }
            throw new IllegalStateException(String.format(Locale.ROOT, "unknown type for collapse field %s, only keywords and numbers are accepted", collapseContext.getFieldName()));
        }
        if (sortAndFormats == null) {
            return new HybridTopScoreDocCollector(numHits, hitsThresholdChecker);
        }
        if (after == null) {
            return new SimpleFieldCollector(numHits, hitsThresholdChecker, sortAndFormats.sort);
        }
        HybridCollectorFactory.validateSearchAfterFieldAndSortFormats(sortAndFormats, after);
        return new PagingFieldCollector(numHits, hitsThresholdChecker, sortAndFormats.sort, after);
    }

    private static void validateSearchAfterFieldAndSortFormats(SortAndFormats sortAndFormats, FieldDoc after) {
        if (after.fields == null) {
            throw new IllegalArgumentException("after.fields wasn't set; you must pass fillFields=true for the previous search");
        }
        if (after.fields.length != sortAndFormats.sort.getSort().length) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "after.fields has %s values but sort has %s", after.fields.length, sortAndFormats.sort.getSort().length));
        }
    }
}

