/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.document.FeatureField;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.opensearch.OpenSearchException;
import org.opensearch.Version;
import org.opensearch.common.SetOnce;
import org.opensearch.common.collect.Tuple;
import org.opensearch.core.ParseField;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.WithFieldName;
import org.opensearch.neuralsearch.ml.MLCommonsClientAccessor;
import org.opensearch.neuralsearch.processor.TextInferenceRequest;
import org.opensearch.neuralsearch.query.ModelInferenceQueryBuilder;
import org.opensearch.neuralsearch.query.NeuralSparseQueryTwoPhaseInfo;
import org.opensearch.neuralsearch.stats.events.EventStatName;
import org.opensearch.neuralsearch.stats.events.EventStatsManager;
import org.opensearch.neuralsearch.util.NeuralSearchClusterUtil;
import org.opensearch.neuralsearch.util.TokenWeightUtil;
import org.opensearch.neuralsearch.util.prune.PruneType;
import org.opensearch.neuralsearch.util.prune.PruneUtils;
import org.opensearch.transport.client.Client;

public class NeuralSparseQueryBuilder
extends AbstractQueryBuilder<NeuralSparseQueryBuilder>
implements ModelInferenceQueryBuilder,
WithFieldName {
    public static final String NAME = "neural_sparse";
    @VisibleForTesting
    static final ParseField QUERY_TEXT_FIELD = new ParseField("query_text", new String[0]);
    @VisibleForTesting
    static final ParseField QUERY_TOKENS_FIELD = new ParseField("query_tokens", new String[0]);
    @VisibleForTesting
    static final ParseField MODEL_ID_FIELD = new ParseField("model_id", new String[0]);
    @Deprecated
    @VisibleForTesting
    static final ParseField MAX_TOKEN_SCORE_FIELD = new ParseField("max_token_score", new String[0]).withAllDeprecated();
    @VisibleForTesting
    static final ParseField ANALYZER_FIELD = new ParseField("analyzer", new String[0]);
    private static MLCommonsClientAccessor ML_CLIENT;
    private static final String DEFAULT_ANALYZER = "bert-uncased";
    private String fieldName;
    private String queryText;
    private String modelId;
    private String analyzer;
    private Float maxTokenScore;
    private Supplier<Map<String, Float>> queryTokensSupplier;
    private Map<String, Float> twoPhaseSharedQueryToken;
    private NeuralSparseQueryTwoPhaseInfo neuralSparseQueryTwoPhaseInfo = new NeuralSparseQueryTwoPhaseInfo();
    private static final Version MINIMAL_SUPPORTED_VERSION_DEFAULT_MODEL_ID;
    private static final Version MINIMAL_SUPPORTED_VERSION_ANALYZER;

    public static void initialize(MLCommonsClientAccessor mlClient) {
        ML_CLIENT = mlClient;
    }

    public NeuralSparseQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.queryText = in.readString();
        this.modelId = NeuralSparseQueryBuilder.isClusterOnOrAfterMinReqVersionForDefaultModelIdSupport() ? in.readOptionalString() : in.readString();
        this.maxTokenScore = in.readOptionalFloat();
        if (in.readBoolean()) {
            Map queryTokens = in.readMap(StreamInput::readString, StreamInput::readFloat);
            this.queryTokensSupplier = () -> queryTokens;
        }
        if (NeuralSparseQueryBuilder.isClusterOnOrAfterMinReqVersionForAnalyzer()) {
            this.analyzer = in.readOptionalString();
            this.neuralSparseQueryTwoPhaseInfo = new NeuralSparseQueryTwoPhaseInfo(in);
        }
        if ("".equals(this.queryText)) {
            this.queryText = null;
        }
        if ("".equals(this.modelId)) {
            this.modelId = null;
        }
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeString(StringUtils.defaultString((String)this.queryText, (String)""));
        if (NeuralSparseQueryBuilder.isClusterOnOrAfterMinReqVersionForDefaultModelIdSupport()) {
            out.writeOptionalString(this.modelId);
        } else {
            out.writeString(StringUtils.defaultString((String)this.modelId, (String)""));
        }
        out.writeOptionalFloat(this.maxTokenScore);
        if (!Objects.isNull(this.queryTokensSupplier) && !Objects.isNull(this.queryTokensSupplier.get())) {
            out.writeBoolean(true);
            out.writeMap(this.queryTokensSupplier.get(), StreamOutput::writeString, StreamOutput::writeFloat);
        } else {
            out.writeBoolean(false);
        }
        if (NeuralSparseQueryBuilder.isClusterOnOrAfterMinReqVersionForAnalyzer()) {
            out.writeOptionalString(this.analyzer);
            this.neuralSparseQueryTwoPhaseInfo.writeTo(out);
        }
    }

    public NeuralSparseQueryBuilder getCopyNeuralSparseQueryBuilderForTwoPhase(float pruneRatio, PruneType pruneType) {
        this.neuralSparseQueryTwoPhaseInfo = new NeuralSparseQueryTwoPhaseInfo(NeuralSparseQueryTwoPhaseInfo.TwoPhaseStatus.PHASE_ONE, pruneRatio, pruneType);
        NeuralSparseQueryBuilder copy = ((NeuralSparseQueryBuilder)new NeuralSparseQueryBuilder().fieldName(this.fieldName).queryName(this.queryName)).queryText(this.queryText).modelId(this.modelId).analyzer(this.analyzer).maxTokenScore(this.maxTokenScore).neuralSparseQueryTwoPhaseInfo(new NeuralSparseQueryTwoPhaseInfo(NeuralSparseQueryTwoPhaseInfo.TwoPhaseStatus.PHASE_TWO, pruneRatio, pruneType));
        if (Objects.nonNull(this.queryTokensSupplier)) {
            Map<String, Float> tokens = this.queryTokensSupplier.get();
            Tuple<Map<String, Float>, Map<String, Float>> splitTokens = PruneUtils.splitSparseVector(pruneType, pruneRatio, tokens);
            this.queryTokensSupplier(() -> (Map)splitTokens.v1());
            copy.queryTokensSupplier(() -> (Map)splitTokens.v2());
        } else {
            copy.queryTokensSupplier(() -> this.twoPhaseSharedQueryToken);
        }
        return copy;
    }

    protected void doXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
        xContentBuilder.startObject(NAME);
        xContentBuilder.startObject(this.fieldName);
        if (Objects.nonNull(this.queryText)) {
            xContentBuilder.field(QUERY_TEXT_FIELD.getPreferredName(), this.queryText);
        }
        if (Objects.nonNull(this.modelId)) {
            xContentBuilder.field(MODEL_ID_FIELD.getPreferredName(), this.modelId);
        }
        if (Objects.nonNull(this.analyzer)) {
            xContentBuilder.field(ANALYZER_FIELD.getPreferredName(), this.analyzer);
        }
        if (Objects.nonNull(this.maxTokenScore)) {
            xContentBuilder.field(MAX_TOKEN_SCORE_FIELD.getPreferredName(), this.maxTokenScore);
        }
        if (Objects.nonNull(this.queryTokensSupplier) && Objects.nonNull(this.queryTokensSupplier.get())) {
            xContentBuilder.field(QUERY_TOKENS_FIELD.getPreferredName(), this.queryTokensSupplier.get());
        }
        this.printBoostAndQueryName(xContentBuilder);
        xContentBuilder.endObject();
        xContentBuilder.endObject();
    }

    public static NeuralSparseQueryBuilder fromXContent(XContentParser parser) throws IOException {
        EventStatsManager.increment(EventStatName.NEURAL_SPARSE_QUERY_REQUESTS);
        NeuralSparseQueryBuilder sparseEncodingQueryBuilder = new NeuralSparseQueryBuilder();
        if (parser.currentToken() != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "First token of neural_sparsequery must be START_OBJECT", new Object[0]);
        }
        parser.nextToken();
        sparseEncodingQueryBuilder.fieldName(parser.currentName());
        parser.nextToken();
        NeuralSparseQueryBuilder.parseQueryParams(parser, sparseEncodingQueryBuilder);
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "[%s] query doesn't support multiple fields, found [%s] and [%s]", NAME, sparseEncodingQueryBuilder.fieldName(), parser.currentName()), new Object[0]);
        }
        NeuralSparseQueryBuilder.requireValue((Object)sparseEncodingQueryBuilder.fieldName(), (String)"Field name must be provided for neural_sparse query");
        if (Objects.isNull(sparseEncodingQueryBuilder.queryTokensSupplier())) {
            NeuralSparseQueryBuilder.requireValue((Object)sparseEncodingQueryBuilder.queryText(), (String)String.format(Locale.ROOT, "either %s field or %s field must be provided for [%s] query", QUERY_TEXT_FIELD.getPreferredName(), QUERY_TOKENS_FIELD.getPreferredName(), NAME));
            if (!NeuralSparseQueryBuilder.isClusterOnOrAfterMinReqVersionForDefaultModelIdSupport()) {
                NeuralSparseQueryBuilder.requireValue((Object)sparseEncodingQueryBuilder.modelId(), (String)String.format(Locale.ROOT, "using %s, %s field must be provided for [%s] query", QUERY_TEXT_FIELD.getPreferredName(), MODEL_ID_FIELD.getPreferredName(), NAME));
            }
        }
        if ("".equals(sparseEncodingQueryBuilder.queryText())) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s field can not be empty", QUERY_TEXT_FIELD.getPreferredName()));
        }
        if ("".equals(sparseEncodingQueryBuilder.modelId())) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s field can not be empty", MODEL_ID_FIELD.getPreferredName()));
        }
        if ("".equals(sparseEncodingQueryBuilder.analyzer())) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s field can not be empty", ANALYZER_FIELD.getPreferredName()));
        }
        return sparseEncodingQueryBuilder;
    }

    private static void parseQueryParams(XContentParser parser, NeuralSparseQueryBuilder sparseEncodingQueryBuilder) throws IOException {
        XContentParser.Token token;
        String currentFieldName = "";
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    sparseEncodingQueryBuilder.queryName(parser.text());
                    continue;
                }
                if (BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    sparseEncodingQueryBuilder.boost(parser.floatValue());
                    continue;
                }
                if (QUERY_TEXT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    sparseEncodingQueryBuilder.queryText(parser.text());
                    continue;
                }
                if (MODEL_ID_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    sparseEncodingQueryBuilder.modelId(parser.text());
                    continue;
                }
                if (ANALYZER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    sparseEncodingQueryBuilder.analyzer(parser.text());
                    continue;
                }
                if (MAX_TOKEN_SCORE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    sparseEncodingQueryBuilder.maxTokenScore(Float.valueOf(parser.floatValue()));
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "[%s] query does not support [%s] field", NAME, currentFieldName), new Object[0]);
            }
            if (QUERY_TOKENS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                Map queryTokens = parser.map(HashMap::new, XContentParser::floatValue);
                sparseEncodingQueryBuilder.queryTokensSupplier(() -> queryTokens);
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "[%s] unknown token [%s] after [%s]", NAME, token, currentFieldName), new Object[0]);
        }
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) {
        if (Objects.nonNull(this.queryTokensSupplier)) {
            return this;
        }
        if (this.shouldUseAnalyzer()) {
            return this;
        }
        NeuralSparseQueryBuilder.validateForRewrite(this.queryText, this.modelId);
        SetOnce queryTokensSetOnce = new SetOnce();
        queryRewriteContext.registerAsyncAction(this.getModelInferenceAsync((SetOnce<Map<String, Float>>)queryTokensSetOnce));
        return new NeuralSparseQueryBuilder().fieldName(this.fieldName).queryText(this.queryText).modelId(this.modelId).maxTokenScore(this.maxTokenScore).queryTokensSupplier(() -> ((SetOnce)queryTokensSetOnce).get()).twoPhaseSharedQueryToken(this.twoPhaseSharedQueryToken).neuralSparseQueryTwoPhaseInfo(this.neuralSparseQueryTwoPhaseInfo);
    }

    private boolean shouldUseAnalyzer() {
        if (this.modelId != null && this.analyzer != null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Cannot use both [%s: %s] and [%s: %s] for neural sparse query tokenization. Specify only one tokenization method. These parameters can be set either in the query or through the %s search processor.", MODEL_ID_FIELD.getPreferredName(), this.modelId, ANALYZER_FIELD.getPreferredName(), this.analyzer, "neural_query_enricher"));
        }
        if (this.analyzer != null) {
            return true;
        }
        if (this.modelId == null && NeuralSparseQueryBuilder.isClusterOnOrAfterMinReqVersionForAnalyzer()) {
            this.analyzer = DEFAULT_ANALYZER;
            return true;
        }
        return false;
    }

    private BiConsumer<Client, ActionListener<?>> getModelInferenceAsync(SetOnce<Map<String, Float>> setOnce) {
        return (client, actionListener) -> ML_CLIENT.inferenceSentencesWithMapResult((TextInferenceRequest)((TextInferenceRequest.TextInferenceRequestBuilder)((TextInferenceRequest.TextInferenceRequestBuilder)TextInferenceRequest.builder().modelId(this.modelId())).inputTexts(List.of(this.queryText))).build(), ActionListener.wrap(mapResultList -> {
            Map<String, Float> queryTokens = TokenWeightUtil.fetchListOfTokenWeightMap(mapResultList).get(0);
            if (Objects.nonNull(this.neuralSparseQueryTwoPhaseInfo) && NeuralSparseQueryTwoPhaseInfo.TwoPhaseStatus.PHASE_ONE.equals((Object)this.neuralSparseQueryTwoPhaseInfo.getStatus())) {
                Tuple<Map<String, Float>, Map<String, Float>> splitQueryTokens = PruneUtils.splitSparseVector(this.neuralSparseQueryTwoPhaseInfo.getTwoPhasePruneType(), this.neuralSparseQueryTwoPhaseInfo.getTwoPhasePruneRatio(), queryTokens);
                setOnce.set((Object)((Map)splitQueryTokens.v1()));
                this.twoPhaseSharedQueryToken = (Map)splitQueryTokens.v2();
            } else {
                setOnce.set(queryTokens);
            }
            actionListener.onResponse(null);
        }, arg_0 -> ((ActionListener)actionListener).onFailure(arg_0)));
    }

    Map<String, Float> getQueryTokens(QueryShardContext context) {
        if (Objects.nonNull(this.queryTokensSupplier) && Objects.nonNull(this.queryTokensSupplier.get())) {
            return this.queryTokensSupplier.get();
        }
        if (this.shouldUseAnalyzer()) {
            HashMap<String, Float> hashMap;
            block17: {
                HashMap<String, Float> queryTokens = new HashMap<String, Float>();
                Analyzer luceneAnalyzer = (Analyzer)context.getIndexAnalyzers().getAnalyzers().get(this.analyzer);
                if (Objects.isNull(luceneAnalyzer)) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Analyzer [%s] not found in shard context. ", this.analyzer));
                }
                TokenStream stream = luceneAnalyzer.tokenStream(this.fieldName, this.queryText);
                try {
                    stream.reset();
                    CharTermAttribute term = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
                    PayloadAttribute payload = (PayloadAttribute)stream.addAttribute(PayloadAttribute.class);
                    while (stream.incrementToken()) {
                        String token = term.toString();
                        float f = Objects.isNull(payload.getPayload()) ? 1.0f : NeuralSparseQueryBuilder.bytesToFloat(payload.getPayload().bytes);
                        float weight = f;
                        if (!(weight > 0.0f)) continue;
                        queryTokens.put(token, Float.valueOf(weight));
                    }
                    stream.end();
                    switch (this.neuralSparseQueryTwoPhaseInfo.getStatus()) {
                        case PHASE_TWO: {
                            Map<String, Float> map = (Map)PruneUtils.splitSparseVector(this.neuralSparseQueryTwoPhaseInfo.getTwoPhasePruneType(), this.neuralSparseQueryTwoPhaseInfo.getTwoPhasePruneRatio(), queryTokens).v2();
                            break;
                        }
                        case PHASE_ONE: {
                            Map<String, Float> map = (Map)PruneUtils.splitSparseVector(this.neuralSparseQueryTwoPhaseInfo.getTwoPhasePruneType(), this.neuralSparseQueryTwoPhaseInfo.getTwoPhasePruneRatio(), queryTokens).v1();
                            break;
                        }
                        default: {
                            Map<String, Float> map = hashMap = queryTokens;
                        }
                    }
                    if (stream == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new OpenSearchException("failed to analyze query text. ", (Throwable)e, new Object[0]);
                    }
                    catch (BufferUnderflowException e) {
                        throw new OpenSearchException("failed to parse query token weight from analyzer. ", (Throwable)e, new Object[0]);
                    }
                }
                stream.close();
            }
            return hashMap;
        }
        throw new IllegalArgumentException("Cannot convert neural sparse query to Lucene query: query tokens must not be null.");
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        MappedFieldType ft = context.fieldMapper(this.fieldName);
        NeuralSparseQueryBuilder.validateFieldType(ft);
        Map<String, Float> queryTokens = this.getQueryTokens(context);
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (Map.Entry<String, Float> entry : queryTokens.entrySet()) {
            builder.add(FeatureField.newLinearQuery((String)this.fieldName, (String)entry.getKey(), (float)entry.getValue().floatValue()), BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    private static void validateForRewrite(String queryText, String modelId) {
        if (StringUtils.isBlank((String)queryText) || StringUtils.isBlank((String)modelId)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s and %s cannot be null", QUERY_TEXT_FIELD.getPreferredName(), MODEL_ID_FIELD.getPreferredName()));
        }
    }

    private static void validateFieldType(MappedFieldType fieldType) {
        if (Objects.isNull(fieldType) || !fieldType.typeName().equals("rank_features")) {
            throw new IllegalArgumentException("[neural_sparse] query only works on [rank_features] fields");
        }
    }

    protected boolean doEquals(NeuralSparseQueryBuilder obj) {
        if (this == obj) {
            return true;
        }
        if (Objects.isNull(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        if (Objects.isNull(this.queryTokensSupplier) && Objects.nonNull(obj.queryTokensSupplier)) {
            return false;
        }
        if (Objects.nonNull(this.queryTokensSupplier) && Objects.isNull(obj.queryTokensSupplier)) {
            return false;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder().append((Object)this.fieldName, (Object)obj.fieldName).append((Object)this.queryText, (Object)obj.queryText).append((Object)this.modelId, (Object)obj.modelId).append((Object)this.maxTokenScore, (Object)obj.maxTokenScore).append((Object)this.neuralSparseQueryTwoPhaseInfo.getTwoPhasePruneType(), (Object)obj.neuralSparseQueryTwoPhaseInfo.getTwoPhasePruneType()).append(this.neuralSparseQueryTwoPhaseInfo.getTwoPhasePruneRatio(), obj.neuralSparseQueryTwoPhaseInfo.getTwoPhasePruneRatio()).append(this.neuralSparseQueryTwoPhaseInfo.getStatus().getValue(), obj.neuralSparseQueryTwoPhaseInfo.getStatus().getValue()).append(this.twoPhaseSharedQueryToken, obj.twoPhaseSharedQueryToken).append((Object)this.analyzer, (Object)obj.analyzer);
        if (Objects.nonNull(this.queryTokensSupplier)) {
            equalsBuilder.append(this.queryTokensSupplier.get(), obj.queryTokensSupplier.get());
        }
        return equalsBuilder.isEquals();
    }

    protected int doHashCode() {
        HashCodeBuilder builder = new HashCodeBuilder().append((Object)this.fieldName).append((Object)this.queryText).append((Object)this.modelId).append((Object)this.maxTokenScore).append((Object)this.neuralSparseQueryTwoPhaseInfo.getTwoPhasePruneType()).append(this.neuralSparseQueryTwoPhaseInfo.getTwoPhasePruneRatio()).append(this.neuralSparseQueryTwoPhaseInfo.getStatus().getValue()).append(this.twoPhaseSharedQueryToken).append((Object)this.analyzer);
        if (Objects.nonNull(this.queryTokensSupplier)) {
            builder.append(this.queryTokensSupplier.get());
        }
        return builder.toHashCode();
    }

    public String getWriteableName() {
        return NAME;
    }

    private static boolean isClusterOnOrAfterMinReqVersionForDefaultModelIdSupport() {
        return NeuralSearchClusterUtil.instance().getClusterMinVersion().onOrAfter(MINIMAL_SUPPORTED_VERSION_DEFAULT_MODEL_ID);
    }

    private static boolean isClusterOnOrAfterMinReqVersionForAnalyzer() {
        return NeuralSearchClusterUtil.instance().getClusterMinVersion().onOrAfter(MINIMAL_SUPPORTED_VERSION_ANALYZER);
    }

    private boolean shouldUseModelId() {
        return StringUtils.isNotEmpty((String)this.modelId);
    }

    public static float bytesToFloat(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getFloat();
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    @Generated
    public String queryText() {
        return this.queryText;
    }

    @Override
    @Generated
    public String modelId() {
        return this.modelId;
    }

    @Generated
    public String analyzer() {
        return this.analyzer;
    }

    @Generated
    public Float maxTokenScore() {
        return this.maxTokenScore;
    }

    @Generated
    public Supplier<Map<String, Float>> queryTokensSupplier() {
        return this.queryTokensSupplier;
    }

    @Generated
    public Map<String, Float> twoPhaseSharedQueryToken() {
        return this.twoPhaseSharedQueryToken;
    }

    @Generated
    public NeuralSparseQueryTwoPhaseInfo neuralSparseQueryTwoPhaseInfo() {
        return this.neuralSparseQueryTwoPhaseInfo;
    }

    @Generated
    public NeuralSparseQueryBuilder fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @Generated
    public NeuralSparseQueryBuilder queryText(String queryText) {
        this.queryText = queryText;
        return this;
    }

    @Override
    @Generated
    public NeuralSparseQueryBuilder modelId(String modelId) {
        this.modelId = modelId;
        return this;
    }

    @Generated
    public NeuralSparseQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    @Generated
    public NeuralSparseQueryBuilder maxTokenScore(Float maxTokenScore) {
        this.maxTokenScore = maxTokenScore;
        return this;
    }

    @Generated
    public NeuralSparseQueryBuilder queryTokensSupplier(Supplier<Map<String, Float>> queryTokensSupplier) {
        this.queryTokensSupplier = queryTokensSupplier;
        return this;
    }

    @Generated
    public NeuralSparseQueryBuilder twoPhaseSharedQueryToken(Map<String, Float> twoPhaseSharedQueryToken) {
        this.twoPhaseSharedQueryToken = twoPhaseSharedQueryToken;
        return this;
    }

    @Generated
    public NeuralSparseQueryBuilder neuralSparseQueryTwoPhaseInfo(NeuralSparseQueryTwoPhaseInfo neuralSparseQueryTwoPhaseInfo) {
        this.neuralSparseQueryTwoPhaseInfo = neuralSparseQueryTwoPhaseInfo;
        return this;
    }

    @Generated
    public NeuralSparseQueryBuilder() {
    }

    @Generated
    public NeuralSparseQueryBuilder(String fieldName, String queryText, String modelId, String analyzer, Float maxTokenScore, Supplier<Map<String, Float>> queryTokensSupplier, Map<String, Float> twoPhaseSharedQueryToken, NeuralSparseQueryTwoPhaseInfo neuralSparseQueryTwoPhaseInfo) {
        this.fieldName = fieldName;
        this.queryText = queryText;
        this.modelId = modelId;
        this.analyzer = analyzer;
        this.maxTokenScore = maxTokenScore;
        this.queryTokensSupplier = queryTokensSupplier;
        this.twoPhaseSharedQueryToken = twoPhaseSharedQueryToken;
        this.neuralSparseQueryTwoPhaseInfo = neuralSparseQueryTwoPhaseInfo;
    }

    static {
        MINIMAL_SUPPORTED_VERSION_DEFAULT_MODEL_ID = Version.V_2_13_0;
        MINIMAL_SUPPORTED_VERSION_ANALYZER = Version.V_3_0_0;
    }
}

