/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.store;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.store.IndexOutput;

public class IndexOutputWithBuffer {
    private IndexOutput indexOutput;
    private static final int CHUNK_SIZE = 65536;
    private final byte[] buffer;

    public IndexOutputWithBuffer(IndexOutput indexOutput) {
        this.indexOutput = indexOutput;
        this.buffer = new byte[65536];
    }

    public void writeBytes(int length) {
        try {
            this.indexOutput.writeBytes(this.buffer, 0, length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeFromStreamWithBuffer(InputStream inputStream, int size) throws IOException {
        byte[] streamBuffer = new byte[size];
        this.writeFromStreamWithBuffer(inputStream, streamBuffer);
    }

    private void writeFromStreamWithBuffer(InputStream inputStream, byte[] outputBuffer) throws IOException {
        int bytesRead = 0;
        while (bytesRead != -1) {
            bytesRead = inputStream.read(outputBuffer, 0, outputBuffer.length);
            assert (bytesRead <= outputBuffer.length);
            if (bytesRead == -1) continue;
            this.indexOutput.writeBytes(outputBuffer, 0, bytesRead);
        }
    }

    public String toString() {
        return "{indexOutput=" + String.valueOf(this.indexOutput) + ", len(buffer)=" + this.buffer.length + "}";
    }
}

