/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.nativeindex.remote;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.codec.util.KNNCodecUtil;
import org.opensearch.knn.index.vectorvalues.KNNBinaryVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNByteVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNFloatVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;

class VectorValuesInputStream
extends InputStream {
    @Generated
    private static final Logger log = LogManager.getLogger(VectorValuesInputStream.class);
    private final KNNVectorValues<?> knnVectorValues;
    private ByteBuffer currentBuffer;
    private final int bytesPerVector;
    private long bytesRemaining;
    private final VectorDataType vectorDataType;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public VectorValuesInputStream(KNNVectorValues<?> knnVectorValues, VectorDataType vectorDataType, long startPosition, long size) throws IOException {
        this.bytesRemaining = size;
        this.knnVectorValues = knnVectorValues;
        this.vectorDataType = vectorDataType;
        KNNCodecUtil.initializeVectorValues(this.knnVectorValues);
        this.bytesPerVector = this.knnVectorValues.bytesPerVector();
        this.currentBuffer = ByteBuffer.allocate(this.bytesPerVector).order(ByteOrder.LITTLE_ENDIAN);
        this.setPosition(startPosition);
    }

    public VectorValuesInputStream(KNNVectorValues<?> knnVectorValues, VectorDataType vectorDataType) throws IOException {
        this(knnVectorValues, vectorDataType, 0L, Long.MAX_VALUE);
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.bytesRemaining <= 0L || this.currentBuffer == null) {
            return -1;
        }
        if (!this.currentBuffer.hasRemaining()) {
            this.advanceAndReloadBuffer();
            if (this.currentBuffer == null) {
                return -1;
            }
        }
        --this.bytesRemaining;
        return this.currentBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        if (this.bytesRemaining <= 0L || this.currentBuffer == null) {
            return -1;
        }
        int available = this.currentBuffer.remaining();
        if (available <= 0) {
            this.advanceAndReloadBuffer();
            if (this.currentBuffer == null) {
                return -1;
            }
            available = this.currentBuffer.remaining();
        }
        int bytesToRead = Math.min(available, len);
        int bytesActuallyRead = (int)Math.min(this.bytesRemaining, (long)bytesToRead);
        this.currentBuffer.get(b, off, bytesActuallyRead);
        this.bytesRemaining -= (long)bytesActuallyRead;
        return bytesActuallyRead;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkClosed();
        throw new UnsupportedOperationException("VectorValuesInputStream does not support skip");
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.currentBuffer = null;
        this.closed.set(true);
    }

    private void checkClosed() throws IOException {
        if (this.closed.get()) {
            throw new IOException("Stream closed");
        }
    }

    private void setPosition(long n) throws IOException {
        int vectorsToSkip;
        if (this.currentBuffer.position() != 0) {
            throw new UnsupportedOperationException("setPosition is only supported from the start of a vector");
        }
        long bytesSkipped = 0L;
        log.debug("Skipping {} bytes, {} vectors", (Object)n, (Object)vectorsToSkip);
        int docId = this.knnVectorValues.docId();
        for (vectorsToSkip = (int)(n / (long)this.bytesPerVector); docId != -1 && docId != Integer.MAX_VALUE && vectorsToSkip > 0; --vectorsToSkip) {
            docId = this.knnVectorValues.nextDoc();
            bytesSkipped += (long)this.bytesPerVector;
        }
        this.reloadBuffer();
        long remainingBytes = n - bytesSkipped;
        if (remainingBytes > 0L) {
            this.currentBuffer.position((int)remainingBytes);
        }
    }

    private void reloadBuffer() throws IOException {
        this.currentBuffer.clear();
        if (this.vectorDataType == VectorDataType.FLOAT) {
            float[] floatVector = ((KNNFloatVectorValues)this.knnVectorValues).getVector();
            this.currentBuffer.asFloatBuffer().put(floatVector);
        } else if (this.vectorDataType == VectorDataType.BYTE) {
            byte[] byteVector = ((KNNByteVectorValues)this.knnVectorValues).getVector();
            this.currentBuffer.put(byteVector);
        } else if (this.vectorDataType == VectorDataType.BINARY) {
            byte[] binaryVector = ((KNNBinaryVectorValues)this.knnVectorValues).getVector();
            this.currentBuffer.put(binaryVector);
        } else {
            throw new IllegalArgumentException("Unsupported vector data type: " + String.valueOf((Object)this.vectorDataType));
        }
        this.currentBuffer.position(0);
    }

    private void advanceAndReloadBuffer() throws IOException {
        int docId = this.knnVectorValues.nextDoc();
        if (docId != -1 && docId != Integer.MAX_VALUE) {
            this.reloadBuffer();
        } else {
            this.currentBuffer = null;
        }
    }
}

