/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.bulk.BackoffPolicy;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.alerting.core.JobSweeperMetrics;
import org.opensearch.alerting.core.ShardNodes;
import org.opensearch.alerting.core.schedule.JobScheduler;
import org.opensearch.alerting.core.settings.ScheduledJobSettings;
import org.opensearch.alerting.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.cluster.ClusterChangedEvent;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateListener;
import org.opensearch.cluster.routing.IndexShardRoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.lifecycle.LifecycleListener;
import org.opensearch.common.logging.Loggers;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.engine.Engine;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.shard.IndexingOperationListener;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.sort.FieldSortBuilder;
import org.opensearch.search.sort.SortBuilder;
import org.opensearch.threadpool.Scheduler;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BC\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0002\u0010\u0013J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000200H\u0016J\b\u00102\u001a\u000200H\u0016J\u0010\u00103\u001a\u0002002\u0006\u00104\u001a\u000205H\u0016J\u0006\u00106\u001a\u000200J\u0006\u00107\u001a\u000200J\b\u00108\u001a\u00020\u001cH\u0002J\u0006\u00109\u001a\u00020:J\b\u0010;\u001a\u000200H\u0002J\u001c\u0010<\u001a\u00020(2\u0006\u0010=\u001a\u00020,2\n\u0010>\u001a\u00060\u0012j\u0002`-H\u0002J\u0010\u0010?\u001a\u00020(2\u0006\u0010@\u001a\u00020AH\u0002J\u0006\u0010B\u001a\u00020(JD\u0010C\u001a\u0004\u0018\u00010D2\u0006\u0010@\u001a\u00020A2\u0006\u0010=\u001a\u00020,2\n\u0010>\u001a\u00060\u0012j\u0002`-2\n\u0010E\u001a\u00060\u0018j\u0002`.2\u0006\u0010F\u001a\u00020G2\b\b\u0002\u0010H\u001a\u00020(H\u0002J0\u0010I\u001a\u00020D2\u0006\u0010@\u001a\u00020A2\n\u0010>\u001a\u00060\u0012j\u0002`-2\n\u0010E\u001a\u00060\u0018j\u0002`.2\u0006\u0010H\u001a\u00020(H\u0002J \u0010J\u001a\u0002002\u0006\u0010=\u001a\u00020,2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NH\u0016J \u0010O\u001a\u0002002\u0006\u0010=\u001a\u00020,2\u0006\u0010P\u001a\u00020Q2\u0006\u0010M\u001a\u00020RH\u0016J<\u0010S\u001a\u0002002\u0006\u0010=\u001a\u00020,2\n\u0010>\u001a\u00060\u0012j\u0002`-2\n\u0010T\u001a\u00060\u0018j\u0002`.2\b\u0010U\u001a\u0004\u0018\u00010D2\b\b\u0002\u0010V\u001a\u00020(H\u0002J\b\u0010W\u001a\u000200H\u0002J\"\u0010X\u001a\u0002002\u0006\u0010=\u001a\u00020,2\u0006\u0010Y\u001a\u00020Z2\b\b\u0002\u0010[\u001a\u00020\u0012H\u0002J;\u0010\\\u001a\u00020(2\n\u0010T\u001a\u00060\u0018j\u0002`.2\u000e\u0010]\u001a\n\u0018\u00010\u0018j\u0004\u0018\u0001`.2\u0006\u0010^\u001a\u00020(2\b\u0010U\u001a\u0004\u0018\u00010DH\u0002\u00a2\u0006\u0002\u0010_R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \u0016*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u0016*\u0004\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\n \u0016*\u0004\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010 \u001a\n \u0016*\u0004\u0018\u00010!0!X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R\u0018\u0010#\u001a\n \u0016*\u0004\u0018\u00010!0!X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\"R\u0016\u0010$\u001a\n \u0016*\u0004\u0018\u00010\u001c0\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\n \u0016*\u0004\u0018\u00010&0&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010'\u001a\n \u0016*\u0004\u0018\u00010(0(X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010)R.\u0010*\u001a\"\u0012\u0004\u0012\u00020,\u0012\u0018\u0012\u0016\u0012\b\u0012\u00060\u0012j\u0002`-\u0012\b\u0012\u00060\u0018j\u0002`.0+0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lorg/opensearch/alerting/core/JobSweeper;", "Lorg/opensearch/cluster/ClusterStateListener;", "Lorg/opensearch/index/shard/IndexingOperationListener;", "Lorg/opensearch/common/lifecycle/LifecycleListener;", "settings", "Lorg/opensearch/common/settings/Settings;", "client", "Lorg/opensearch/transport/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "threadPool", "Lorg/opensearch/threadpool/ThreadPool;", "xContentRegistry", "Lorg/opensearch/core/xcontent/NamedXContentRegistry;", "scheduler", "Lorg/opensearch/alerting/core/schedule/JobScheduler;", "sweepableJobTypes", "", "", "(Lorg/opensearch/common/settings/Settings;Lorg/opensearch/transport/client/Client;Lorg/opensearch/cluster/service/ClusterService;Lorg/opensearch/threadpool/ThreadPool;Lorg/opensearch/core/xcontent/NamedXContentRegistry;Lorg/opensearch/alerting/core/schedule/JobScheduler;Ljava/util/List;)V", "fullSweepExecutor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "lastFullSweepTimeNano", "", "logger", "Lorg/apache/logging/log4j/Logger;", "requestTimeout", "Lorg/opensearch/common/unit/TimeValue;", "scheduledFullSweep", "Lorg/opensearch/threadpool/Scheduler$Cancellable;", "sweepBackoffMillis", "sweepBackoffRetryCount", "", "Ljava/lang/Integer;", "sweepPageSize", "sweepPeriod", "sweepSearchBackoff", "Lorg/opensearch/action/bulk/BackoffPolicy;", "sweeperEnabled", "", "Ljava/lang/Boolean;", "sweptJobs", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/opensearch/core/index/shard/ShardId;", "Lorg/opensearch/alerting/core/JobId;", "Lorg/opensearch/alerting/core/JobVersion;", "afterStart", "", "beforeClose", "beforeStop", "clusterChanged", "event", "Lorg/opensearch/cluster/ClusterChangedEvent;", "disable", "enable", "getFullSweepElapsedTime", "getJobSweeperMetrics", "Lorg/opensearch/alerting/core/JobSweeperMetrics;", "initBackgroundSweep", "isOwningNode", "shardId", "jobId", "isSweepableJobType", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "isSweepingEnabled", "parseAndSweepJob", "Lorg/opensearch/commons/alerting/model/ScheduledJob;", "jobVersion", "jobSource", "Lorg/opensearch/core/common/bytes/BytesReference;", "typeIsParsed", "parseScheduledJob", "postDelete", "delete", "Lorg/opensearch/index/engine/Engine$Delete;", "result", "Lorg/opensearch/index/engine/Engine$DeleteResult;", "postIndex", "index", "Lorg/opensearch/index/engine/Engine$Index;", "Lorg/opensearch/index/engine/Engine$IndexResult;", "sweep", "newVersion", "job", "failedToParse", "sweepAllShards", "sweepShard", "shardNodes", "Lorg/opensearch/alerting/core/ShardNodes;", "startAfter", "unchangedJobToBeRescheduled", "currentVersion", "jobCurrentlyScheduled", "(JLjava/lang/Long;ZLorg/opensearch/commons/alerting/model/ScheduledJob;)Z", "alerting-core"})
@SourceDebugExtension(value={"SMAP\nJobSweeper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JobSweeper.kt\norg/opensearch/alerting/core/JobSweeper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,506:1\n766#2:507\n857#2,2:508\n1477#2:510\n1502#2,3:511\n1505#2,3:521\n1747#2,3:527\n1855#2,2:534\n1549#2:537\n1620#2,3:538\n819#2:545\n847#2,2:546\n1855#2,2:548\n1855#2,2:550\n766#2:555\n857#2,2:556\n1549#2:558\n1620#2,3:559\n372#3,7:514\n526#3:524\n511#3,2:525\n513#3,4:530\n215#4:536\n216#4:541\n72#5,2:542\n72#5,2:552\n1#6:544\n1#6:554\n*S KotlinDebug\n*F\n+ 1 JobSweeper.kt\norg/opensearch/alerting/core/JobSweeper\n*L\n273#1:507\n273#1:508,2\n275#1:510\n275#1:511,3\n275#1:521,3\n277#1:527,3\n281#1:534,2\n289#1:537\n289#1:538,3\n304#1:545\n304#1:546,2\n304#1:548,2\n314#1:550,2\n466#1:555\n466#1:556,2\n467#1:558\n467#1:559,3\n275#1:514,7\n277#1:524\n277#1:525,2\n277#1:530,4\n287#1:536\n287#1:541\n303#1:542,2\n358#1:552,2\n303#1:544\n358#1:554\n*E\n"})
public final class JobSweeper
extends LifecycleListener
implements ClusterStateListener,
IndexingOperationListener {
    @NotNull
    private final Settings settings;
    @NotNull
    private final Client client;
    @NotNull
    private final ClusterService clusterService;
    @NotNull
    private final ThreadPool threadPool;
    @NotNull
    private final NamedXContentRegistry xContentRegistry;
    @NotNull
    private final JobScheduler scheduler;
    @NotNull
    private final List<String> sweepableJobTypes;
    private final Logger logger;
    private final ExecutorService fullSweepExecutor;
    @NotNull
    private final ConcurrentHashMap<ShardId, ConcurrentHashMap<String, Long>> sweptJobs;
    @Nullable
    private Scheduler.Cancellable scheduledFullSweep;
    private volatile long lastFullSweepTimeNano;
    private volatile TimeValue requestTimeout;
    private volatile TimeValue sweepPeriod;
    private volatile Boolean sweeperEnabled;
    private volatile Integer sweepPageSize;
    private volatile TimeValue sweepBackoffMillis;
    private volatile Integer sweepBackoffRetryCount;
    private volatile BackoffPolicy sweepSearchBackoff;

    public JobSweeper(@NotNull Settings settings, @NotNull Client client, @NotNull ClusterService clusterService, @NotNull ThreadPool threadPool, @NotNull NamedXContentRegistry xContentRegistry, @NotNull JobScheduler scheduler, @NotNull List<String> sweepableJobTypes) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        Intrinsics.checkNotNullParameter((Object)threadPool, (String)"threadPool");
        Intrinsics.checkNotNullParameter((Object)xContentRegistry, (String)"xContentRegistry");
        Intrinsics.checkNotNullParameter((Object)scheduler, (String)"scheduler");
        Intrinsics.checkNotNullParameter(sweepableJobTypes, (String)"sweepableJobTypes");
        this.settings = settings;
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.xContentRegistry = xContentRegistry;
        this.scheduler = scheduler;
        this.sweepableJobTypes = sweepableJobTypes;
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.fullSweepExecutor = Executors.newSingleThreadExecutor(OpenSearchExecutors.daemonThreadFactory((String)"opendistro_job_sweeper"));
        this.sweptJobs = new ConcurrentHashMap();
        this.lastFullSweepTimeNano = System.nanoTime();
        this.requestTimeout = (TimeValue)ScheduledJobSettings.Companion.getREQUEST_TIMEOUT().get(this.settings);
        this.sweepPeriod = (TimeValue)ScheduledJobSettings.Companion.getSWEEP_PERIOD().get(this.settings);
        this.sweeperEnabled = (Boolean)ScheduledJobSettings.Companion.getSWEEPER_ENABLED().get(this.settings);
        this.sweepPageSize = (Integer)ScheduledJobSettings.Companion.getSWEEP_PAGE_SIZE().get(this.settings);
        this.sweepBackoffMillis = (TimeValue)ScheduledJobSettings.Companion.getSWEEP_BACKOFF_MILLIS().get(this.settings);
        Integer n = this.sweepBackoffRetryCount = (Integer)ScheduledJobSettings.Companion.getSWEEP_BACKOFF_RETRY_COUNT().get(this.settings);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"sweepBackoffRetryCount");
        this.sweepSearchBackoff = BackoffPolicy.exponentialBackoff((TimeValue)this.sweepBackoffMillis, (int)((Number)n).intValue());
        this.clusterService.addListener((ClusterStateListener)this);
        this.clusterService.addLifecycleListener((LifecycleListener)this);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ScheduledJobSettings.Companion.getSWEEP_PERIOD(), arg_0 -> JobSweeper._init_$lambda$0(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ScheduledJobSettings.Companion.getSWEEPER_ENABLED(), arg_0 -> JobSweeper._init_$lambda$1(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ScheduledJobSettings.Companion.getSWEEP_BACKOFF_MILLIS(), arg_0 -> JobSweeper._init_$lambda$2(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ScheduledJobSettings.Companion.getSWEEP_BACKOFF_RETRY_COUNT(), arg_0 -> JobSweeper._init_$lambda$3(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ScheduledJobSettings.Companion.getSWEEP_PAGE_SIZE(), arg_0 -> JobSweeper._init_$lambda$4(this, arg_0));
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(ScheduledJobSettings.Companion.getREQUEST_TIMEOUT(), arg_0 -> JobSweeper._init_$lambda$5(this, arg_0));
    }

    public void afterStart() {
        this.initBackgroundSweep();
    }

    public void beforeStop() {
        block0: {
            Scheduler.Cancellable cancellable = this.scheduledFullSweep;
            if (cancellable == null) break block0;
            cancellable.cancel();
        }
    }

    public void beforeClose() {
        this.fullSweepExecutor.shutdown();
    }

    public void clusterChanged(@NotNull ClusterChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isSweepingEnabled()) {
            return;
        }
        if (!event.indexRoutingTableChanged(".opendistro-alerting-config")) {
            return;
        }
        this.logger.debug("Scheduled Jobs routing table changed. Running full sweep...");
        this.fullSweepExecutor.submit(() -> JobSweeper.clusterChanged$lambda$6(this));
    }

    public void postIndex(@NotNull ShardId shardId, @NotNull Engine.Index index, @NotNull Engine.IndexResult result) {
        Intrinsics.checkNotNullParameter((Object)shardId, (String)"shardId");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (!this.isSweepingEnabled()) {
            return;
        }
        if (result.getResultType() != Engine.Result.Type.SUCCESS) {
            ConcurrentHashMap<String, Long> concurrentHashMap = this.sweptJobs.get(shardId);
            Map shardJobs = concurrentHashMap == null ? MapsKt.emptyMap() : (Map)concurrentHashMap;
            Long l = (Long)shardJobs.get(index.id());
            long currentVersion = l != null ? l : -1L;
            this.logger.debug("Indexing failed for ScheduledJob: " + index.id() + ". Continuing with current version " + currentVersion);
            return;
        }
        String string = index.id();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id(...)");
        if (this.isOwningNode(shardId, string)) {
            XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)this.xContentRegistry, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)index.source(), (MediaType)((MediaType)XContentType.JSON));
            Intrinsics.checkNotNull((Object)xcp);
            if (this.isSweepableJobType(xcp)) {
                String string2 = index.id();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id(...)");
                long l = result.getVersion();
                BytesReference bytesReference = index.source();
                Intrinsics.checkNotNullExpressionValue((Object)bytesReference, (String)"source(...)");
                ScheduledJob job = this.parseAndSweepJob(xcp, shardId, string2, l, bytesReference, true);
                if (job != null) {
                    this.scheduler.postIndex(job);
                }
            } else {
                this.logger.debug("Not a valid job type in document " + index.id() + " to sweep.");
            }
        }
    }

    public void postDelete(@NotNull ShardId shardId, @NotNull Engine.Delete delete, @NotNull Engine.DeleteResult result) {
        Intrinsics.checkNotNullParameter((Object)shardId, (String)"shardId");
        Intrinsics.checkNotNullParameter((Object)delete, (String)"delete");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (!this.isSweepingEnabled()) {
            return;
        }
        if (result.getResultType() != Engine.Result.Type.SUCCESS) {
            ConcurrentHashMap<String, Long> concurrentHashMap = this.sweptJobs.get(shardId);
            Map shardJobs = concurrentHashMap == null ? MapsKt.emptyMap() : (Map)concurrentHashMap;
            Long l = (Long)shardJobs.get(delete.id());
            long currentVersion = l != null ? l : -1L;
            this.logger.debug("Deletion failed for ScheduledJob: " + delete.id() + ". Continuing with current version " + currentVersion);
            return;
        }
        String string = delete.id();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id(...)");
        if (this.isOwningNode(shardId, string)) {
            if (this.scheduler.scheduledJobs().contains(delete.id())) {
                String string2 = delete.id();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id(...)");
                JobSweeper.sweep$default(this, shardId, string2, result.getVersion(), null, false, 16, null);
            }
            String string3 = delete.id();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"id(...)");
            this.scheduler.postDelete(string3);
        }
    }

    public final void enable() {
        this.initBackgroundSweep();
        this.sweeperEnabled = true;
    }

    public final void disable() {
        Scheduler.Cancellable cancellable = this.scheduledFullSweep;
        if (cancellable != null) {
            cancellable.cancel();
        }
        this.logger.info("Descheduling all jobs as sweeping is disabled");
        this.scheduler.deschedule((Collection<String>)this.scheduler.scheduledJobs());
        this.sweeperEnabled = false;
    }

    public final boolean isSweepingEnabled() {
        return Intrinsics.areEqual((Object)this.sweeperEnabled, (Object)true);
    }

    private final void initBackgroundSweep() {
        if (!this.isSweepingEnabled()) {
            return;
        }
        Scheduler.Cancellable cancellable = this.scheduledFullSweep;
        if (cancellable != null) {
            cancellable.cancel();
        }
        this.logger.debug("Performing sweep of scheduled jobs.");
        this.fullSweepExecutor.submit(() -> JobSweeper.initBackgroundSweep$lambda$7(this));
        Runnable scheduledSweep = () -> JobSweeper.initBackgroundSweep$lambda$9(this);
        this.scheduledFullSweep = this.threadPool.scheduleWithFixedDelay(scheduledSweep, this.sweepPeriod, "same");
    }

    /*
     * WARNING - void declaration
     */
    private final void sweepAllShards() {
        Iterable shards;
        ConcurrentHashMap<String, Long> list$iv$iv;
        Iterable $this$groupByTo$iv$iv;
        Object $this$groupBy$iv;
        boolean bl;
        ShardRouting it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        ClusterState clusterState = this.clusterService.state();
        if (!clusterState.getRoutingTable().hasIndex(".opendistro-alerting-config")) {
            this.scheduler.deschedule((Collection<String>)this.scheduler.scheduledJobs());
            this.sweptJobs.clear();
            this.lastFullSweepTimeNano = System.nanoTime();
            return;
        }
        String localNodeId = clusterState.getNodes().getLocalNodeId();
        List list = clusterState.getRoutingTable().allShards(".opendistro-alerting-config");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"allShards(...)");
        Iterable iterable = list;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean bl2 = false;
        for (Object t : $this$filterTo$iv$iv) {
            it = (ShardRouting)t;
            bl = false;
            if (!it.active()) continue;
            destination$iv$iv.add(t);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean bl3 = false;
        for (Object t : $this$groupByTo$iv$iv) {
            Object object;
            it = (ShardRouting)t;
            bl = false;
            ShardId key$iv$iv = it.shardId();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl22 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        $this$groupBy$iv = destination$iv$iv;
        $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean bl4 = false;
        for (Map.Entry entry : $this$filterTo$iv$iv.entrySet()) {
            boolean bl5;
            block16: {
                list$iv$iv = entry;
                boolean bl32 = false;
                shards = (List)list$iv$iv.getValue();
                Iterable $this$any$iv = shards;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl5 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ShardRouting it2 = (ShardRouting)element$iv;
                        boolean bl42 = false;
                        if (!Intrinsics.areEqual((Object)it2.currentNodeId(), (Object)localNodeId)) continue;
                        bl5 = true;
                        break block16;
                    }
                    bl5 = false;
                }
            }
            if (!bl5) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        Object localShards = destination$iv$iv;
        Set set = this.sweptJobs.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Set removedShards = SetsKt.minus((Set)set, (Iterable)localShards.keySet());
        Object $this$forEach$iv = removedShards;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Map map;
            Object t = iterator.next();
            ShardId shardId = (ShardId)t;
            boolean bl6 = false;
            ConcurrentHashMap<String, Long> concurrentHashMap = list$iv$iv = this.sweptJobs.remove(shardId);
            if (concurrentHashMap == null) {
                map = MapsKt.emptyMap();
            } else {
                Intrinsics.checkNotNull(concurrentHashMap);
                map = list$iv$iv;
            }
            Map shardJobs = map;
            this.scheduler.deschedule(shardJobs.keySet());
        }
        $this$forEach$iv = localShards;
        $i$f$forEach = false;
        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
            Map.Entry entry2 = entry;
            boolean bl7 = false;
            ShardId shardId = (ShardId)entry2.getKey();
            List shards2 = (List)entry2.getValue();
            try {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNull((Object)shardId);
                Intrinsics.checkNotNull((Object)localNodeId);
                shards = shards2;
                String string = localNodeId;
                ShardId shardId2 = shardId;
                JobSweeper jobSweeper = this;
                boolean $i$f$map = false;
                void var20_38 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    ShardRouting shardRouting = (ShardRouting)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl5 = false;
                    collection.add(it3.currentNodeId());
                }
                collection = (List)destination$iv$iv2;
                Collection collection2 = collection;
                String string2 = string;
                JobSweeper.sweepShard$default(jobSweeper, shardId2, new ShardNodes(string2, collection2), null, 4, null);
            }
            catch (Exception e) {
                Logger shardLogger = Loggers.getLogger(((Object)((Object)this)).getClass(), (ShardId)shardId, (String[])new String[0]);
                shardLogger.error("Error while sweeping shard " + shardId, (Throwable)e);
            }
        }
        this.lastFullSweepTimeNano = System.nanoTime();
    }

    /*
     * WARNING - void declaration
     */
    private final void sweepShard(ShardId shardId, ShardNodes shardNodes, String startAfter) {
        void $this$forEach$iv;
        Iterator $this$filterNotTo$iv$iv;
        Logger logger = Loggers.getLogger(((Object)((Object)this)).getClass(), (ShardId)shardId, (String[])new String[0]);
        logger.debug("Sweeping shard " + shardId);
        ConcurrentMap $this$getOrPut$iv = this.sweptJobs;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(shardId);
        if (object == null) {
            boolean bl = false;
            ConcurrentHashMap default$iv = new ConcurrentHashMap();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(shardId, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        ConcurrentHashMap currentJobs = (ConcurrentHashMap)object;
        Set set = currentJobs.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Iterable $this$filterNot$iv = set;
        boolean $i$f$filterNot = false;
        Iterable bl = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it);
            if (shardNodes.isOwningNode(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)it);
            this.scheduler.deschedule(it);
            currentJobs.remove(it);
        }
        String searchAfter = startAfter;
        while (searchAfter != null) {
            BoolQueryBuilder boolQueryBuilder = new BoolQueryBuilder();
            Iterable $this$forEach$iv2 = this.sweepableJobTypes;
            boolean $i$f$forEach22 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String it = (String)element$iv;
                boolean bl5 = false;
                boolQueryBuilder.should((QueryBuilder)QueryBuilders.existsQuery((String)it));
            }
            Object[] $i$f$forEach22 = new String[]{".opendistro-alerting-config"};
            SearchRequest searchRequest = new SearchRequest().indices((String[])$i$f$forEach22).preference("_shards:" + shardId.getId() + "|_only_local");
            $i$f$forEach22 = new String[]{searchAfter};
            SearchSourceBuilder searchSourceBuilder = SearchSourceBuilder.searchSource().version(Boolean.valueOf(true)).sort((SortBuilder)new FieldSortBuilder("_id").unmappedType("keyword").missing((Object)"_last")).searchAfter($i$f$forEach22);
            Integer n = this.sweepPageSize;
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"sweepPageSize");
            SearchRequest jobSearchRequest = searchRequest.source(searchSourceBuilder.size(((Number)n).intValue()).query((QueryBuilder)boolQueryBuilder));
            BackoffPolicy backoffPolicy = this.sweepSearchBackoff;
            Intrinsics.checkNotNullExpressionValue((Object)backoffPolicy, (String)"sweepSearchBackoff");
            SearchResponse response2 = (SearchResponse)OpenSearchExtensionsKt.retry(backoffPolicy, (Function0)new Function0<SearchResponse>(this, jobSearchRequest){
                final /* synthetic */ JobSweeper this$0;
                final /* synthetic */ SearchRequest $jobSearchRequest;
                {
                    this.this$0 = $receiver;
                    this.$jobSearchRequest = $jobSearchRequest;
                    super(0);
                }

                public final SearchResponse invoke() {
                    return (SearchResponse)JobSweeper.access$getClient$p(this.this$0).search(this.$jobSearchRequest).actionGet(JobSweeper.access$getRequestTimeout$p(this.this$0));
                }
            });
            if (response2.status() != RestStatus.OK) {
                String string = "Error sweeping shard " + shardId + ".";
                Intrinsics.checkNotNull((Object)response2);
                logger.error(string, (Object)OpenSearchExtensionsKt.firstFailureOrNull(response2));
                return;
            }
            for (SearchHit hit : response2.getHits()) {
                String string = hit.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                if (!shardNodes.isOwningNode(string)) continue;
                XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)this.xContentRegistry, (DeprecationHandler)((DeprecationHandler)LoggingDeprecationHandler.INSTANCE), (BytesReference)hit.getSourceRef(), (MediaType)((MediaType)XContentType.JSON));
                Intrinsics.checkNotNull((Object)xcp);
                String string2 = hit.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
                long l = hit.getVersion();
                BytesReference bytesReference = hit.getSourceRef();
                Intrinsics.checkNotNullExpressionValue((Object)bytesReference, (String)"getSourceRef(...)");
                JobSweeper.parseAndSweepJob$default(this, xcp, shardId, string2, l, bytesReference, false, 32, null);
            }
            SearchHits searchHits = response2.getHits();
            Intrinsics.checkNotNullExpressionValue((Object)searchHits, (String)"getHits(...)");
            SearchHit searchHit = (SearchHit)CollectionsKt.lastOrNull((Iterable)((Iterable)searchHits));
            searchAfter = searchHit != null ? searchHit.getId() : null;
        }
    }

    static /* synthetic */ void sweepShard$default(JobSweeper jobSweeper, ShardId shardId, ShardNodes shardNodes, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "";
        }
        jobSweeper.sweepShard(shardId, shardNodes, string);
    }

    private final void sweep(ShardId shardId, String jobId, long newVersion, ScheduledJob job, boolean failedToParse) {
        ConcurrentMap $this$getOrPut$iv = this.sweptJobs;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(shardId);
        if (object == null) {
            boolean bl = false;
            ConcurrentHashMap default$iv = new ConcurrentHashMap();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(shardId, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        ((ConcurrentHashMap)object).compute(jobId, (arg_0, arg_1) -> JobSweeper.sweep$lambda$22((Function2)new Function2<String, Long, Long>(this, jobId, newVersion, job, failedToParse){
            final /* synthetic */ JobSweeper this$0;
            final /* synthetic */ String $jobId;
            final /* synthetic */ long $newVersion;
            final /* synthetic */ ScheduledJob $job;
            final /* synthetic */ boolean $failedToParse;
            {
                this.this$0 = $receiver;
                this.$jobId = $jobId;
                this.$newVersion = $newVersion;
                this.$job = $job;
                this.$failedToParse = $failedToParse;
                super(2);
            }

            @Nullable
            public final Long invoke(@NotNull String string, @Nullable Long currentVersion) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                boolean jobCurrentlyScheduled = JobSweeper.access$getScheduler$p(this.this$0).scheduledJobs().contains(this.$jobId);
                Long l = currentVersion;
                if (l == null) {
                    l = -1L;
                }
                if (this.$newVersion <= ((Number)l).longValue()) {
                    if (JobSweeper.access$unchangedJobToBeRescheduled(this.this$0, this.$newVersion, currentVersion, jobCurrentlyScheduled, this.$job)) {
                        JobSweeper.access$getLogger$p(this.this$0).debug("Not skipping job " + this.$jobId + " since it is an unchanged job slated to be rescheduled");
                    } else {
                        JobSweeper.access$getLogger$p(this.this$0).debug("Skipping job " + this.$jobId + ", " + this.$newVersion + " <= " + currentVersion);
                        return currentVersion;
                    }
                }
                if (jobCurrentlyScheduled) {
                    JobSweeper.access$getScheduler$p(this.this$0).deschedule(this.$jobId);
                }
                if (this.$failedToParse) {
                    return currentVersion;
                }
                if (this.$job != null) {
                    if (this.$job.getEnabled()) {
                        JobSweeper.access$getScheduler$p(this.this$0).schedule(this.$job);
                    }
                    return this.$newVersion;
                }
                return null;
            }
        }, arg_0, arg_1));
    }

    static /* synthetic */ void sweep$default(JobSweeper jobSweeper, ShardId shardId, String string, long l, ScheduledJob scheduledJob, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        jobSweeper.sweep(shardId, string, l, scheduledJob, bl);
    }

    private final boolean unchangedJobToBeRescheduled(long newVersion, Long currentVersion, boolean jobCurrentlyScheduled, ScheduledJob job) {
        Long l = currentVersion;
        boolean versionWasUnchanged = newVersion == (l != null ? l : -1L);
        ScheduledJob scheduledJob = job;
        boolean jobEnabled = scheduledJob != null ? scheduledJob.getEnabled() : false;
        return versionWasUnchanged && !jobCurrentlyScheduled && jobEnabled;
    }

    private final ScheduledJob parseAndSweepJob(XContentParser xcp, ShardId shardId, String jobId, long jobVersion, BytesReference jobSource, boolean typeIsParsed) {
        ScheduledJob scheduledJob;
        try {
            ScheduledJob job = this.parseScheduledJob(xcp, jobId, jobVersion, typeIsParsed);
            JobSweeper.sweep$default(this, shardId, jobId, jobVersion, job, false, 16, null);
            scheduledJob = job;
        }
        catch (Exception e) {
            this.logger.warn("Unable to parse ScheduledJob source: {}", (Object)Strings.cleanTruncate((String)jobSource.utf8ToString(), (int)1000));
            this.sweep(shardId, jobId, jobVersion, null, true);
            scheduledJob = null;
        }
        return scheduledJob;
    }

    static /* synthetic */ ScheduledJob parseAndSweepJob$default(JobSweeper jobSweeper, XContentParser xContentParser, ShardId shardId, String string, long l, BytesReference bytesReference, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        return jobSweeper.parseAndSweepJob(xContentParser, shardId, string, l, bytesReference, bl);
    }

    private final ScheduledJob parseScheduledJob(XContentParser xcp, String jobId, long jobVersion, boolean typeIsParsed) {
        ScheduledJob scheduledJob;
        if (typeIsParsed) {
            String string = xcp.currentName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"currentName(...)");
            scheduledJob = ScheduledJob.Companion.parse(xcp, string, jobId, jobVersion);
        } else {
            scheduledJob = ScheduledJob.Companion.parse(xcp, jobId, jobVersion);
        }
        return scheduledJob;
    }

    private final TimeValue getFullSweepElapsedTime() {
        TimeValue timeValue = TimeValue.timeValueNanos((long)(System.nanoTime() - this.lastFullSweepTimeNano));
        Intrinsics.checkNotNullExpressionValue((Object)timeValue, (String)"timeValueNanos(...)");
        return timeValue;
    }

    @NotNull
    public final JobSweeperMetrics getJobSweeperMetrics() {
        if (!this.isSweepingEnabled()) {
            return new JobSweeperMetrics(-1L, true);
        }
        TimeValue elapsedTime = this.getFullSweepElapsedTime();
        return new JobSweeperMetrics(elapsedTime.getMillis(), elapsedTime.getMillis() <= this.sweepPeriod.getMillis());
    }

    private final boolean isSweepableJobType(XContentParser xcp) {
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        String jobType = xcp.currentName();
        return this.sweepableJobTypes.contains(jobType);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isOwningNode(ShardId shardId, String jobId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ShardRouting it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String localNodeId = this.clusterService.localNode().getId();
        IndexShardRoutingTable indexShardRoutingTable = this.clusterService.state().getRoutingTable().shardRoutingTable(shardId);
        Intrinsics.checkNotNullExpressionValue((Object)indexShardRoutingTable, (String)"shardRoutingTable(...)");
        Iterable iterable = (Iterable)indexShardRoutingTable;
        boolean $i$f$filter = false;
        void var7_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ShardRouting)element$iv$iv;
            boolean bl = false;
            if (!it.active()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (ShardRouting)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.currentNodeId());
        }
        List shardNodeIds = (List)destination$iv$iv;
        Intrinsics.checkNotNull((Object)localNodeId);
        ShardNodes shardNodes = new ShardNodes(localNodeId, shardNodeIds);
        return shardNodes.isOwningNode(jobId);
    }

    private static final void _init_$lambda$0(JobSweeper this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.logger.debug("Reinitializing background full sweep with period: " + this$0.sweepPeriod.minutes());
        this$0.sweepPeriod = it;
        this$0.initBackgroundSweep();
    }

    private static final void _init_$lambda$1(JobSweeper this$0, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.sweeperEnabled = it;
        if (!this$0.sweeperEnabled.booleanValue()) {
            this$0.disable();
        } else {
            this$0.enable();
        }
    }

    private static final void _init_$lambda$2(JobSweeper this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        TimeValue timeValue = this$0.sweepBackoffMillis = it;
        Integer n = this$0.sweepBackoffRetryCount;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"sweepBackoffRetryCount");
        this$0.sweepSearchBackoff = BackoffPolicy.exponentialBackoff((TimeValue)timeValue, (int)((Number)n).intValue());
    }

    private static final void _init_$lambda$3(JobSweeper this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.sweepBackoffRetryCount = it;
        TimeValue timeValue = this$0.sweepBackoffMillis;
        Integer n = this$0.sweepBackoffRetryCount;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"sweepBackoffRetryCount");
        this$0.sweepSearchBackoff = BackoffPolicy.exponentialBackoff((TimeValue)timeValue, (int)((Number)n).intValue());
    }

    private static final void _init_$lambda$4(JobSweeper this$0, Integer it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.sweepPageSize = it;
    }

    private static final void _init_$lambda$5(JobSweeper this$0, TimeValue it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.requestTimeout = it;
    }

    private static final void clusterChanged$lambda$6(JobSweeper this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.sweepAllShards();
    }

    private static final void initBackgroundSweep$lambda$7(JobSweeper this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.sweepAllShards();
    }

    private static final void initBackgroundSweep$lambda$9$lambda$8(JobSweeper this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.logger.debug("Performing background sweep of scheduled jobs.");
        this$0.sweepAllShards();
    }

    private static final void initBackgroundSweep$lambda$9(JobSweeper this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        TimeValue elapsedTime = this$0.getFullSweepElapsedTime();
        long delta = this$0.sweepPeriod.getMillis() - elapsedTime.getMillis();
        if (delta < 20L) {
            this$0.fullSweepExecutor.submit(() -> JobSweeper.initBackgroundSweep$lambda$9$lambda$8(this$0));
        }
    }

    private static final Long sweep$lambda$22(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Long)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Client access$getClient$p(JobSweeper $this) {
        return $this.client;
    }

    public static final /* synthetic */ TimeValue access$getRequestTimeout$p(JobSweeper $this) {
        return $this.requestTimeout;
    }

    public static final /* synthetic */ JobScheduler access$getScheduler$p(JobSweeper $this) {
        return $this.scheduler;
    }

    public static final /* synthetic */ boolean access$unchangedJobToBeRescheduled(JobSweeper $this, long newVersion, Long currentVersion, boolean jobCurrentlyScheduled, ScheduledJob job) {
        return $this.unchangedJobToBeRescheduled(newVersion, currentVersion, jobCurrentlyScheduled, job);
    }

    public static final /* synthetic */ Logger access$getLogger$p(JobSweeper $this) {
        return $this.logger;
    }
}

