/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.rule.action.UpdateRuleRequest;
import org.opensearch.rule.autotagging.Attribute;
import org.opensearch.rule.autotagging.FeatureType;
import org.opensearch.rule.autotagging.Rule;

@ExperimentalApi
public class RuleUtils {
    public static String computeRuleHash(String description, FeatureType featureType, Map<Attribute, Set<String>> attributeMap, String featureValue) {
        String combined = description + "|" + featureType.getName() + "|" + attributeMap.toString() + "|" + featureValue;
        UUID uuid = UUID.nameUUIDFromBytes(combined.getBytes(StandardCharsets.UTF_8));
        return uuid.toString();
    }

    public static Optional<String> getDuplicateRuleId(Rule rule, List<Rule> ruleList) {
        Map<Attribute, Set<String>> targetAttributeMap = rule.getAttributeMap();
        for (Rule currRule : ruleList) {
            String currRuleId = currRule.getId();
            if (currRuleId.equals(rule.getId())) continue;
            Map<Attribute, Set<String>> existingAttributeMap = currRule.getAttributeMap();
            if (rule.getFeatureType() != currRule.getFeatureType() || targetAttributeMap.size() != existingAttributeMap.size()) continue;
            boolean allAttributesIntersect = true;
            for (Attribute attribute : targetAttributeMap.keySet()) {
                Set<String> targetAttributeValues = targetAttributeMap.get(attribute);
                Set<String> existingAttributeValues = existingAttributeMap.get(attribute);
                if (existingAttributeValues != null && !Collections.disjoint(targetAttributeValues, existingAttributeValues)) continue;
                allAttributesIntersect = false;
                break;
            }
            if (!allAttributesIntersect) continue;
            return Optional.of(currRuleId);
        }
        return Optional.empty();
    }

    public static Rule composeUpdatedRule(Rule originalRule, UpdateRuleRequest request, FeatureType featureType) {
        String requestDescription = request.getDescription();
        Map<Attribute, Set<String>> requestMap = request.getAttributeMap();
        String requestLabel = request.getFeatureValue();
        return new Rule(originalRule.getId(), requestDescription == null ? originalRule.getDescription() : requestDescription, requestMap == null || requestMap.isEmpty() ? originalRule.getAttributeMap() : requestMap, featureType, requestLabel == null ? originalRule.getFeatureValue() : requestLabel, Instant.now().toString());
    }
}

