/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.netbeans.modules.websvc.jaxwsmodelapi.java.JavaParameter;

public class TypeUtil {
    public static String typeToString(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            if (paramType.getOwnerType() != null) {
                return null;
            }
            Type rawType = paramType.getRawType();
            if (!(rawType instanceof Class)) {
                return null;
            }
            Class rawClass = (Class)rawType;
            Type[] argTypes = paramType.getActualTypeArguments();
            if (argTypes == null || argTypes.length == 0) {
                return null;
            }
            StringBuffer arguments = new StringBuffer();
            for (int i = 0; i < argTypes.length; ++i) {
                String argument = TypeUtil.typeToString(argTypes[0]);
                if (argument == null) {
                    return null;
                }
                arguments.append(argument);
                if (i == argTypes.length - 1) continue;
                arguments.append(',');
            }
            return rawClass.getCanonicalName() + "<" + arguments.toString() + ">";
        }
        if (type instanceof GenericArrayType) {
            String component = TypeUtil.typeToString(((GenericArrayType)type).getGenericComponentType());
            if (component != null) {
                return component + "[]";
            }
        } else if (type instanceof Class) {
            return ((Class)type).getCanonicalName();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<URL> buildClasspath(File srcPath, boolean isJaxWS) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(System.getProperty("netbeans.user") + "/build.properties");){
            properties.load(fis);
        }
        if (srcPath != null) {
            urls.add(srcPath.toURI().toURL());
        }
        File toolsJar = new File(System.getProperty("java.home")).getParentFile();
        toolsJar = new File(toolsJar, "lib" + File.separator + "tools.jar");
        urls.add(toolsJar.toURI().toURL());
        String pathSeparator = System.getProperty("path.separator");
        String longCP = properties.getProperty("libs.jsf12-support.classpath");
        String libProperty = isJaxWS ? "libs.jaxws21.classpath" : "libs.jaxrpc16.classpath";
        longCP = properties.getProperty(libProperty) + pathSeparator + longCP;
        StringTokenizer st = new StringTokenizer(longCP, pathSeparator);
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            File nextFile = new File(next);
            urls.add(nextFile.toURI().toURL());
        }
        return urls;
    }

    public static String getParameterType(JavaParameter inParameter) {
        String parameterType = null;
        parameterType = inParameter.isHolder() ? inParameter.getHolderName() : inParameter.getType().getName();
        return parameterType;
    }
}

