/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.runjar;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.api.extexecution.base.ExplicitProcessParameters;
import org.netbeans.api.extexecution.startup.StartupExtender;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.execute.ActiveJ2SEPlatformProvider;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.runjar.MavenExecuteUtils;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class RunJarStartupArgs
implements LateBoundPrerequisitesChecker {
    public static final String USER_PROGRAM_ARGS_MARKER = "%args";

    private static String[] splitCommandLine(String line) {
        if (line == null) {
            return new String[0];
        }
        String l = line.trim();
        if (l.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String part : MavenExecuteUtils.propertySplitter(l, true)) {
            result.add(part);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public boolean checkRunConfig(RunConfig config, ExecutionContext con) {
        String cmdLine;
        List<String> appArgsValue;
        ArrayList<String> vmArgsValue;
        StartupExtender.StartMode mode;
        String actionName = config.getActionName();
        if ("run".equals(actionName) || "run.single.main".equals(actionName)) {
            mode = StartupExtender.StartMode.NORMAL;
        } else if ("debug".equals(actionName) || "debug.single.main".equals(actionName)) {
            mode = StartupExtender.StartMode.DEBUG;
        } else if ("profile".equals(actionName) || "profile.single".equals(actionName) || "profile.single.main".equals(actionName)) {
            mode = StartupExtender.StartMode.PROFILE;
        } else if ("profile.test.single".equals(actionName)) {
            mode = StartupExtender.StartMode.TEST_PROFILE;
        } else {
            return true;
        }
        boolean isTestScope = false;
        Map<? extends String, ? extends String> props = config.getProperties();
        boolean vmArgsPresent = props.containsKey("exec.vmArgs");
        boolean appArgsPresent = props.containsKey("exec.appArgs");
        boolean execArgsPresent = props.containsKey("exec.args");
        ArrayList fixedArgs = new ArrayList();
        if (execArgsPresent || vmArgsPresent || appArgsPresent) {
            InstanceContent ic = new InstanceContent();
            Project p = config.getProject();
            if (p != null) {
                ic.add((Object)p);
                ActiveJ2SEPlatformProvider pp = (ActiveJ2SEPlatformProvider)p.getLookup().lookup(ActiveJ2SEPlatformProvider.class);
                if (pp != null) {
                    ic.add((Object)pp.getJavaPlatform());
                }
            }
            for (StartupExtender group : StartupExtender.getExtenders((Lookup)new AbstractLookup((AbstractLookup.Content)ic), (StartupExtender.StartMode)mode)) {
                fixedArgs.addAll(group.getRawArguments());
            }
        }
        boolean splitParameters = vmArgsPresent || appArgsPresent;
        ArrayList<String> joinedArgs = new ArrayList<String>(fixedArgs);
        ExplicitProcessParameters changedParams = null;
        ExplicitProcessParameters injectParams = ExplicitProcessParameters.buildExplicitParameters((Lookup)config.getActionContext());
        if (splitParameters) {
            vmArgsValue = new ArrayList<String>(Arrays.asList(RunJarStartupArgs.splitCommandLine(props.get("exec.vmArgs"))));
            appArgsValue = new ArrayList<String>(Arrays.asList(RunJarStartupArgs.splitCommandLine(props.get("exec.appArgs"))));
        } else {
            String val = props.get("exec.args");
            String[] argParts = MavenExecuteUtils.splitAll(val, false);
            vmArgsValue = new ArrayList<String>(Arrays.asList(RunJarStartupArgs.splitCommandLine(argParts[0])));
            String[] mainClass = RunJarStartupArgs.splitCommandLine(argParts[1]);
            appArgsValue = new ArrayList<String>(Arrays.asList(RunJarStartupArgs.splitCommandLine(argParts[2])));
            if (mainClass.length == 0) {
                joinedArgs.addAll(appArgsValue);
                appArgsValue = Collections.emptyList();
            } else {
                joinedArgs.addAll(Arrays.asList(mainClass));
            }
            int at = vmArgsValue.indexOf("-classpath");
            if (at >= 0 && vmArgsValue.size() > at + 1 && "%classpath".equals(vmArgsValue.get(at + 1))) {
                List toMove = vmArgsValue.subList(at, at + 2);
                joinedArgs.subList(0, 0).addAll(toMove);
                toMove.clear();
            }
        }
        if (("true".equals(config.getProperties().get("exec.args.merged")) || vmArgsValue.isEmpty() && appArgsValue.isEmpty()) && (cmdLine = props.get("exec.args")) != null) {
            int templateIndex;
            String template = MavenExecuteUtils.doesNotSpecifyCustomExecArgs(false, config.getProperties());
            int n = templateIndex = template == null ? -1 : cmdLine.indexOf(template);
            if (templateIndex > 0) {
                String prefix = cmdLine.substring(0, templateIndex);
                String suffix = cmdLine.substring(templateIndex + template.length());
                if (splitParameters) {
                    vmArgsValue.addAll(0, Arrays.asList(RunJarStartupArgs.splitCommandLine(prefix.trim())));
                    appArgsValue.addAll(0, Arrays.asList(RunJarStartupArgs.splitCommandLine(suffix.trim())));
                }
                config.setProperty("exec.args", template);
            }
        }
        ArrayList<String> vmArgs = new ArrayList<String>(fixedArgs);
        if (!fixedArgs.isEmpty() || !injectParams.isEmpty()) {
            changedParams = ExplicitProcessParameters.builder().launcherArgs(vmArgsValue).args(appArgsValue).combine(injectParams).build();
            if (!splitParameters) {
                String newParams = String.join((CharSequence)" ", changedParams.getAllArguments(joinedArgs));
                config.setProperty("exec.args", newParams);
            }
            vmArgs.addAll(changedParams.getLauncherArguments());
            config.setProperty("exec.vmArgs", MavenExecuteUtils.joinParameters(vmArgs));
            config.setProperty("exec.appArgs", MavenExecuteUtils.joinParameters(changedParams.getArguments()));
        } else {
            vmArgs.addAll(vmArgsValue);
            config.setProperty("exec.vmArgs", MavenExecuteUtils.joinParameters(vmArgs));
            config.setProperty("exec.appArgs", MavenExecuteUtils.joinParameters(appArgsValue));
        }
        File workingDirectory = injectParams.getWorkingDirectory();
        if (workingDirectory != null) {
            config.setProperty("exec.workingdir", workingDirectory.getAbsolutePath());
        }
        Map environmentVariables = injectParams.getEnvironmentVariables();
        for (Map.Entry env : environmentVariables.entrySet()) {
            String value = (String)env.getValue();
            if (value == null) {
                value = MavenExecuteUtils.ENV_REMOVED;
            }
            config.setProperty("Env." + (String)env.getKey(), value);
        }
        if ("test".equals(props.get("exec.classpathScope"))) {
            isTestScope = true;
        }
        if (isTestScope) {
            String[] goals = config.getGoals().toArray(new String[0]);
            for (int i = 0; i < goals.length; ++i) {
                if (!"process-classes".equals(goals[i])) continue;
                goals[i] = "process-test-classes";
            }
            ((BeanRunConfig)config).setGoals(new ArrayList<String>(Arrays.asList(goals)));
        }
        config.setProperty("NbIde.ExplicitParametersApplied", "true");
        return true;
    }
}

