/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.MouseWheelListener;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.SeparatorWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.design.configuration.WSConfiguration;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.ProjectService;
import org.netbeans.modules.websvc.design.javamodel.ServiceChangeListener;
import org.netbeans.modules.websvc.design.javamodel.ServiceModel;
import org.netbeans.modules.websvc.design.javamodel.Utils;
import org.netbeans.modules.websvc.design.view.DesignerWidgetIdentityCode;
import org.netbeans.modules.websvc.design.view.Flushable;
import org.netbeans.modules.websvc.design.view.WsitWidget;
import org.netbeans.modules.websvc.design.view.ZoomManager;
import org.netbeans.modules.websvc.design.view.widget.OperationsWidget;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

@SuppressWarnings(value={"SE_BAD_FIELD"})
public class DesignView
extends JPanel
implements Flushable {
    public static final Object messageLayerKey = new Object();
    private FileObject implementationClass;
    private ProjectService service;
    private ServiceModel serviceModel;
    private ObjectScene scene;
    private ZoomManager zoomer;
    private Widget mainLayer;
    private Widget messageWidget;
    private LabelWidget headerWidget;
    private Widget contentWidget;
    private Widget mainWidget;
    private Widget separatorWidget;
    private OperationsWidget operationsWidget;
    private transient JToolBar toolbar;

    public DesignView(ProjectService service, FileObject implementationClass) {
        super(new BorderLayout());
        this.service = service;
        this.implementationClass = implementationClass;
        this.scene = new ObjectScene(){

            public Comparable<DesignerWidgetIdentityCode> getIdentityCode(Object object) {
                return new DesignerWidgetIdentityCode(DesignView.this.scene, object);
            }
        };
        this.zoomer = new ZoomManager((Scene)this.scene);
        this.scene.getActions().addAction(ActionFactory.createCycleObjectSceneFocusAction());
        this.scene.setKeyEventProcessingType(EventProcessingType.FOCUSED_WIDGET_AND_ITS_PARENTS);
        this.mainLayer = new LayerWidget((Scene)this.scene);
        this.mainLayer.setPreferredLocation(new Point(0, 0));
        this.mainLayer.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)12));
        this.scene.addChild(this.mainLayer);
        this.mainWidget = new Widget((Scene)this.scene);
        this.mainWidget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)12));
        this.headerWidget = new LabelWidget((Scene)this.scene);
        this.headerWidget.setFont(this.scene.getFont().deriveFont(1));
        this.headerWidget.setForeground(Color.GRAY);
        this.headerWidget.setBorder(BorderFactory.createEmptyBorder((int)6, (int)28, (int)0, (int)0));
        this.mainWidget.addChild((Widget)this.headerWidget);
        this.separatorWidget = new SeparatorWidget((Scene)this.scene, SeparatorWidget.Orientation.HORIZONTAL);
        this.separatorWidget.setForeground(Color.ORANGE);
        this.mainWidget.addChild(this.separatorWidget);
        this.contentWidget = new Widget((Scene)this.scene);
        this.contentWidget.setBorder(BorderFactory.createEmptyBorder((int)0, (int)20, (int)0, (int)20));
        this.contentWidget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)16));
        this.mainWidget.addChild(this.contentWidget);
        JPanel panel = new JPanel(new FlowLayout(1){

            @Override
            public void layoutContainer(Container target) {
                super.layoutContainer(target);
                Component[] components = target.getComponents();
                double height = target.getSize().getHeight() / 2.0;
                for (Component component : components) {
                    Point location = component.getLocation();
                    component.setLocation((int)location.getX(), (int)height);
                }
            }
        });
        panel.add(new JLabel(NbBundle.getMessage(DesignView.class, (String)"LBL_Wait")));
        this.add((Component)panel, "Center");
        this.mainLayer.addChild(this.mainWidget);
        this.messageWidget = new Widget((Scene)this.scene);
        this.messageWidget.setLayout(LayoutFactory.createVerticalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)4));
        this.mainLayer.addChild(this.messageWidget);
        this.scene.addObject(messageLayerKey, new Widget[]{this.messageWidget});
        this.initServiceModel();
    }

    public JComponent getToolbarRepresentation() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
            this.toolbar.setFloatable(false);
        }
        return this.toolbar;
    }

    public JComponent getContent() {
        JComponent view = this.scene.getView();
        if (view == null) {
            return this;
        }
        return view;
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
        this.getContent().requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.getContent().requestFocusInWindow();
    }

    @Override
    public void flushContent() {
        if (this.contentWidget != null) {
            List children = this.contentWidget.getChildren();
            for (Widget widget : children) {
                if (!(widget instanceof Flushable)) continue;
                ((Flushable)widget).flushContent();
            }
        }
    }

    private void initServiceModel() {
        SwingWorker<ServiceModel, Void> worker = new SwingWorker<ServiceModel, Void>(){
            private Collection<WSConfiguration> configurations;

            @Override
            protected ServiceModel doInBackground() throws Exception {
                ServiceModel model = ServiceModel.getServiceModel(DesignView.this.implementationClass);
                this.configurations = DesignView.this.service.getConfigurations();
                return model;
            }

            @Override
            protected void done() {
                try {
                    DesignView.this.serviceModel = (ServiceModel)this.get();
                    DesignView.this.initUI(this.configurations);
                }
                catch (ExecutionException e) {
                    Logger.getLogger(DesignView.class.getName()).log(Level.WARNING, null, e);
                }
                catch (InterruptedException e) {
                    Logger.getLogger(DesignView.class.getName()).log(Level.WARNING, null, e);
                }
            }
        };
        worker.execute();
    }

    private void initUI(Collection<WSConfiguration> wsConfigurations) {
        Component[] components;
        this.serviceModel.addServiceChangeListener(new ServiceChangeListener(){

            @Override
            public void propertyChanged(String propertyName, String oldValue, String newValue) {
                if (propertyName.equals("serviceName") || propertyName.equals("portName") && DesignView.this.service.getWsdlUrl() != null) {
                    DesignView.this.headerWidget.setLabel(DesignView.this.getServiceName());
                }
            }

            @Override
            public void operationAdded(MethodModel method) {
            }

            @Override
            public void operationRemoved(MethodModel method) {
            }

            @Override
            public void operationChanged(MethodModel oldMethod, MethodModel newMethod) {
            }
        });
        this.operationsWidget = new OperationsWidget(this.scene, this.service, this.serviceModel);
        this.contentWidget.addChild((Widget)this.operationsWidget);
        if (!wsConfigurations.isEmpty() && Utils.getService(this.service) != null) {
            WsitWidget wsitWidget = new WsitWidget(this.scene, Utils.getService(this.service), this.implementationClass, wsConfigurations);
            this.contentWidget.addChild((Widget)wsitWidget);
        }
        this.headerWidget.setLabel(this.getServiceName());
        JComponent sceneView = this.scene.createView();
        final JScrollPane panel = new JScrollPane(sceneView);
        panel.getVerticalScrollBar().setUnitIncrement(16);
        panel.getHorizontalScrollBar().setUnitIncrement(16);
        panel.setBorder(null);
        for (Component component : components = this.getComponents()) {
            this.remove(component);
        }
        this.add(panel);
        sceneView.removeMouseWheelListener((MouseWheelListener)((Object)sceneView));
        this.scene.addSceneListener(new Scene.SceneListener(){
            final /* synthetic */ DesignView this$0;
            {
                this.this$0 = this$0;
            }

            public void sceneRepaint() {
            }

            public void sceneValidating() {
            }

            public void sceneValidated() {
                int width = panel.getViewport().getWidth();
                if (width <= ((DesignView)this.this$0).scene.getBounds().width) {
                    this.this$0.mainWidget.setMinimumSize(new Dimension(width, 0));
                }
            }
        });
        this.addToolbarActions();
        this.getContent().putClientProperty("print.printable", Boolean.TRUE);
        this.invalidate();
        this.repaint();
    }

    private void addToolbarActions() {
        this.getToolbarRepresentation();
        this.toolbar.addSeparator();
        this.zoomer.addToolbarActions(this.toolbar);
        this.toolbar.addSeparator();
        this.operationsWidget.addToolbarActions(this.toolbar);
    }

    private String getServiceName() {
        String serviceName = this.serviceModel.getServiceName();
        if (this.service.getWsdlUrl() != null) {
            serviceName = serviceName + " [" + this.serviceModel.getPortName() + "]";
        }
        return serviceName;
    }
}

