/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.completion.completors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.completion.CompletionContext;
import org.netbeans.modules.spring.beans.completion.Completor;
import org.netbeans.modules.spring.beans.completion.CompletorUtils;
import org.netbeans.modules.spring.beans.completion.SpringXMLConfigCompletionItem;
import org.netbeans.modules.spring.beans.editor.SpringXMLConfigEditorUtils;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.openide.filesystems.FileObject;

public class BeansRefCompletor
extends Completor {
    private final boolean includeGlobal;

    public BeansRefCompletor(boolean includeGlobal, int invocationOffset) {
        super(invocationOffset);
        this.includeGlobal = includeGlobal;
    }

    @Override
    protected int initAnchorOffset(CompletionContext context) {
        return context.getCurrentTokenOffset() + 1;
    }

    @Override
    protected void compute(CompletionContext context) throws IOException {
        final FileObject fo = context.getFileObject();
        SpringConfigModel model = SpringConfigModel.forFileObject(fo);
        if (model == null) {
            return;
        }
        final String contextPrefix = this.getContextPrefix(context);
        final Set<String> forbiddenNames = this.getForbiddenNames(context);
        final ArrayList<String> cNames = new ArrayList<String>();
        String tagName = context.getTag().getNodeName();
        if (tagName.equals("bean") && SpringXMLConfigEditorUtils.hasAttribute(context.getTag(), "id")) {
            String cId = SpringXMLConfigEditorUtils.getAttribute(context.getTag(), "id");
            cNames.add(cId);
        }
        if (tagName.equals("bean") && SpringXMLConfigEditorUtils.hasAttribute(context.getTag(), "name")) {
            List<String> names = StringUtils.tokenize(SpringXMLConfigEditorUtils.getAttribute(context.getTag(), "name"), ",; ");
            cNames.addAll(names);
        }
        if (this.isCancelled()) {
            return;
        }
        model.runReadAction(new Action<SpringBeans>(){
            final /* synthetic */ BeansRefCompletor this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run(SpringBeans sb) {
                Map<String, SpringBean> name2Bean = this.getName2Beans(sb);
                for (Map.Entry<String, SpringBean> it : name2Bean.entrySet()) {
                    String beanName = it.getKey();
                    if (!beanName.startsWith(contextPrefix) || cNames.contains(beanName) || forbiddenNames.contains(beanName)) continue;
                    SpringBean bean = it.getValue();
                    SpringXMLConfigCompletionItem item = SpringXMLConfigCompletionItem.createBeanRefItem(this.this$0.getAnchorOffset(), beanName, bean, fo);
                    this.this$0.addCacheItem(item);
                }
            }

            private Map<String, SpringBean> getName2Beans(SpringBeans sb) {
                List<SpringBean> beans = this.this$0.includeGlobal ? sb.getBeans() : sb.getFileBeans(fo).getBeans();
                HashMap<String, SpringBean> name2Bean = new HashMap<String, SpringBean>();
                for (SpringBean bean : beans) {
                    String beanId = bean.getId();
                    if (beanId != null) {
                        name2Bean.put(beanId, bean);
                    }
                    if (!this.this$0.includeGlobal) continue;
                    List<String> beanNames = bean.getNames();
                    for (String beanName : beanNames) {
                        name2Bean.put(beanName, bean);
                    }
                }
                if (this.this$0.includeGlobal) {
                    Set<String> aliases = sb.getAliases();
                    for (String alias : aliases) {
                        SpringBean bean = sb.findBean(alias);
                        if (bean == null) continue;
                        name2Bean.put(alias, bean);
                    }
                }
                return name2Bean;
            }
        });
    }

    @Override
    public boolean canFilter(CompletionContext context) {
        return CompletorUtils.canFilter(context.getDocument(), this.getInvocationOffset(), context.getCaretOffset(), this.getAnchorOffset(), CompletorUtils.BEAN_NAME_ACCEPTOR);
    }

    @Override
    protected List<SpringXMLConfigCompletionItem> doFilter(CompletionContext context) {
        return CompletorUtils.filter(this.getCacheItems(), context.getDocument(), this.getInvocationOffset(), context.getCaretOffset(), this.getAnchorOffset());
    }

    protected String getContextPrefix(CompletionContext context) {
        return context.getTypedPrefix();
    }

    protected Set<String> getForbiddenNames(CompletionContext context) {
        return Collections.emptySet();
    }
}

