/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Color;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.websvc.api.customization.model.CustomizationComponentFactory;
import org.netbeans.modules.websvc.api.customization.model.DefinitionsCustomization;
import org.netbeans.modules.websvc.api.customization.model.EnableAsyncMapping;
import org.netbeans.modules.websvc.api.customization.model.EnableWrapperStyle;
import org.netbeans.modules.websvc.api.customization.model.JavaMethod;
import org.netbeans.modules.websvc.api.customization.model.PortTypeCustomization;
import org.netbeans.modules.websvc.api.customization.model.PortTypeOperationCustomization;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.customization.multiview.DefinitionsPanel;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class PortTypeOperationPanel
extends SaveableSectionInnerPanel {
    private Operation operation;
    private WSDLModel model;
    private boolean wsdlDirty;
    private DefaultItemListener dil;
    private ModelChangeListener modelListener;
    private ModelChangeListener primaryModelListener;
    private Definitions primaryDefinitions;
    private WSDLModel primaryModel;
    private JCheckBox defaultMethodCB;
    private ButtonGroup eamButtonGroup;
    private JCheckBox enableAsyncMappingCB;
    private JCheckBox enableWrapperStyleCB;
    private ButtonGroup ewsButtonGroup;
    private JLabel jLabel4;
    private JTextField javaMethodName;
    private JLabel portTypeLabel;
    private JLabel portTypeName;

    public PortTypeOperationPanel(SectionView view, Operation operation, Node node, Definitions primaryDefinitions) {
        super(view);
        this.operation = operation;
        this.primaryDefinitions = primaryDefinitions;
        this.model = this.operation.getModel();
        this.primaryModel = this.primaryDefinitions.getModel();
        this.initComponents();
        this.disableEnterKey();
        if (!this.isClient(node)) {
            this.enableAsyncMappingCB.setVisible(false);
        }
        this.enableAsyncMappingCB.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_ENABLE_ASYNC"));
        this.enableWrapperStyleCB.setToolTipText(NbBundle.getMessage(DefinitionsPanel.class, (String)"TOOLTIP_ENABLE_WRAPPER"));
        this.syncButtons();
        this.syncJavaMethod();
        this.dil = new DefaultItemListener();
        ItemListener il = (ItemListener)WeakListeners.create(ItemListener.class, (EventListener)this.dil, (Object)this.defaultMethodCB);
        this.defaultMethodCB.addItemListener(il);
        this.modelListener = new ModelChangeListener();
        PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this.modelListener, (Object)this.model);
        this.model.addPropertyChangeListener(pcl);
        if (this.model != this.primaryModel) {
            this.primaryModelListener = new ModelChangeListener();
            PropertyChangeListener l = WeakListeners.propertyChange((PropertyChangeListener)this.primaryModelListener, (Object)this.primaryModel);
            this.primaryModel.addPropertyChangeListener(l);
        }
        this.addModifier(this.javaMethodName);
        this.addModifier(this.defaultMethodCB);
        this.addModifier(this.enableAsyncMappingCB);
        this.addModifier(this.enableWrapperStyleCB);
        this.addValidatee(this.javaMethodName);
    }

    private String getParentOfOperation(Operation operation) {
        PortType portType = (PortType)operation.getParent();
        return portType.getName();
    }

    private void syncJavaMethod() {
        List ee = this.operation.getExtensibilityElements(PortTypeOperationCustomization.class);
        if (ee.size() == 1) {
            PortTypeOperationCustomization ptoc = (PortTypeOperationCustomization)ee.get(0);
            JavaMethod jm = ptoc.getJavaMethod();
            if (jm != null) {
                this.setJavaMethod(jm.getName());
            } else {
                this.defaultMethodCB.setSelected(true);
                this.javaMethodName.setEnabled(false);
            }
        } else {
            this.defaultMethodCB.setSelected(true);
            this.javaMethodName.setEnabled(false);
        }
    }

    public final void syncButtons() {
        List ee = this.operation.getExtensibilityElements(PortTypeOperationCustomization.class);
        if (ee.size() == 1) {
            PortTypeOperationCustomization ptoc = (PortTypeOperationCustomization)ee.get(0);
            EnableAsyncMapping eam = ptoc.getEnableAsyncMapping();
            if (eam != null) {
                this.setEnableAsyncMapping(eam.isEnabled());
            } else {
                this.setEnableAsyncMapping(this.getAsyncMappingOfParent());
            }
            EnableWrapperStyle ews = ptoc.getEnableWrapperStyle();
            if (ews != null) {
                this.setEnableWrapperStyle(ews.isEnabled());
            } else {
                this.setEnableWrapperStyle(this.getWrapperStyleOfParent());
            }
        } else {
            this.setEnableAsyncMapping(this.getAsyncMappingOfParent());
            this.setEnableWrapperStyle(this.getWrapperStyleOfParent());
            this.defaultMethodCB.setSelected(true);
            this.javaMethodName.setEnabled(false);
        }
    }

    private boolean getAsyncMappingOfParent() {
        PortTypeCustomization ptc;
        EnableAsyncMapping asyncMapping;
        boolean isAsyncMapping = false;
        PortType portType = (PortType)this.operation.getParent();
        List ptcs = portType.getExtensibilityElements(PortTypeCustomization.class);
        isAsyncMapping = ptcs.size() > 0 ? ((asyncMapping = (ptc = (PortTypeCustomization)ptcs.get(0)).getEnableAsyncMapping()) != null ? asyncMapping.isEnabled() : this.getAsyncMappingFromDefinitions(this.primaryDefinitions)) : this.getAsyncMappingFromDefinitions(this.primaryDefinitions);
        return isAsyncMapping;
    }

    private boolean getAsyncMappingFromDefinitions(Definitions definitions) {
        DefinitionsCustomization dc;
        EnableAsyncMapping asyncMapping;
        List dcs = definitions.getExtensibilityElements(DefinitionsCustomization.class);
        if (dcs.size() > 0 && (asyncMapping = (dc = (DefinitionsCustomization)dcs.get(0)).getEnableAsyncMapping()) != null) {
            return asyncMapping.isEnabled();
        }
        return false;
    }

    private boolean getWrapperStyleFromDefinitions(Definitions definitions) {
        DefinitionsCustomization dc;
        EnableWrapperStyle wrapperStyle;
        List dcs = definitions.getExtensibilityElements(DefinitionsCustomization.class);
        if (dcs.size() > 0 && (wrapperStyle = (dc = (DefinitionsCustomization)dcs.get(0)).getEnableWrapperStyle()) != null) {
            return wrapperStyle.isEnabled();
        }
        return true;
    }

    private boolean getWrapperStyleOfParent() {
        PortTypeCustomization ptc;
        EnableWrapperStyle wrapperStyle;
        boolean isWrapperStyle = true;
        PortType portType = (PortType)this.operation.getParent();
        List ptcs = portType.getExtensibilityElements(PortTypeCustomization.class);
        isWrapperStyle = ptcs.size() > 0 ? ((wrapperStyle = (ptc = (PortTypeCustomization)ptcs.get(0)).getEnableWrapperStyle()) != null ? wrapperStyle.isEnabled() : this.getWrapperStyleFromDefinitions(this.primaryDefinitions)) : this.getWrapperStyleFromDefinitions(this.primaryDefinitions);
        return isWrapperStyle;
    }

    public void setEnableAsyncMapping(boolean enable) {
        this.enableAsyncMappingCB.setSelected(enable);
    }

    public boolean getEnableAsyncMapping() {
        return this.enableAsyncMappingCB.isSelected();
    }

    public void setEnableWrapperStyle(boolean enable) {
        this.enableWrapperStyleCB.setSelected(enable);
    }

    public boolean getEnableWrapperStyle() {
        return this.enableWrapperStyleCB.isSelected();
    }

    public void setJavaMethod(String method) {
        this.javaMethodName.setText(method);
    }

    public JComponent getErrorComponent(String string) {
        return new JButton("error");
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        block44: {
            List ee = this.operation.getExtensibilityElements(PortTypeOperationCustomization.class);
            CustomizationComponentFactory factory = CustomizationComponentFactory.getDefault();
            try {
                if (jComponent == this.javaMethodName || jComponent == this.defaultMethodCB) {
                    String text = this.javaMethodName.getText();
                    if (text != null && !text.trim().equals("") && !this.defaultMethodCB.isSelected()) {
                        if (!JaxWsUtils.isJavaIdentifier((String)text)) {
                            return;
                        }
                        if (ee.size() > 0) {
                            PortTypeOperationCustomization ptoc = (PortTypeOperationCustomization)ee.get(0);
                            JavaMethod jm = ptoc.getJavaMethod();
                            if (jm == null) {
                                try {
                                    jm = factory.createJavaMethod(this.model);
                                    this.model.startTransaction();
                                    jm.setName(text);
                                    ptoc.setJavaMethod(jm);
                                    this.wsdlDirty = true;
                                    break block44;
                                }
                                finally {
                                    this.model.endTransaction();
                                }
                            }
                            try {
                                this.model.startTransaction();
                                jm.setName(text);
                                this.wsdlDirty = true;
                                break block44;
                            }
                            finally {
                                this.model.endTransaction();
                            }
                        }
                        PortTypeOperationCustomization ptoc = factory.createPortTypeOperationCustomization(this.model);
                        JavaMethod jm = factory.createJavaMethod(this.model);
                        try {
                            this.model.startTransaction();
                            jm.setName(text);
                            ptoc.setJavaMethod(jm);
                            this.operation.addExtensibilityElement((ExtensibilityElement)ptoc);
                            this.wsdlDirty = true;
                            break block44;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                    if (ee.size() != 1) break block44;
                    try {
                        PortTypeOperationCustomization ptoc = (PortTypeOperationCustomization)ee.get(0);
                        JavaMethod jm = ptoc.getJavaMethod();
                        if (jm != null) {
                            this.model.startTransaction();
                            ptoc.removeJavaMethod(jm);
                            if (ptoc.getChildren().size() == 0) {
                                this.operation.removeExtensibilityElement((ExtensibilityElement)ptoc);
                            }
                            this.wsdlDirty = true;
                        }
                        break block44;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
                if (jComponent == this.enableWrapperStyleCB) {
                    if (ee.size() > 0) {
                        PortTypeOperationCustomization poc = (PortTypeOperationCustomization)ee.get(0);
                        EnableWrapperStyle ews = poc.getEnableWrapperStyle();
                        if (ews == null) {
                            try {
                                this.model.startTransaction();
                                ews = factory.createEnableWrapperStyle(this.model);
                                ews.setEnabled(this.getEnableWrapperStyle());
                                poc.setEnableWrapperStyle(ews);
                                this.wsdlDirty = true;
                                break block44;
                            }
                            finally {
                                this.model.endTransaction();
                            }
                        }
                        try {
                            this.model.startTransaction();
                            ews.setEnabled(this.getEnableWrapperStyle());
                            this.wsdlDirty = true;
                            break block44;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                    PortTypeOperationCustomization poc = factory.createPortTypeOperationCustomization(this.model);
                    EnableWrapperStyle ews = factory.createEnableWrapperStyle(this.model);
                    try {
                        this.model.startTransaction();
                        ews.setEnabled(this.getEnableWrapperStyle());
                        poc.setEnableWrapperStyle(ews);
                        this.operation.addExtensibilityElement((ExtensibilityElement)poc);
                        this.wsdlDirty = true;
                        break block44;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
                if (jComponent != this.enableAsyncMappingCB) break block44;
                if (ee.size() > 0) {
                    PortTypeOperationCustomization poc = (PortTypeOperationCustomization)ee.get(0);
                    EnableAsyncMapping eam = poc.getEnableAsyncMapping();
                    if (eam == null) {
                        try {
                            this.model.startTransaction();
                            eam = factory.createEnableAsyncMapping(this.model);
                            eam.setEnabled(this.getEnableAsyncMapping());
                            poc.setEnableAsyncMapping(eam);
                            this.wsdlDirty = true;
                            break block44;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                    try {
                        this.model.startTransaction();
                        eam.setEnabled(this.getEnableAsyncMapping());
                        this.wsdlDirty = true;
                        break block44;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
                PortTypeOperationCustomization poc = factory.createPortTypeOperationCustomization(this.model);
                EnableAsyncMapping eam = factory.createEnableAsyncMapping(this.model);
                try {
                    this.model.startTransaction();
                    eam.setEnabled(this.getEnableAsyncMapping());
                    poc.setEnableAsyncMapping(eam);
                    this.operation.addExtensibilityElement((ExtensibilityElement)poc);
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
            catch (IllegalStateException ex) {
                Exceptions.attachSeverity((Throwable)ex, (Level)Level.WARNING);
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void documentChanged(JTextComponent comp, String val) {
        if (comp == this.javaMethodName && !JaxWsUtils.isJavaIdentifier((String)val)) {
            this.getSectionView().getErrorPanel().setError(new Error(0, 0, val, (JComponent)comp));
            return;
        }
        this.getSectionView().getErrorPanel().clearError();
    }

    public void rollbackValue(JTextComponent source) {
        if (source == this.javaMethodName) {
            PortTypeOperationCustomization ptoc;
            JavaMethod jm;
            String methodName = "";
            List ee = this.operation.getExtensibilityElements(PortTypeOperationCustomization.class);
            if (ee.size() == 1 && (jm = (ptoc = (PortTypeOperationCustomization)ee.get(0)).getJavaMethod()) != null) {
                methodName = jm.getName();
            }
            this.javaMethodName.setText(methodName);
        }
    }

    @Override
    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    @Override
    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.ewsButtonGroup = new ButtonGroup();
        this.eamButtonGroup = new ButtonGroup();
        this.jLabel4 = new JLabel();
        this.javaMethodName = new JTextField();
        this.defaultMethodCB = new JCheckBox();
        this.enableWrapperStyleCB = new JCheckBox();
        this.enableAsyncMappingCB = new JCheckBox();
        this.portTypeLabel = new JLabel();
        this.portTypeName = new JLabel();
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle");
        this.jLabel4.setText(bundle.getString("LBL_JAVA_METHOD_NAME"));
        this.javaMethodName.setToolTipText(bundle.getString("TOOLTIP_PORTTYPE_METHOD"));
        this.javaMethodName.setDisabledTextColor(new Color(0, 0, 0));
        this.defaultMethodCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_USE_DEFAULT").charAt(0));
        this.defaultMethodCB.setText(bundle.getString("LBL_USE_DEFAULT"));
        this.defaultMethodCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultMethodCB.setContentAreaFilled(false);
        this.enableWrapperStyleCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_WRAPPER_STYLE").charAt(0));
        this.enableWrapperStyleCB.setText(bundle.getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableWrapperStyleCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableWrapperStyleCB.setContentAreaFilled(false);
        this.enableAsyncMappingCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_ENABLE_ASYNC_CLIENT").charAt(0));
        this.enableAsyncMappingCB.setText(bundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableAsyncMappingCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.enableAsyncMappingCB.setContentAreaFilled(false);
        this.portTypeLabel.setText(bundle.getString("LBL_ENCLOSING_PORTTYPE"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(22, 22, 22).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.enableAsyncMappingCB).addComponent(this.enableWrapperStyleCB).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.portTypeLabel).addComponent(this.jLabel4)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addGap(158, 158, 158).addComponent(this.portTypeName).addGap(106, 106, 106)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.javaMethodName, -2, 132, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.defaultMethodCB))))).addContainerGap(103, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(9, 9, 9).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portTypeLabel).addComponent(this.portTypeName)).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.defaultMethodCB).addComponent(this.javaMethodName, -2, 26, -2)).addGap(12, 12, 12).addComponent(this.enableWrapperStyleCB).addGap(12, 12, 12).addComponent(this.enableAsyncMappingCB).addContainerGap(24, Short.MAX_VALUE)));
        this.jLabel4.getAccessibleContext().setAccessibleName(bundle.getString("LBL_JAVA_METHOD_NAME"));
        this.javaMethodName.getAccessibleContext().setAccessibleName(bundle.getString("LBL_JAVA_METHOD_NAME"));
        this.javaMethodName.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_JAVA_METHOD_NAME"));
        this.defaultMethodCB.getAccessibleContext().setAccessibleName(bundle.getString("LBL_USE_DEFAULT"));
        this.defaultMethodCB.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_USE_DEFAULT"));
        this.enableWrapperStyleCB.getAccessibleContext().setAccessibleName(bundle.getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableWrapperStyleCB.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_ENABLE_WRAPPER_STYLE"));
        this.enableAsyncMappingCB.getAccessibleContext().setAccessibleName(bundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.enableAsyncMappingCB.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_ENABLE_ASYNC_MAPPING"));
        this.portTypeLabel.getAccessibleContext().setAccessibleName(bundle.getString("LBL_ENCLOSING_PORTTYPE"));
    }

    class DefaultItemListener
    implements ItemListener {
        DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (PortTypeOperationPanel.this.defaultMethodCB.isSelected()) {
                PortTypeOperationPanel.this.javaMethodName.setEnabled(false);
            } else {
                PortTypeOperationPanel.this.javaMethodName.setEnabled(true);
                PortTypeOperationPanel.this.javaMethodName.requestFocus();
            }
        }
    }

    class ModelChangeListener
    implements PropertyChangeListener {
        ModelChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EnableAsyncMapping eam;
            WSDLComponent parent;
            Object source = evt.getSource();
            if (source instanceof EnableWrapperStyle) {
                EnableWrapperStyle ews = (EnableWrapperStyle)source;
                WSDLComponent parent2 = (WSDLComponent)ews.getParent();
                if (parent2 instanceof DefinitionsCustomization || parent2 instanceof PortTypeCustomization) {
                    PortTypeOperationPanel.this.syncButtons();
                }
            } else if (source instanceof EnableAsyncMapping && ((parent = (WSDLComponent)(eam = (EnableAsyncMapping)source).getParent()) instanceof DefinitionsCustomization || parent instanceof PortTypeCustomization)) {
                PortTypeOperationPanel.this.syncButtons();
            }
        }
    }
}

