/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.customization.multiview;

import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.websvc.api.customization.model.JAXWSQName;
import org.netbeans.modules.websvc.api.customization.model.JavaMethod;
import org.netbeans.modules.websvc.api.customization.model.PortCustomization;
import org.netbeans.modules.websvc.api.customization.model.Provider;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.customization.multiview.ExternalBindingTablePanel;
import org.netbeans.modules.websvc.customization.multiview.SaveableSectionInnerPanel;
import org.netbeans.modules.xml.multiview.Error;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class PortPanel
extends SaveableSectionInnerPanel {
    private Port port;
    private WSDLModel model;
    private boolean wsdlDirty;
    private DefaultItemListener defaultListener;
    private ProviderActionListener providerActionListener;
    private Node node;
    private JCheckBox defaultMethodCB;
    private JLabel portAccessLabel;
    private JTextField portAccessMethodText;
    private JCheckBox providerCB;
    private JLabel serviceLabel;
    private JLabel serviceName;

    public PortPanel(SectionView view, Port port, Node node) {
        super(view);
        this.port = port;
        this.model = this.port.getModel();
        this.node = node;
        this.initComponents();
        this.disableEnterKey();
        this.sync();
        this.defaultListener = new DefaultItemListener();
        ItemListener itemListener = (ItemListener)WeakListeners.create(ItemListener.class, (EventListener)this.defaultListener, (Object)this.defaultMethodCB);
        this.defaultMethodCB.addItemListener(itemListener);
        if (!this.isClient(node)) {
            this.providerActionListener = new ProviderActionListener();
            ActionListener providerListener = (ActionListener)WeakListeners.create(ActionListener.class, (EventListener)this.providerActionListener, (Object)this.providerCB);
            this.providerCB.addActionListener(providerListener);
        } else {
            this.providerCB.setVisible(false);
        }
        this.addModifier(this.portAccessMethodText);
        this.addModifier(this.defaultMethodCB);
        this.addValidatee(this.portAccessMethodText);
    }

    private String getParentOfPort(Port port) {
        Service service = (Service)port.getParent();
        return service.getName();
    }

    private void sync() {
        List ee = this.port.getExtensibilityElements(PortCustomization.class);
        if (ee.size() == 1) {
            PortCustomization pc = (PortCustomization)ee.get(0);
            JavaMethod jm = pc.getJavaMethod();
            if (jm != null) {
                this.setPortAccessMethod(jm.getName());
            } else {
                this.defaultMethodCB.setSelected(true);
                this.portAccessMethodText.setEnabled(false);
            }
            Provider provider = pc.getProvider();
            if (provider != null) {
                if (provider.isEnabled()) {
                    this.providerCB.setSelected(true);
                } else {
                    this.providerCB.setSelected(false);
                }
            } else {
                this.providerCB.setSelected(false);
            }
        } else {
            this.providerCB.setSelected(false);
            this.defaultMethodCB.setSelected(true);
            this.portAccessMethodText.setEnabled(false);
        }
    }

    public void setPortAccessMethod(String name) {
        this.portAccessMethodText.setText(name);
    }

    public String getPortAccessMethod() {
        return this.portAccessMethodText.getText();
    }

    public void setProvider(boolean enable) {
        this.providerCB.setSelected(enable);
    }

    public boolean isProvider() {
        return this.providerCB.isSelected();
    }

    public JComponent getErrorComponent(String string) {
        return new JButton("error");
    }

    public void linkButtonPressed(Object object, String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(JComponent jComponent, Object object) {
        block32: {
            List ee = this.port.getExtensibilityElements(PortCustomization.class);
            try {
                PortCustomization pc;
                JavaMethod jm;
                if (jComponent == this.providerCB) {
                    if (ee.size() == 1) {
                        PortCustomization pc2 = (PortCustomization)ee.get(0);
                        Provider provider = pc2.getProvider();
                        if (this.isProvider()) {
                            if (provider != null) break block32;
                            try {
                                provider = (Provider)this.model.getFactory().create((WSDLComponent)pc2, JAXWSQName.PROVIDER.getQName());
                                this.model.startTransaction();
                                provider.setEnabled(true);
                                pc2.setProvider(provider);
                                this.wsdlDirty = true;
                                break block32;
                            }
                            finally {
                                this.model.endTransaction();
                            }
                        }
                        if (provider == null) break block32;
                        try {
                            this.model.startTransaction();
                            pc2.removeProvider(provider);
                            if (pc2.getChildren().size() == 0) {
                                this.port.removeExtensibilityElement((ExtensibilityElement)pc2);
                            }
                            this.wsdlDirty = true;
                            break block32;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                    if (!this.isProvider()) break block32;
                    WSDLComponentFactory factory = this.model.getFactory();
                    PortCustomization pc3 = (PortCustomization)factory.create((WSDLComponent)this.port, JAXWSQName.BINDINGS.getQName());
                    Provider provider = (Provider)factory.create((WSDLComponent)pc3, JAXWSQName.PROVIDER.getQName());
                    try {
                        this.model.startTransaction();
                        provider.setEnabled(true);
                        pc3.setProvider(provider);
                        this.port.addExtensibilityElement((ExtensibilityElement)pc3);
                        this.wsdlDirty = true;
                        break block32;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
                if (jComponent != this.portAccessMethodText && jComponent != this.defaultMethodCB) break block32;
                String text = this.portAccessMethodText.getText();
                if (text != null && !text.trim().equals("") && !this.defaultMethodCB.isSelected()) {
                    if (!JaxWsUtils.isJavaIdentifier((String)text)) {
                        return;
                    }
                    if (ee.size() == 1) {
                        PortCustomization pc4 = (PortCustomization)ee.get(0);
                        JavaMethod jm2 = pc4.getJavaMethod();
                        if (jm2 == null) {
                            try {
                                jm2 = (JavaMethod)this.model.getFactory().create((WSDLComponent)pc4, JAXWSQName.METHOD.getQName());
                                this.model.startTransaction();
                                jm2.setName(text);
                                pc4.setJavaMethod(jm2);
                                this.wsdlDirty = true;
                                break block32;
                            }
                            finally {
                                this.model.endTransaction();
                            }
                        }
                        try {
                            this.model.startTransaction();
                            jm2.setName(text);
                            this.wsdlDirty = true;
                            break block32;
                        }
                        finally {
                            this.model.endTransaction();
                        }
                    }
                    WSDLComponentFactory factory = this.model.getFactory();
                    PortCustomization pc5 = (PortCustomization)factory.create((WSDLComponent)this.port, JAXWSQName.BINDINGS.getQName());
                    JavaMethod jm3 = (JavaMethod)factory.create((WSDLComponent)pc5, JAXWSQName.METHOD.getQName());
                    try {
                        this.model.startTransaction();
                        jm3.setName(text);
                        pc5.setJavaMethod(jm3);
                        this.port.addExtensibilityElement((ExtensibilityElement)pc5);
                        this.wsdlDirty = true;
                        break block32;
                    }
                    finally {
                        this.model.endTransaction();
                    }
                }
                if (ee.size() != 1 || (jm = (pc = (PortCustomization)ee.get(0)).getJavaMethod()) == null) break block32;
                try {
                    this.model.startTransaction();
                    pc.removeJavaMethod(jm);
                    if (pc.getChildren().size() == 0) {
                        this.port.removeExtensibilityElement((ExtensibilityElement)pc);
                    }
                    this.wsdlDirty = true;
                }
                finally {
                    this.model.endTransaction();
                }
            }
            catch (IllegalStateException ex) {
                Exceptions.attachSeverity((Throwable)ex, (Level)Level.WARNING);
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void documentChanged(JTextComponent comp, String val) {
        if (comp == this.portAccessMethodText && !JaxWsUtils.isJavaIdentifier((String)val)) {
            this.getSectionView().getErrorPanel().setError(new Error(0, 0, val, (JComponent)comp));
            return;
        }
        this.getSectionView().getErrorPanel().clearError();
    }

    public void rollbackValue(JTextComponent source) {
        if (source == this.portAccessMethodText) {
            PortCustomization pc;
            JavaMethod jm;
            String methodName = "";
            List ee = this.port.getExtensibilityElements(PortCustomization.class);
            if (ee.size() == 1 && (jm = (pc = (PortCustomization)ee.get(0)).getJavaMethod()) != null) {
                methodName = jm.getName();
            }
            this.portAccessMethodText.setText(methodName);
        }
    }

    @Override
    public boolean wsdlIsDirty() {
        return this.wsdlDirty;
    }

    @Override
    public void save() {
        if (this.wsdlDirty) {
            this.setModelDirty(this.model);
        }
    }

    private void initComponents() {
        this.portAccessLabel = new JLabel();
        this.portAccessMethodText = new JTextField();
        this.providerCB = new JCheckBox();
        this.defaultMethodCB = new JCheckBox();
        this.serviceLabel = new JLabel();
        this.serviceName = new JLabel();
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle");
        this.portAccessLabel.setText(bundle.getString("LBL_PORT_ACCESS_METHOD"));
        this.portAccessMethodText.setToolTipText(bundle.getString("TOOLTIP_GET_PORT"));
        this.providerCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_USE_PROVIDER").charAt(0));
        this.providerCB.setText(bundle.getString("LBL_USE_PROVIDER"));
        this.providerCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.providerCB.setContentAreaFilled(false);
        this.providerCB.setMargin(new Insets(0, 0, 0, 0));
        this.defaultMethodCB.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/websvc/customization/multiview/Bundle").getString("MNEMONIC_USE_DEFAULT").charAt(0));
        this.defaultMethodCB.setText(bundle.getString("LBL_USE_DEFAULT"));
        this.defaultMethodCB.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.defaultMethodCB.setContentAreaFilled(false);
        this.defaultMethodCB.setMargin(new Insets(0, 0, 0, 0));
        this.serviceLabel.setText(bundle.getString("LBL_ENCLOSING_SERVICE"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serviceLabel).addComponent(this.portAccessLabel)).addGap(14, 14, 14).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.portAccessMethodText, -2, 159, -2).addGap(20, 20, 20).addComponent(this.defaultMethodCB)).addComponent(this.serviceName, -2, 182, -2))).addComponent(this.providerCB)).addContainerGap(77, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serviceLabel).addComponent(this.serviceName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 22, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.portAccessLabel).addComponent(this.portAccessMethodText, -2, -1, -2).addComponent(this.defaultMethodCB)).addGap(21, 21, 21).addComponent(this.providerCB).addGap(19, 19, 19)));
        this.portAccessLabel.getAccessibleContext().setAccessibleName(bundle.getString("LBL_PORT_ACCESS_METHOD"));
        this.portAccessMethodText.getAccessibleContext().setAccessibleName(bundle.getString("LBL_PORT_ACCESS_METHOD"));
        this.portAccessMethodText.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_PORT_ACCESS_METHOD"));
        this.providerCB.getAccessibleContext().setAccessibleName(bundle.getString("LBL_USE_PROVIDER"));
        this.providerCB.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_USE_PROVIDER"));
        this.defaultMethodCB.getAccessibleContext().setAccessibleName(bundle.getString("LBL_USE_DEFAULT"));
        this.defaultMethodCB.getAccessibleContext().setAccessibleDescription(bundle.getString("LBL_USE_DEFAULT"));
        this.serviceLabel.getAccessibleContext().setAccessibleName(bundle.getString("LBL_ENCLOSING_SERVICE"));
    }

    class DefaultItemListener
    implements ItemListener {
        DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (PortPanel.this.defaultMethodCB.isSelected()) {
                PortPanel.this.portAccessMethodText.setEnabled(false);
            } else {
                PortPanel.this.portAccessMethodText.setEnabled(true);
                PortPanel.this.portAccessMethodText.requestFocus();
            }
        }
    }

    class ProviderActionListener
    implements ActionListener {
        ProviderActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PortPanel.this.providerCB) {
                if (PortPanel.this.providerCB.isSelected()) {
                    NotifyDescriptor.Confirmation notifyDesc = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExternalBindingTablePanel.class, (String)"WARN_PROVIDER_INTERFACE"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDesc);
                    if (notifyDesc.getValue() == NotifyDescriptor.NO_OPTION) {
                        PortPanel.this.providerCB.setSelected(false);
                        return;
                    }
                }
                PortPanel.this.setValue(PortPanel.this.providerCB, null);
            }
        }
    }
}

