/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.jakartaee;

import java.io.File;
import java.util.List;
import java.util.Set;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.plugins.spi.JDBCDriverDeployer;
import org.netbeans.modules.j2ee.deployment.plugins.spi.OptionalDeploymentManagerFactory;
import org.netbeans.modules.payara.eecommon.api.JDBCDriverDeployHelper;
import org.netbeans.modules.payara.jakartaee.Hk2DeploymentManager;
import org.netbeans.modules.payara.jakartaee.ide.MonitorProgressObject;
import org.netbeans.modules.payara.spi.PayaraModule;
import org.netbeans.modules.payara.tooling.TaskEvent;
import org.netbeans.modules.payara.tooling.TaskState;
import org.netbeans.modules.payara.tooling.TaskStateListener;
import org.openide.util.RequestProcessor;

public class JDBCDriverDeployerImpl
implements JDBCDriverDeployer {
    private final File driverLoc;
    private final PayaraModule commonSupport;
    private final boolean isLocal;
    private Hk2DeploymentManager dm;

    public JDBCDriverDeployerImpl(Hk2DeploymentManager dm, OptionalDeploymentManagerFactory odmf) {
        this.dm = dm;
        this.commonSupport = dm.getCommonServerSupport();
        String domainDir = (String)this.commonSupport.getInstanceProperties().get("domainsfolder");
        this.isLocal = null != domainDir && domainDir.trim().length() >= 1;
        String domain = (String)this.commonSupport.getInstanceProperties().get("domainname");
        this.driverLoc = new File(domainDir + File.separator + domain + File.separator + "lib");
    }

    public boolean supportsDeployJDBCDrivers(Target target) {
        boolean supported = this.isLocal;
        if (supported) {
            supported = Boolean.parseBoolean((String)this.commonSupport.getInstanceProperties().get("driverDeployOn"));
        }
        return supported;
    }

    public ProgressObject deployJDBCDrivers(Target target, Set<Datasource> datasources) {
        List urls = JDBCDriverDeployHelper.getMissingDrivers((File[])this.getDriverLocations(), datasources);
        final MonitorProgressObject startProgress = new MonitorProgressObject(this.dm, null);
        ProgressObject retVal = JDBCDriverDeployHelper.getProgressObject((File)this.driverLoc, (List)urls);
        if (urls.size() > 0) {
            retVal.addProgressListener(new ProgressListener(){
                final /* synthetic */ JDBCDriverDeployerImpl this$0;
                {
                    this.this$0 = this$0;
                }

                public void handleProgressEvent(ProgressEvent event) {
                    if (event.getDeploymentStatus().isCompleted()) {
                        this.this$0.commonSupport.restartServer((TaskStateListener)startProgress);
                    } else {
                        startProgress.fireHandleProgressEvent(event.getDeploymentStatus());
                    }
                }
            });
        } else {
            startProgress.operationStateChanged(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, "no deployment necessary");
        }
        RequestProcessor.getDefault().post((Runnable)retVal);
        return startProgress;
    }

    private File[] getDriverLocations() {
        String installLoc = (String)this.commonSupport.getInstanceProperties().get("homefolder");
        File installLib = new File(installLoc + File.separator + "lib");
        File[] locs = new File[]{this.driverLoc, installLib};
        return locs;
    }
}

