/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.debugger.jpda;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class MethodBreakpoint
extends JPDABreakpoint {
    public static final String PROP_METHOD_NAME = "methodName";
    public static final String PROP_METHOD_SIGNATURE = "signature";
    public static final String PROP_BREAKPOINT_TYPE = "breakpointtType";
    public static final String PROP_CONDITION = "condition";
    public static final String PROP_CLASS_FILTERS = "classFilters";
    public static final String PROP_CLASS_EXCLUSION_FILTERS = "classExclusionFilters";
    public static final String PROP_INSTANCE_FILTERS = "instanceFilters";
    public static final String PROP_THREAD_FILTERS = "threadFilters";
    public static final int TYPE_METHOD_ENTRY = 1;
    public static final int TYPE_METHOD_EXIT = 2;
    private String[] classFilters = new String[0];
    private String[] classExclusionFilters = new String[0];
    private String methodName = "";
    private String methodSignature;
    private int breakpointType = 1;
    private String condition = "";
    private Map<JPDADebugger, ObjectVariable[]> instanceFilters;
    private Map<JPDADebugger, JPDAThread[]> threadFilters;

    private MethodBreakpoint() {
    }

    public static MethodBreakpoint create(String className, String methodName) {
        MethodBreakpointImpl b = new MethodBreakpointImpl();
        b.setClassFilters(new String[]{className});
        b.setMethodName(methodName);
        return b;
    }

    public static MethodBreakpoint create() {
        MethodBreakpointImpl b = new MethodBreakpointImpl();
        return b;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String mn) {
        if (mn != null) {
            mn = mn.trim();
        }
        if (Objects.equals(mn, this.methodName)) {
            return;
        }
        String old = this.methodName;
        this.methodName = mn;
        this.firePropertyChange(PROP_METHOD_NAME, old, mn);
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public void setMethodSignature(String signature) {
        if (signature != null) {
            signature = signature.trim();
        }
        if (Objects.equals(signature, this.methodSignature)) {
            return;
        }
        String old = this.methodSignature;
        this.methodSignature = signature;
        this.firePropertyChange(PROP_METHOD_SIGNATURE, old, signature);
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String cond) {
        if (cond != null) {
            cond = cond.trim();
        }
        String old = this.condition;
        this.condition = cond;
        this.firePropertyChange(PROP_CONDITION, old, cond);
    }

    public int getBreakpointType() {
        return this.breakpointType;
    }

    public void setBreakpointType(int breakpointType) {
        if (breakpointType == this.breakpointType) {
            return;
        }
        if ((breakpointType & 3) == 0) {
            throw new IllegalArgumentException();
        }
        int old = this.breakpointType;
        this.breakpointType = breakpointType;
        this.firePropertyChange(PROP_BREAKPOINT_TYPE, old, breakpointType);
    }

    public String[] getClassFilters() {
        return this.classFilters;
    }

    public void setClassFilters(String[] classFilters) {
        if (classFilters == this.classFilters) {
            return;
        }
        String[] old = this.classFilters;
        this.classFilters = classFilters;
        this.firePropertyChange(PROP_CLASS_FILTERS, old, classFilters);
    }

    public String[] getClassExclusionFilters() {
        return this.classExclusionFilters;
    }

    public void setClassExclusionFilters(String[] classExclusionFilters) {
        if (classExclusionFilters == this.classExclusionFilters) {
            return;
        }
        String[] old = this.classExclusionFilters;
        this.classExclusionFilters = classExclusionFilters;
        this.firePropertyChange(PROP_CLASS_EXCLUSION_FILTERS, old, classExclusionFilters);
    }

    public ObjectVariable[] getInstanceFilters(JPDADebugger session) {
        if (this.instanceFilters != null) {
            return this.instanceFilters.get(session);
        }
        return null;
    }

    public void setInstanceFilters(JPDADebugger session, ObjectVariable[] instances) {
        Object[] objectArray;
        if (this.instanceFilters == null) {
            this.instanceFilters = new WeakHashMap<JPDADebugger, ObjectVariable[]>();
        }
        if (instances != null) {
            this.instanceFilters.put(session, instances);
        } else {
            this.instanceFilters.remove(session);
        }
        if (instances != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = session;
            objectArray = objectArray2;
            objectArray2[1] = instances;
        } else {
            objectArray = null;
        }
        this.firePropertyChange(PROP_INSTANCE_FILTERS, null, objectArray);
    }

    public JPDAThread[] getThreadFilters(JPDADebugger session) {
        if (this.threadFilters != null) {
            return this.threadFilters.get(session);
        }
        return null;
    }

    public void setThreadFilters(JPDADebugger session, JPDAThread[] threads) {
        Object[] objectArray;
        if (this.threadFilters == null) {
            this.threadFilters = new WeakHashMap<JPDADebugger, JPDAThread[]>();
        }
        if (threads != null) {
            this.threadFilters.put(session, threads);
        } else {
            this.threadFilters.remove(session);
        }
        if (threads != null) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = session;
            objectArray = objectArray2;
            objectArray2[1] = threads;
        } else {
            objectArray = null;
        }
        this.firePropertyChange(PROP_THREAD_FILTERS, null, objectArray);
    }

    public String toString() {
        return "MethodBreakpoint " + Arrays.asList(this.classFilters).toString() + "." + this.methodName + (this.methodSignature != null ? " '" + this.methodSignature + "'" : "");
    }

    private static final class MethodBreakpointImpl
    extends MethodBreakpoint
    implements ChangeListener,
    PropertyChangeListener {
        private MethodBreakpointImpl() {
        }

        public Breakpoint.GroupProperties getGroupProperties() {
            return new MethodGroupProperties();
        }

        @Override
        public void stateChanged(ChangeEvent chev) {
            Object source = chev.getSource();
            if (!(source instanceof Breakpoint.VALIDITY)) {
                throw new UnsupportedOperationException(chev.toString());
            }
            this.setValidity((Breakpoint.VALIDITY)source, chev.toString());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.enginePropertyChange(evt);
        }

        private final class MethodGroupProperties
        extends Breakpoint.GroupProperties {
            private MethodGroupProperties() {
            }

            public String getType() {
                return NbBundle.getMessage(MethodBreakpoint.class, (String)"MethodBrkp_Type");
            }

            public String getLanguage() {
                return "Java";
            }

            public FileObject[] getFiles() {
                String[] filters = MethodBreakpointImpl.this.getClassFilters();
                String[] exfilters = MethodBreakpointImpl.this.getClassExclusionFilters();
                ArrayList<FileObject> files = new ArrayList<FileObject>();
                for (int i = 0; i < filters.length; ++i) {
                    if (filters[i].startsWith("*") || filters[i].endsWith("*")) continue;
                    JPDABreakpoint.fillFilesForClass(filters[i], files);
                }
                return files.toArray(new FileObject[0]);
            }

            public Project[] getProjects() {
                FileObject[] files = this.getFiles();
                ArrayList<Project> projects = new ArrayList<Project>();
                for (FileObject f : files) {
                    while (!(f == null || (f = f.getParent()) != null && ProjectManager.getDefault().isProject(f))) {
                    }
                    if (f == null) continue;
                    try {
                        projects.add(ProjectManager.getDefault().findProject(f));
                    }
                    catch (IOException iOException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                return projects.toArray(new Project[0]);
            }

            public DebuggerEngine[] getEngines() {
                return MethodBreakpointImpl.this.getEngines();
            }

            public boolean isHidden() {
                return MethodBreakpointImpl.this.isHidden();
            }
        }
    }
}

