/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.data;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.payara.tooling.data.DataException;

public enum PayaraAdminInterface {
    REST,
    HTTP;

    static final String REST_STR = "REST";
    static final String HTTP_STR = "HTTP";
    private static final Map<String, PayaraAdminInterface> stringValuesMap;

    public static PayaraAdminInterface toValue(String name) {
        if (name != null) {
            return stringValuesMap.get(name.toUpperCase());
        }
        return null;
    }

    public String toString() {
        switch (this.ordinal()) {
            case 0: {
                return REST_STR;
            }
            case 1: {
                return HTTP_STR;
            }
        }
        throw new DataException("Invalid Payara administration interface type");
    }

    static {
        stringValuesMap = new HashMap<String, PayaraAdminInterface>(PayaraAdminInterface.values().length);
        for (PayaraAdminInterface adminInterface : PayaraAdminInterface.values()) {
            stringValuesMap.put(adminInterface.toString().toUpperCase(), adminInterface);
        }
    }
}

