/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.rules.AbstractWebServiceRule;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.util.NbBundle;

public class InconsistentPortType
extends AbstractWebServiceRule {
    @Override
    protected ErrorDescription[] apply(TypeElement subject, ProblemContext ctx) {
        AnnotationMirror annEntity = Utilities.findAnnotation(subject, "javax.jws.WebService");
        if (subject.getKind() == ElementKind.CLASS && Utilities.getAnnotationAttrValue(annEntity, "endpointInterface") == null) {
            Service service = (Service)ctx.getLookup().lookup(Service.class);
            WSDLModel model = (WSDLModel)ctx.getLookup().lookup(WSDLModel.class);
            if (service != null && model != null && model.getState() == Model.State.VALID) {
                AnnotationValue nameVal;
                PortType portType = (PortType)model.findComponentByName(subject.getSimpleName().toString(), PortType.class);
                if (portType == null && (nameVal = Utilities.getAnnotationAttrValue(annEntity, "name")) != null) {
                    portType = (PortType)model.findComponentByName(nameVal.toString(), PortType.class);
                }
                if (portType == null) {
                    String label = NbBundle.getMessage(InconsistentPortType.class, (String)"MSG_InconsistentPortType");
                    AnnotationTree annotationTree = (AnnotationTree)ctx.getCompilationInfo().getTrees().getTree(subject, annEntity);
                    ExpressionTree problemTree = Utilities.getAnnotationArgumentTree(annotationTree, "wsdlLocation");
                    ctx.setElementToAnnotate(problemTree);
                    ErrorDescription problem = InconsistentPortType.createProblem((Element)subject, ctx, label, (Fix)null);
                    ctx.setElementToAnnotate(null);
                    return new ErrorDescription[]{problem};
                }
            }
        }
        return null;
    }
}

