/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.project;

import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.SearchInfoUtils;
import org.netbeans.modules.search.project.AbstractProjectSearchScope;
import org.netbeans.modules.search.project.spi.CompatibilityUtils;
import org.netbeans.spi.search.SearchFilterDefinition;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.netbeans.spi.search.SubTreeSearchOptions;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class SearchInfoHelper {
    static SearchInfo getSearchInfoForLookup(Lookup lookup) {
        SearchInfoDefinition sid = (SearchInfoDefinition)lookup.lookup(SearchInfoDefinition.class);
        if (sid != null) {
            return SearchInfoUtils.createForDefinition((SearchInfoDefinition)sid);
        }
        for (CompatibilityUtils cu : Lookup.getDefault().lookupAll(CompatibilityUtils.class)) {
            SearchInfo si = cu.getSearchInfoForLookup(lookup);
            if (si == null) continue;
            return si;
        }
        return null;
    }

    static SearchInfo getSearchInfoForNode(Node node) {
        SearchInfo subTreeSearchInfo;
        SearchInfo searchInfo = SearchInfoUtils.findDefinedSearchInfo((Node)node);
        if (searchInfo != null) {
            return searchInfo;
        }
        for (CompatibilityUtils cu : Lookup.getDefault().lookupAll(CompatibilityUtils.class)) {
            searchInfo = cu.getSearchInfoForNode(node);
            if (searchInfo == null) continue;
            return searchInfo;
        }
        Project p = (Project)node.getLookup().lookup(Project.class);
        Project ancestorProject = SearchInfoHelper.findAncestorProjectNode(node.getParentNode());
        if (p != null && ancestorProject == null) {
            return AbstractProjectSearchScope.createSingleProjectSearchInfo(p);
        }
        if (ancestorProject != null && (subTreeSearchInfo = SearchInfoHelper.findSearchInfoForProjectSubTree(ancestorProject, node)) != null) {
            return subTreeSearchInfo;
        }
        return SearchInfoUtils.getSearchInfoForNode((Node)node);
    }

    private static Project findAncestorProjectNode(Node node) {
        if (node == null) {
            return null;
        }
        Project p = (Project)node.getLookup().lookup(Project.class);
        if (p != null) {
            return p;
        }
        return SearchInfoHelper.findAncestorProjectNode(node.getParentNode());
    }

    private static SearchInfo findSearchInfoForProjectSubTree(Project ancestorProject, Node node) {
        DataObject dob;
        SubTreeSearchOptions stso = (SubTreeSearchOptions)ancestorProject.getLookup().lookup(SubTreeSearchOptions.class);
        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObject == null && (dob = (DataObject)node.getLookup().lookup(DataObject.class)) != null) {
            fileObject = dob.getPrimaryFile();
        }
        if (stso != null && fileObject != null) {
            return SearchInfoUtils.createSearchInfoForRoots((FileObject[])new FileObject[]{fileObject}, (boolean)false, (SearchFilterDefinition[])SearchInfoHelper.subTreeFilters(stso));
        }
        return null;
    }

    static SearchFilterDefinition[] subTreeFilters(SubTreeSearchOptions subTreeSearchOptions) {
        assert (subTreeSearchOptions != null);
        List list = subTreeSearchOptions.getFilters();
        SearchFilterDefinition[] array = list.toArray(new SearchFilterDefinition[0]);
        return array;
    }
}

