/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.oracle.bmc.Service;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.keymanagement.AbstractKmsCryptoClientBuilder;
import com.oracle.bmc.keymanagement.KmsCryptoAsyncClient;
import jakarta.annotation.Nonnull;

public class KmsCryptoAsyncClientBuilder
extends AbstractKmsCryptoClientBuilder<KmsCryptoAsyncClientBuilder, KmsCryptoAsyncClient> {
    public KmsCryptoAsyncClientBuilder(Service service) {
        super(service);
    }

    public KmsCryptoAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        if (authenticationDetailsProvider == null) {
            throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
        }
        String cryptoEndpoint = this.getEndpoint();
        KmsCryptoAsyncClientBuilder copy = (KmsCryptoAsyncClientBuilder)KmsCryptoAsyncClient.builder().copyFrom(this).endpoint(cryptoEndpoint);
        return new KmsCryptoAsyncClient(copy, authenticationDetailsProvider);
    }
}

