/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.breakpoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ActionsPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ConditionsPanel;
import org.netbeans.modules.debugger.jpda.ui.breakpoints.ControllerProvider;
import org.netbeans.spi.debugger.ui.Controller;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class LineBreakpointPanel
extends JPanel
implements ControllerProvider,
HelpCtx.Provider {
    private static final Logger logger = Logger.getLogger(LineBreakpointPanel.class.getName());
    private static final String HELP_ID = "NetbeansDebuggerBreakpointLineJPDA";
    private ConditionsPanel conditionsPanel;
    private ActionsPanel actionsPanel;
    private LineBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private LBController controller = new LBController();
    private final DocumentListener validityDocumentListener = new ValidityDocumentListener();
    private URL fileURL;
    private JPanel cPanel;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel pActions;
    private JPanel pSettings;
    private JTextField tfFileName;
    private JTextField tfLineNumber;

    private static LineBreakpoint createBreakpoint() {
        LineBreakpoint lb = LineBreakpoint.create((String)EditorContextDispatcher.getDefault().getMostRecentURLAsString(), (int)EditorContextDispatcher.getDefault().getMostRecentLineNumber());
        lb.setPrintText(NbBundle.getBundle(LineBreakpointPanel.class).getString("CTL_Line_Breakpoint_Print_Text"));
        return lb;
    }

    public LineBreakpointPanel() {
        this(LineBreakpointPanel.createBreakpoint(), true);
    }

    public LineBreakpointPanel(LineBreakpoint b) {
        this(b, false);
    }

    public LineBreakpointPanel(LineBreakpoint b, boolean createBreakpoint) {
        this.createBreakpoint = createBreakpoint;
        this.breakpoint = b;
        this.initComponents();
        if (createBreakpoint) {
            this.tfFileName.setEditable(true);
        }
        String urlStr = b.getURL();
        logger.fine("LineBreakpointPanel(" + urlStr + ")");
        try {
            String s;
            URL url = new URL(urlStr);
            String protocol = url.getProtocol();
            if ("file".equalsIgnoreCase(protocol)) {
                s = url.toURI().getPath();
                if (s.length() == 0) {
                    s = urlStr;
                } else {
                    this.fileURL = url;
                }
            } else {
                s = urlStr;
            }
            logger.fine("Path/URL = " + s);
            this.tfFileName.setText(s);
        }
        catch (Exception e) {
            this.tfFileName.setText(urlStr);
        }
        this.tfFileName.setPreferredSize(new Dimension(30 * this.tfFileName.getFontMetrics(this.tfFileName.getFont()).charWidth('W'), this.tfFileName.getPreferredSize().height));
        this.tfLineNumber.setText(Integer.toString(b.getLineNumber()));
        this.conditionsPanel = new ConditionsPanel(HELP_ID);
        this.setupConditionPane();
        this.conditionsPanel.showClassFilter(false);
        this.conditionsPanel.setCondition(b.getCondition());
        this.conditionsPanel.setHitCountFilteringStyle(b.getHitCountFilteringStyle());
        this.conditionsPanel.setHitCount(b.getHitCountFilter());
        this.cPanel.add((Component)this.conditionsPanel, "Center");
        this.actionsPanel = new ActionsPanel((JPDABreakpoint)b);
        this.pActions.add((Component)this.actionsPanel, "Center");
        this.tfFileName.getDocument().addDocumentListener(this.validityDocumentListener);
        this.tfLineNumber.getDocument().addDocumentListener(this.validityDocumentListener);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LineBreakpointPanel.this.controller.checkValid();
            }
        });
    }

    private static int findNumLines(FileObject file) {
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return 0;
        }
        EditorCookie ec = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (ec == null) {
            return 0;
        }
        ec.prepareDocument().waitFinished();
        StyledDocument d = ec.getDocument();
        if (!(d instanceof StyledDocument)) {
            return 0;
        }
        StyledDocument sd = d;
        return NbDocument.findLineNumber((StyledDocument)sd, (int)sd.getLength());
    }

    private void setupConditionPane() {
        this.conditionsPanel.setupConditionPaneContext(this.breakpoint.getURL(), this.breakpoint.getLineNumber());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.jLabel3 = new JLabel();
        this.tfFileName = new JTextField();
        this.jLabel1 = new JLabel();
        this.tfLineNumber = new JTextField();
        this.cPanel = new JPanel();
        this.pActions = new JPanel();
        this.jPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/debugger/jpda/ui/breakpoints/Bundle");
        this.pSettings.setBorder(BorderFactory.createTitledBorder(bundle.getString("L_Line_Breakpoint_BorderTitle")));
        this.pSettings.setLayout(new GridBagLayout());
        this.jLabel3.setLabelFor(this.tfFileName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)bundle.getString("L_Line_Breakpoint_File_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_L_Line_Breakpoint_File_Name"));
        this.tfFileName.setEditable(false);
        this.tfFileName.setToolTipText(bundle.getString("TTT_TF_Line_Breakpoint_File_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfFileName, gridBagConstraints);
        this.tfFileName.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TF_Line_Breakpoint_File_Name"));
        this.jLabel1.setLabelFor(this.tfLineNumber);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)bundle.getString("L_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_L_Line_Breakpoint_Line_Number"));
        this.tfLineNumber.setToolTipText(bundle.getString("TTT_TF_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfLineNumber, gridBagConstraints);
        this.tfLineNumber.getAccessibleContext().setAccessibleName("Line number");
        this.tfLineNumber.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_TF_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.cPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.cPanel, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LineBreakpointPanel.class, (String)"ACSN_LineBreakpoint"));
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    private class LBController
    implements Controller {
        private boolean valid;
        private String errMsg = null;

        private LBController() {
        }

        public boolean ok() {
            if (!this.valid) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.errMsg));
                return false;
            }
            LineBreakpointPanel.this.actionsPanel.ok();
            String path = LineBreakpointPanel.this.tfFileName.getText().trim();
            logger.fine("O.K.: path = '" + path + "'");
            URL url = this.getURL(path);
            logger.fine("      => URL = '" + url + "'");
            LineBreakpointPanel.this.breakpoint.setURL(url != null ? url.toString() : path);
            LineBreakpointPanel.this.breakpoint.setLineNumber(Integer.parseInt(LineBreakpointPanel.this.tfLineNumber.getText().trim()));
            LineBreakpointPanel.this.breakpoint.setCondition(LineBreakpointPanel.this.conditionsPanel.getCondition());
            LineBreakpointPanel.this.breakpoint.setHitCountFilter(LineBreakpointPanel.this.conditionsPanel.getHitCount(), LineBreakpointPanel.this.conditionsPanel.getHitCountFilteringStyle());
            if (LineBreakpointPanel.this.createBreakpoint) {
                DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)LineBreakpointPanel.this.breakpoint);
            }
            return true;
        }

        public boolean cancel() {
            return true;
        }

        private void checkValid() {
            int line;
            String path = LineBreakpointPanel.this.tfFileName.getText().trim();
            logger.fine("checkValid: path = '" + path + "'");
            if (path.length() == 0) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_No_File_Spec"));
                this.setValid(false);
                return;
            }
            URL url = this.getURL(path);
            logger.fine("  url = '" + url + "'");
            FileObject fo = null;
            if (url != null) {
                fo = URLMapper.findFileObject((URL)url);
            }
            logger.fine("  => FileObject = '" + fo + "'");
            if (fo == null) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_NonExistent_File_Spec"));
                this.setValid(false);
                return;
            }
            if (!"text/x-java".equals(fo.getMIMEType())) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_NonJava_File_Spec"));
                this.setValid(false);
                return;
            }
            try {
                line = Integer.parseInt(LineBreakpointPanel.this.tfLineNumber.getText().trim());
            }
            catch (NumberFormatException e) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_No_Line_Number_Spec"));
                this.setValid(false);
                return;
            }
            if (line <= 0) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_NonPositive_Line_Number_Spec"));
                this.setValid(false);
                return;
            }
            int maxLine = LineBreakpointPanel.findNumLines(fo);
            logger.fine("  => maxLine = '" + maxLine + "'");
            if (maxLine == 0) {
                maxLine = 0x7FFFFFFE;
            }
            if (line > maxLine + 1) {
                this.setErrorMessage(NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_TooBig_Line_Number_Spec", (Object)Integer.toString(line), (Object)Integer.toString(maxLine + 1)));
                this.setValid(false);
                return;
            }
            this.setErrorMessage(null);
            this.setValid(true);
        }

        private URL getURL(String path) {
            URL url = null;
            if (LineBreakpointPanel.this.fileURL != null) {
                String q = LineBreakpointPanel.this.fileURL.getQuery();
                try {
                    URI uri = new URI(LineBreakpointPanel.this.fileURL.getProtocol(), null, LineBreakpointPanel.this.fileURL.getHost(), LineBreakpointPanel.this.fileURL.getPort(), path, q, null);
                    try {
                        url = uri.toURL();
                    }
                    catch (MalformedURLException ex) {
                        logger.log(Level.INFO, "Malformed url protocol '" + LineBreakpointPanel.this.fileURL.getProtocol() + "', from " + LineBreakpointPanel.this.fileURL + ", path = '" + path + "', uri = " + uri, ex);
                    }
                }
                catch (URISyntaxException ex) {
                    logger.log(Level.INFO, "Malformed URI: scheme '" + LineBreakpointPanel.this.fileURL.getProtocol() + "', from " + LineBreakpointPanel.this.fileURL + ", path = '" + path + "'", ex);
                }
            }
            if (url == null) {
                try {
                    url = new URL(path);
                }
                catch (MalformedURLException ex) {
                    logger.log(Level.INFO, "Malformed url '" + path + "'", ex);
                }
            }
            return url;
        }

        private void setValid(boolean valid) {
            this.valid = valid;
            LineBreakpointPanel.this.firePropertyChange("valid", !valid, valid);
        }

        public boolean isValid() {
            return this.valid;
        }

        private void setErrorMessage(String msg) {
            this.errMsg = msg;
            LineBreakpointPanel.this.firePropertyChange("errorNotification", null, msg);
        }

        private void setInformationMessage(String msg) {
            LineBreakpointPanel.this.firePropertyChange("infoNotification", null, msg);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            LineBreakpointPanel.this.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            LineBreakpointPanel.this.removePropertyChangeListener(l);
        }
    }

    private class ValidityDocumentListener
    implements DocumentListener {
        private ValidityDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            LineBreakpointPanel.this.controller.checkValid();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            LineBreakpointPanel.this.controller.checkValid();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            LineBreakpointPanel.this.controller.checkValid();
        }
    }
}

