/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.java.hints.errors.Bundle;
import org.netbeans.modules.java.hints.errors.ModificationResultBasedFix;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.impl.APIAccessor;
import org.netbeans.modules.refactoring.api.impl.SPIAccessor;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.modules.refactoring.java.api.ChangeParametersRefactoring;
import org.netbeans.modules.refactoring.java.api.ui.JavaRefactoringActionsFactory;
import org.netbeans.modules.refactoring.java.spi.hooks.JavaModificationResult;
import org.netbeans.modules.refactoring.spi.ModificationResult;
import org.netbeans.modules.refactoring.spi.RefactoringCommit;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;

public final class ChangeParametersFix
extends ModificationResultBasedFix
implements Fix {
    private final boolean doFullRefactoring;
    private final TreePathHandle tph;
    private final String declaration;
    private final String newDeclaration;
    private final ChangeParametersRefactoring.ParameterInfo[] newParameterInfo;
    private final Set<Modifier> modifiers;
    private final boolean isConstr;

    public ChangeParametersFix(boolean doFullRefactoring, TreePathHandle tph, Set<Modifier> modifiers, String declaration, String newDeclaration, ChangeParametersRefactoring.ParameterInfo[] newParameterInfo, boolean isConstr) {
        this.doFullRefactoring = doFullRefactoring;
        this.tph = tph;
        this.modifiers = modifiers;
        this.declaration = declaration;
        this.newDeclaration = newDeclaration;
        this.newParameterInfo = newParameterInfo;
        this.isConstr = isConstr;
    }

    public String getText() {
        return this.isConstr ? Bundle.LBL_FIX_ChangeConstructorParameters(this.declaration, this.newDeclaration) : Bundle.LBL_FIX_ChangeMethodParameters(this.declaration, this.newDeclaration);
    }

    public ChangeInfo implement() throws Exception {
        if (this.doFullRefactoring) {
            ChangeParametersFix.doFullChangeMethodParameters(this.tph, this.newParameterInfo);
            return null;
        }
        RefactoringSession session = this.getRefactoringSession(true);
        if (session != null && session.doRefactoring(false) != null) {
            ChangeParametersFix.doFullChangeMethodParameters(this.tph, this.newParameterInfo);
        }
        return null;
    }

    @Override
    public List<org.netbeans.api.java.source.ModificationResult> getModificationResults() throws IOException {
        ArrayList<org.netbeans.api.java.source.ModificationResult> results = new ArrayList<org.netbeans.api.java.source.ModificationResult>();
        RefactoringSession session = this.getRefactoringSession(false);
        if (session != null) {
            List transactions = APIAccessor.DEFAULT.getCommits(session);
            for (Transaction t : transactions) {
                if (t instanceof RefactoringCommit) {
                    RefactoringCommit c = (RefactoringCommit)t;
                    for (ModificationResult refResult : SPIAccessor.DEFAULT.getTransactions(c)) {
                        if (refResult instanceof JavaModificationResult) {
                            results.add(((JavaModificationResult)refResult).delegate);
                            continue;
                        }
                        throw new IllegalStateException(refResult.getClass().toString());
                    }
                    continue;
                }
                throw new IllegalStateException(t.getClass().toString());
            }
        }
        return results;
    }

    @Override
    public org.netbeans.api.java.source.ModificationResult getModificationResult() throws IOException {
        return null;
    }

    private RefactoringSession getRefactoringSession(boolean allowFullRefactoring) {
        ChangeParametersRefactoring refactoring = new ChangeParametersRefactoring(this.tph);
        refactoring.setParameterInfo(new ChangeParametersRefactoring.ParameterInfo[0]);
        refactoring.setModifiers(this.modifiers);
        refactoring.setParameterInfo(this.newParameterInfo);
        RefactoringSession session = RefactoringSession.create((String)"ChangeMethodParameterHint");
        Problem problem = null;
        problem = refactoring.preCheck();
        if (problem != null) {
            if (allowFullRefactoring) {
                ChangeParametersFix.doFullChangeMethodParameters(this.tph, this.newParameterInfo);
            }
            return null;
        }
        problem = refactoring.prepare(session);
        if (problem != null) {
            if (allowFullRefactoring) {
                ChangeParametersFix.doFullChangeMethodParameters(this.tph, this.newParameterInfo);
            }
            return null;
        }
        return session;
    }

    private static void doFullChangeMethodParameters(TreePathHandle tph, ChangeParametersRefactoring.ParameterInfo[] newParameterInfo) {
        InstanceContent ic = new InstanceContent();
        ic.add((Object)tph);
        ic.add((Object)new AbstractNode(Children.LEAF, Lookups.singleton((Object)tph)));
        for (ChangeParametersRefactoring.ParameterInfo parameterInfo : newParameterInfo) {
            ic.add((Object)parameterInfo);
        }
        AbstractLookup actionContext = new AbstractLookup((AbstractLookup.Content)ic);
        final Action a = JavaRefactoringActionsFactory.changeParametersAction().createContextAwareInstance((Lookup)actionContext);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                a.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
            }
        });
    }
}

