/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl.client;

import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.client.STSIssuedTokenConfiguration;
import com.sun.xml.ws.api.security.trust.client.SecondaryIssuedTokenParameters;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.addressing.policy.Address;
import com.sun.xml.ws.security.policy.IssuedToken;
import com.sun.xml.ws.security.policy.Issuer;
import com.sun.xml.ws.security.policy.RequestSecurityTokenTemplate;
import com.sun.xml.ws.security.secext10.AttributedString;
import com.sun.xml.ws.security.secext10.BinarySecurityTokenType;
import com.sun.xml.ws.security.secext10.ObjectFactory;
import com.sun.xml.ws.security.secext10.UsernameTokenType;
import com.sun.xml.ws.security.trust.GenericToken;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.impl.client.SecondaryIssuedTokenParametersImpl;
import java.net.URI;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Element;

public class DefaultSTSIssuedTokenConfiguration
extends STSIssuedTokenConfiguration {
    private static final String PRE_CONFIGURED_STS = "PreconfiguredSTS";
    private static final String NAMESPACE = "namespace";
    private static final String CONFIG_NAMESPACE = "";
    private static final String ENDPOINT = "endPoint";
    private static final String METADATA = "metadata";
    private static final String WSDL_LOCATION = "wsdlLocation";
    private static final String SERVICE_NAME = "serviceName";
    private static final String PORT_NAME = "portName";
    private static final String REQUEST_SECURITY_TOKEN_TEMPLATE = "RequestSecurityTokenTemplate";
    private static final String CLAIMS = "Claims";
    private static final String DIALECT = "Dialect";
    private static final String IDENTITY = "Identity";
    private static final String WST_VERSION = "wstVersion";
    private String tokenType = null;
    private String keyType = null;
    private long keySize = -1L;
    private String signatureAlg = null;
    private String encAlg = null;
    private String canAlg = null;
    private String keyWrapAlg = null;
    private Token oboToken = null;
    private String signWith = null;
    private String encryptWith = null;
    private Claims claims = null;

    public DefaultSTSIssuedTokenConfiguration() {
    }

    public DefaultSTSIssuedTokenConfiguration(String protocol, IssuedToken issuedToken, PolicyAssertion localToken) {
        if (protocol != null) {
            this.protocol = protocol;
        }
        this.parseAssertions(issuedToken, localToken);
    }

    public DefaultSTSIssuedTokenConfiguration(String stsEndpoint, String stsMEXAddress) {
        super(stsEndpoint, stsMEXAddress);
    }

    public DefaultSTSIssuedTokenConfiguration(String stsEndpoint, String stsWSDLLocation, String stsServiceName, String stsPortName, String stsNamespace) {
        super(stsEndpoint, stsWSDLLocation, stsServiceName, stsPortName, stsNamespace);
    }

    public DefaultSTSIssuedTokenConfiguration(String protocol, String stsEndpoint, String stsMEXAddress) {
        super(protocol, stsEndpoint, stsMEXAddress);
    }

    public DefaultSTSIssuedTokenConfiguration(String protocol, String stsEndpoint, String stsWSDLLocation, String stsServiceName, String stsPortName, String stsNamespace) {
        super(protocol, stsEndpoint, stsWSDLLocation, stsServiceName, stsPortName, stsNamespace);
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setSTSInfo(String stsEndpoint, String stsMEXAddress) {
        this.stsEndpoint = stsEndpoint;
        this.stsMEXAddress = stsMEXAddress;
    }

    public void setSTSInfo(String protocol, String stsEndpoint, String stsWSDLLocation, String stsServiceName, String stsPortName, String stsNamespace) {
        this.protocol = protocol;
        this.stsEndpoint = stsEndpoint;
        this.stsWSDLLocation = stsWSDLLocation;
        this.stsServiceName = stsServiceName;
        this.stsPortName = stsPortName;
        this.stsNamespace = stsNamespace;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setKeySize(long keySize) {
        this.keySize = keySize;
    }

    public void setSignWith(String signWithAlg) {
        this.signWith = signWithAlg;
    }

    public void setEncryptWith(String encWithAlg) {
        this.encryptWith = encWithAlg;
    }

    public void setSignatureAlgorithm(String sigAlg) {
        this.signatureAlg = sigAlg;
    }

    public void setEncryptionAlgorithm(String encAlg) {
        this.encAlg = encAlg;
    }

    public void setCanonicalizationAlgorithm(String canAlg) {
        this.canAlg = canAlg;
    }

    public void setKeyWrapAlgorithm(String keyWrapAlg) {
        this.keyWrapAlg = keyWrapAlg;
    }

    public void setClaims(Claims claims) {
        this.claims = claims;
    }

    public void setOBOToken(Token token) {
        this.oboToken = token;
    }

    public void setOBOToken(String username, String password) {
        this.oboToken = this.createUsernameToken(username, password);
    }

    public void setOBOToken(X509Certificate cert) {
        this.oboToken = this.createBinaryTokenForCertificate(cert);
    }

    public void setActAsToken(String username, String password) {
        this.getOtherOptions().put("ActAs", this.createUsernameToken(username, password));
    }

    public void setActAsToken(X509Certificate cert) {
        this.getOtherOptions().put("ActAs", this.createBinaryTokenForCertificate(cert));
    }

    @Override
    public String getTokenType() {
        return this.tokenType;
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    @Override
    public long getKeySize() {
        return this.keySize;
    }

    @Override
    public String getSignatureAlgorithm() {
        return this.signatureAlg;
    }

    @Override
    public String getEncryptionAlgorithm() {
        return this.encAlg;
    }

    @Override
    public String getCanonicalizationAlgorithm() {
        return this.canAlg;
    }

    @Override
    public String getKeyWrapAlgorithm() {
        return this.keyWrapAlg;
    }

    @Override
    public String getSignWith() {
        return this.signWith;
    }

    @Override
    public String getEncryptWith() {
        return this.encryptWith;
    }

    @Override
    public Claims getClaims() {
        return this.claims;
    }

    @Override
    public Token getOBOToken() {
        return this.oboToken;
    }

    public void setSecondaryIssuedTokenParameters(SecondaryIssuedTokenParameters sisPara) {
        this.sisPara = sisPara;
    }

    private void parseAssertions(IssuedToken issuedToken, PolicyAssertion localToken) {
        RequestSecurityTokenTemplate rstt;
        Issuer issuer = issuedToken.getIssuer();
        URI stsURI = null;
        if (issuer != null) {
            stsURI = issuedToken.getIssuer().getAddress().getURI();
            if (issuer.getIdentity() != null) {
                this.getOtherOptions().put(IDENTITY, issuer.getIdentity());
            }
        }
        if (stsURI != null) {
            URI metadataIssuerAddressURI;
            this.stsEndpoint = stsURI.toString();
            Address metadataIssuerAddress = issuer.getMetadataAddress();
            if (metadataIssuerAddress != null && (metadataIssuerAddressURI = metadataIssuerAddress.getURI()) != null) {
                this.stsMEXAddress = metadataIssuerAddressURI.toString();
            }
            if (this.stsMEXAddress == null) {
                this.stsMEXAddress = this.stsEndpoint + "/mex";
            }
        }
        String stsProtocol = null;
        if (localToken != null && PRE_CONFIGURED_STS.equals(localToken.getName().getLocalPart())) {
            String maxClockSkew;
            String renewExpiredToken;
            String shareToken;
            Map<QName, String> attrs = localToken.getAttributes();
            stsProtocol = this.trim(attrs.get(new QName(CONFIG_NAMESPACE, WST_VERSION)));
            if (stsURI == null) {
                this.stsNamespace = this.trim(attrs.get(new QName(CONFIG_NAMESPACE, NAMESPACE)));
                this.stsEndpoint = this.trim(attrs.get(new QName(CONFIG_NAMESPACE, ENDPOINT)));
                if (this.stsEndpoint == null) {
                    this.stsEndpoint = this.trim(attrs.get(new QName(CONFIG_NAMESPACE, ENDPOINT.toLowerCase())));
                }
                this.stsMEXAddress = this.trim(attrs.get(new QName(CONFIG_NAMESPACE, METADATA)));
                if (this.stsMEXAddress == null) {
                    this.stsWSDLLocation = this.trim(attrs.get(new QName(CONFIG_NAMESPACE, WSDL_LOCATION)));
                    this.stsServiceName = this.trim(attrs.get(new QName(CONFIG_NAMESPACE, SERVICE_NAME)));
                    this.stsPortName = this.trim(attrs.get(new QName(CONFIG_NAMESPACE, PORT_NAME)));
                }
            }
            if ("true".equals(shareToken = attrs.get(new QName(CONFIG_NAMESPACE, "shareToken")))) {
                this.getOtherOptions().put("shareToken", shareToken);
            }
            if ("true".equals(renewExpiredToken = attrs.get(new QName(CONFIG_NAMESPACE, "renewExpiredToken")))) {
                this.getOtherOptions().put("renewExpiredToken", renewExpiredToken);
            }
            if ((maxClockSkew = attrs.get(new QName(CONFIG_NAMESPACE, "MaxClockSkew"))) != null) {
                this.getOtherOptions().put("MaxClockSkew", maxClockSkew);
            }
            if (localToken.hasParameters()) {
                Iterator<PolicyAssertion> pas = localToken.getParametersIterator();
                while (pas.hasNext()) {
                    PolicyAssertion pa = pas.next();
                    if (!"LifeTime".equals(pa.getName().getLocalPart())) continue;
                    this.getOtherOptions().put("LifeTime", Integer.parseInt(pa.getValue()));
                    break;
                }
            }
        }
        if (stsProtocol == null) {
            stsProtocol = this.protocol;
        }
        if ((rstt = issuedToken.getRequestSecurityTokenTemplate()) != null) {
            Claims claims = null;
            if (this.protocol.equals(WSTrustVersion.WS_TRUST_13.getNamespaceURI())) {
                if (issuedToken.getClaims() != null) {
                    claims = this.getClaims(issuedToken, stsProtocol);
                }
            } else if (rstt.getClaims() != null) {
                claims = this.getClaims(issuedToken, stsProtocol);
            }
            if (!this.protocol.equals(stsProtocol)) {
                this.copy(rstt, stsProtocol, this.protocol);
                this.setClaims(claims);
                this.protocol = stsProtocol;
            } else if (this.protocol.equals(WSTrustVersion.WS_TRUST_13.getNamespaceURI())) {
                SecondaryIssuedTokenParametersImpl sitp = new SecondaryIssuedTokenParametersImpl();
                this.copy(rstt, sitp);
                sitp.setClaims(claims);
                this.sisPara = sitp;
            } else {
                this.copy(rstt);
                this.setClaims(claims);
            }
        }
    }

    private Claims getClaims(IssuedToken issuedToken, String stsWstProtocol) {
        Claims cs = null;
        try {
            if (this.protocol.equals(WSTrustVersion.WS_TRUST_13.getNamespaceURI())) {
                Element claimsEle = issuedToken.getClaims().getClaimsAsElement();
                cs = WSTrustElementFactory.newInstance(WSTrustVersion.WS_TRUST_13.getNamespaceURI()).createClaims(claimsEle);
            } else {
                RequestSecurityTokenTemplate rstt = issuedToken.getRequestSecurityTokenTemplate();
                Element claimsEle = rstt.getClaims().getClaimsAsElement();
                cs = WSTrustElementFactory.newInstance(WSTrustVersion.WS_TRUST_10.getNamespaceURI()).createClaims(claimsEle);
            }
            cs = WSTrustElementFactory.newInstance(WSTrustVersion.getInstance(stsWstProtocol)).createClaims(cs);
        }
        catch (Exception e) {
            throw new WebServiceException(e);
        }
        return cs;
    }

    private void copy(RequestSecurityTokenTemplate rstt) {
        this.setTokenType(this.trim(rstt.getTokenType()));
        this.setKeyType(this.trim(rstt.getKeyType()));
        this.setKeySize(rstt.getKeySize());
        this.setSignWith(this.trim(rstt.getSignWith()));
        this.setEncryptWith(this.trim(rstt.getEncryptWith()));
        this.setSignatureAlgorithm(this.trim(rstt.getSignatureAlgorithm()));
        this.setEncryptionAlgorithm(this.trim(rstt.getEncryptionAlgorithm()));
        this.setCanonicalizationAlgorithm(this.trim(rstt.getCanonicalizationAlgorithm()));
    }

    private void copy(RequestSecurityTokenTemplate rstt, SecondaryIssuedTokenParametersImpl sitp) {
        sitp.setTokenType(this.trim(rstt.getTokenType()));
        sitp.setKeyType(this.trim(rstt.getKeyType()));
        sitp.setKeySize(rstt.getKeySize());
        sitp.setSignWith(this.trim(rstt.getSignWith()));
        sitp.setEncryptWith(this.trim(rstt.getEncryptWith()));
        sitp.setSignatureAlgorithm(this.trim(rstt.getSignatureAlgorithm()));
        sitp.setEncryptionAlgorithm(this.trim(rstt.getEncryptionAlgorithm()));
        sitp.setCanonicalizationAlgorithm(this.trim(rstt.getCanonicalizationAlgorithm()));
        sitp.setKeyWrapAlgorithm(this.trim(rstt.getKeyWrapAlgorithm()));
    }

    private void copy(RequestSecurityTokenTemplate rstt, String stsWstProtocol, String serviceWstProtocol) {
        WSTrustVersion stsWstVer = WSTrustVersion.getInstance(stsWstProtocol);
        WSTrustVersion serviceWstVer = WSTrustVersion.getInstance(serviceWstProtocol);
        String rsttKeyType = this.trim(rstt.getKeyType());
        if (serviceWstVer.getPublicKeyTypeURI().equals(rsttKeyType)) {
            this.setKeyType(stsWstVer.getPublicKeyTypeURI());
        } else if (serviceWstVer.getSymmetricKeyTypeURI().equals(rsttKeyType)) {
            this.setKeyType(stsWstVer.getSymmetricKeyTypeURI());
        } else if (serviceWstVer.getBearerKeyTypeURI().equals(rsttKeyType)) {
            this.setKeyType(stsWstVer.getBearerKeyTypeURI());
        }
        this.setTokenType(this.trim(rstt.getTokenType()));
        this.setKeySize(rstt.getKeySize());
        this.setSignWith(this.trim(rstt.getSignWith()));
        this.setEncryptWith(this.trim(rstt.getEncryptWith()));
        this.setSignatureAlgorithm(this.trim(rstt.getSignatureAlgorithm()));
        this.setEncryptionAlgorithm(this.trim(rstt.getEncryptionAlgorithm()));
        this.setCanonicalizationAlgorithm(this.trim(rstt.getCanonicalizationAlgorithm()));
    }

    public void copy(STSIssuedTokenConfiguration config) {
        if (config.getProtocol() != null) {
            this.protocol = config.getProtocol();
        }
        if (this.stsEndpoint == null && config.getSTSEndpoint() != null) {
            this.stsEndpoint = config.getSTSEndpoint();
            if (config.getSTSMEXAddress() != null) {
                this.stsMEXAddress = config.getSTSMEXAddress();
            } else if (config.getSTSWSDLLocation() != null) {
                this.stsWSDLLocation = config.getSTSWSDLLocation();
                this.stsServiceName = config.getSTSServiceName();
                this.stsPortName = config.getSTSPortName();
                this.stsNamespace = config.getSTSNamespace();
            }
        }
        if (this.tokenType == null && config.getTokenType() != null) {
            this.tokenType = config.getTokenType();
        }
        if (this.keyType == null && config.getKeyType() != null) {
            this.keyType = config.getKeyType();
        }
        if (this.keySize < 1L && config.getKeySize() > 0L) {
            this.keySize = config.getKeySize();
        }
        if (this.signatureAlg == null && config.getSignatureAlgorithm() != null) {
            this.signatureAlg = config.getSignatureAlgorithm();
        }
        if (this.encAlg == null && config.getEncryptionAlgorithm() != null) {
            this.encAlg = config.getEncryptionAlgorithm();
        }
        if (config.getCanonicalizationAlgorithm() != null) {
            this.canAlg = config.getCanonicalizationAlgorithm();
        }
        if (this.keyWrapAlg == null && config.getKeyWrapAlgorithm() != null) {
            this.keyWrapAlg = config.getKeyWrapAlgorithm();
        }
        if (this.signWith == null && config.getSignWith() != null) {
            this.signWith = config.getSignWith();
        }
        if (this.encryptWith == null && config.getEncryptWith() != null) {
            this.encryptWith = config.getEncryptWith();
        }
        if (config.getOBOToken() != null) {
            this.oboToken = config.getOBOToken();
        }
        if (this.claims == null && config.getClaims() != null) {
            this.claims = config.getClaims();
        }
        this.getOtherOptions().putAll(config.getOtherOptions());
        if (config.getOtherOptions().containsKey("IssuedToken")) {
            this.getOtherOptions().remove("IssuedToken");
        }
    }

    private Token createUsernameToken(String username, String password) {
        ObjectFactory fact = new ObjectFactory();
        UsernameTokenType ut = fact.createUsernameTokenType();
        AttributedString un = fact.createAttributedString();
        un.setValue(username);
        AttributedString pwd = fact.createAttributedString();
        pwd.setValue(password);
        ut.setUsername(un);
        ut.setPassword(pwd);
        return new GenericToken(fact.createUsernameToken(ut));
    }

    private Token createBinaryTokenForCertificate(X509Certificate cert) {
        ObjectFactory fact = new ObjectFactory();
        BinarySecurityTokenType bst = fact.createBinarySecurityTokenType();
        bst.setValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3");
        bst.setEncodingType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        try {
            bst.setValue(cert.getEncoded());
        }
        catch (CertificateEncodingException ex) {
            throw new RuntimeException(ex);
        }
        return new GenericToken(fact.createBinarySecurityToken(bst));
    }

    private String trim(String uriStr) {
        if (uriStr != null) {
            return uriStr.trim();
        }
        return uriStr;
    }
}

